#
# This contains the tutorial program... 
#

proc tut_build_widgets {} {
    global LIBRARY_DIR Resources
    
    toplevel .tut
    wm positionfrom .tut user
    wm title .tut "Tutorial"

    ######################
    ### information frame
    ######################

    frame .tut.info
    frame .tut.info.desc 
    text .tut.info.desc.text -width 80 -height 15 \
	-yscrollcommand ".tut.info.desc.sb set" -wrap word \
	-font $Resources(font1)
    scrollbar .tut.info.desc.sb \
	-command ".tut.info.desc.text yview"
    pack configure .tut.info.desc.text -side right -fill y -expand 1
    pack configure .tut.info.desc.sb -side left -fill y -expand 1
    
    pack configure .tut.info.desc -side left -fill y -expand 1 
    
    ######################
    ### command buttons
    ######################
    
    frame .tut.buttons
    button .tut.buttons.previous -text "Previous Page" \
	-command "tut_previous_page" -padx 10 -pady 5
    button .tut.buttons.next -text "Next Page" \
	-command "tut_next_page" -padx 10 -pady 5
    button .tut.buttons.back -text "Back" \
	-command "tut_back_page" -padx 10 -pady 5
    button .tut.buttons.done -text "Done" \
	-command "tut_up_level" -padx 10 -pady 5
    
    pack configure .tut.buttons.previous -side left -padx 15
    pack configure .tut.buttons.next -side left -padx 15
    pack configure .tut.buttons.back -side left -padx 15
    pack configure .tut.buttons.done -side right -padx 25
    
    pack configure .tut.info -side top
    pack configure .tut.buttons -side bottom -fill x -expand 1

}    
    

proc tut_check_mode {line} {
    
    case $line in {
	"<TITLE>" {return "title"}
	"<H1>" {return "h1"}
	"<H2>" {return "h2"} 
	"<P>"  {return "p"}
    }
    return -1
}

proc tut_find_next_mode {s} {
    set list [list <TITLE> <H1> <H2> <H3>] 
    set end [string length $s]
    set smallest [list $end $end]
    foreach term $list {
	set i [regexp -nocase -indices $term $s match]
	if {$i} {
	    if {[lindex $match 0] < $end} {
		set end [lindex $match 0]
		set smallest $match
	    }
	}
    }
    return $smallest
}

    

#
# This procedure returns a list of the following elements :
# elem 0 - font to use
# elem 1 - list of strings or references.  Strings begin with a #,
#          while references begin with a percent.
# elem 2 - the remainder of the string which was unparsed.

proc tut_parse_mode {s} {
    global Resources 

    set s [string trim $s]
    set l [tut_find_next_mode $s]
    set i [lindex $l 0]
    set j [lindex $l 1]
    if {$i == 0} {
	set mode [string range $s [expr $i+1] [expr $j-1]]
	puts stdout "MODE = $mode"
	set s [string range $s [expr $j+1] end]
	set i [string first "</$mode>" $s]
	set mode [string tolower $mode]
	set text [string range $s 0 [expr $i-1]]
	if {$mode != "title"} {
	    set text "\n[string trim $text]\n"
	} else {
	    set text "[string trim $text]\n"
	}
	set s [string range $s [expr $i+[string length "</$mode>"]] end]
	puts stdout "text is : '$text'."
    } else {
	set mode ""
	set j [lindex [tut_find_next_mode $s] 0]
	set text [string range $s 0 [expr $j-1]]
	set s [string range $s $j end]
    }
    set i [string first "<A" $text]
    while {$i != -1} {
	set stemp "#[string range $text 0 [expr $i-1]]"
	set j [string first "</A>" $text]
	set ref "%[string range $text [expr $i+2] [expr $j-1]]"
	set text [string range $text [expr $j+4] end]
	puts stdout "Reference found : $ref\n$text."
	lappend ltemp $stemp
	lappend ltemp $ref
	set i [string first "<A" $text]
    }
    lappend ltemp "#$text"
    case $mode in {
	"title" {set font $Resources(font4)}
	"h1"    {set font $Resources(font3)}
	"h2"    {set font $Resources(font2)}
	"h3"    {set font $Resources(font1)}
	default {set font $Resources(font1)}
    }
    puts stdout "Done"
    return [list $font $ltemp $s]
}


proc tut_load_page {page} {
    global LIBRARY_DIR Resources Tutorial

    set w .tut.info.desc.text
    if {![file exists $LIBRARY_DIR/tutorial/$page]} {
	error "Unable to load tutorial page '$page'.  File does not exist."
	return
    }
    set i [catch {set file [open $LIBRARY_DIR/tutorial/$page "r"]} error]
    if {$i} {
	error "Unable to open tutorial page $page : $error"
	return
    }
    set mode ""
    set count 0
    gets $file line
    if {[regexp {%(.*) (.*)$} $line junk interp widget]} {
	#	set rootx [send $interp "winfo rootx $widget"]
	#	set rooty [send $interp "winfo rooty $widget"]
	set rootx [winfo rootx $widget]
	set rooty [winfo rooty $widget]
	set presx [winfo rootx .tut]
	set presy [winfo rooty .tut]
	puts stdout "($presx,$presy) to ($rootx,$rooty)"
    }
    while {[gets $file line] != -1} {
	append s [string trim $line]
    }
    close $file
    while {[string length $s] > 0} {
	set l [tut_parse_mode $s]
	set font [lindex $l 0]
	set parts [lindex $l 1]
	set s [lindex $l 2]
	set start [$w index end]
	foreach part $parts {
	    regsub -all {<P>} $part "\n\t" part
	    if {[string index $part 0] == "%"} {
		# a reference
		puts stdout "Reference insert - '$part'"
		regexp -nocase {name=(.*) href=(.*)>(.*)} $part match \
		    name href text
		puts stdout "name = $name, href = $href, text = $text."
		set refstart [$w index end]
		$w insert end "$text "
		$w tag add temp$count $refstart "end - 1 chars"
		$w tag configure temp$count -underline 1
		$w tag bind temp$count <ButtonPress-1> "goto_ref $href"
		incr count
	    } else {
		# just text
		set part [string range $part 1 end]
		$w insert end $part
	    }
	}
	$w tag add temp$count $start end
	$w tag configure temp$count -font $font
	incr count
    }
    update
    virtua_line $presx $presy $rootx $rooty

}    

proc virtua_line {x y x2 y2} {
    DrawLine $x $y $x2 $y2
    after 500 virtua_line $x $y $x2 $y2
}
    

proc tut_show_page {} {
    global Tutorial LIBRARY_DIR Resources 

    set w .tut.info.desc.text
    set curx 0
    set cury 0
    set width [lindex [$w configure -width] 4]
    for {set i 1} {$i <= $Tutorial(NumParts)} {incr i} {
	# first, append the text to the text widget.

	set start [$w index end]
	$w insert end $Tutorial(part$i,text)
	set end [$w index end]
	
	# now, figure out if we should put a return at the end of
	# the text (if it is a title).
	case $Tutorial(part$i,type) in {
	    "title" {
		set font $Resources(font4)
		set newlines "\n\n"
	    } 
	    "h1"  {
		set font $Resources(font3)
		set newlines "\n\n"
	    }
	    "h2" {
		set font $Resources(font2)
		set newlines "\n\n"
	    } 
	}
	if {$Tutorial(part$i,type) != "p"} {
	    $w insert end $newlines
	    $w tag add temp$i $start $end 
	    $w tag configure temp$i -font $font
	    $w tag configure temp$i -justify center
	} 
    }
}
	    


proc tut_init {} {
    global LIBRARY_DIR Tutorial

    tut_build_widgets
    wm geometry .tut -0-0
    update
    tut_load_page Introduction.tut
}
