#include <tkmkmf.h>
#include <stdlib.h>
#include <stdio.h>

static int
Generate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
    int start = 1, finish, increment = 1, i;
    char s[8];

    if (argc <= 1)
    {
	interp->result = "Usage: generate [start] finish [increment]";

	return TCL_ERROR;
    }

    if (argc == 2)
    {
	finish = atoi(argv[1]);
    }
    else if (argc >= 3)
    {
	start = atoi(argv[1]);
	finish = atoi(argv[2]); 
    }

    if (argc >= 4)
    {
	increment = atoi(argv[3]);
    }

    for (i = start;  i <= finish;  i += increment)
    {
        sprintf(s, " %d", i);
        Tcl_AppendResult(interp, s, (char *) 0);
    }

    return TCL_OK;
}

int AppInit(Tcl_Interp *interp)
{
    Tcl_CreateCommand(interp, "generate", Generate, (ClientData) 0,
                                                (Tcl_CmdDeleteProc *) 0);
    return TCL_OK;
}
