# sendmail.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script handles the code for sending your mail
#----------------------------------------------------------------------------
# proc sendmail
# Reads the array and send the composed mail
#----------------------------------------------------------------------------

proc sendmail {} {
global widgetname
global contenttype
global body
global currentwidgetnumber
global sumofwin
global sendsubject
global sendto
global sendcc
global headers numberofheaders headervar
global alias address numberofalias

.butt.label configure -text "Sending mail to $sendto..." -foreground #3d55ff

if {$sendto==""} {
  .butt.label configure -text "Sending mail to $sendto...Cancelled! \
	You have to type the Adressee!" -foreground #3d55ff
  return 
  } 
#----------------------------------------------------------------------------
# when you send the included
#----------------------------------------------------------------------------
# Manupulation with the aliases

regsub -all " " $sendto "" sendtotemp
set list [split $sendtotemp ,]
#list with the addesses separated from comma
for {set i 1} {$i <=$numberofalias} {incr i 1} {
  for {set j 0} {$j<= [llength $list]} {incr j } {
     if {[string tolower [lindex $list $j]]==[string tolower $alias($i)]} {
        set list [lreplace $list $j $j $address($i)] 
        }
      }
   }
set sendto [join $list ,]

set cmd {MIME_sendmessage -to}
append cmd " $sendto -subject \"$sendsubject\" \
      -body  \[SafeTcl_makebody \"multipart/mixed\" "
for {set i 1} {$i <= $sumofwin} {incr i 1} {
  append cmd $contenttype($i)
  append cmd $body($i)
  }
append cmd "\] "

# The cc var
if {$sendcc !=""} {
  regsub -all " " $sendcc "" sendcctemp
  set list [split $sendcctemp ,]
  #list with the addesses separated from comma
  for {set i 1} {$i <=$numberofalias} {incr i 1} {
    for {set j 0} {$j<= [llength $list]} {incr j } {
       if {[string tolower [lindex $list $j]]==[string tolower $alias($i)]} {
          set list [lreplace $list $j $j $address($i)]
          }
        }
     }
     set sendcc [join $list ,]

  append cmd "-cc $sendcc "
  }

# The extra headers
for {set k 4} {$k <= $numberofheaders} {incr k 1} {
  if {[winfo exists .mailheader$k ]&& $headervar($k)!=""} {
    regsub -all " " $headervar($k) "" temp
    set list [split $temp ,]
    #list with the addesses separated from comma
    for {set i 1} {$i <=$numberofalias} {incr i 1} {
      for {set j 0} {$j<= [llength $list]} {incr j } {
         if {[string tolower [lindex $list $j]]==[string tolower $alias($i)]} {
            set list [lreplace $list $j $j $address($i)]
            }
          }
       }
     set headervar($k) [join $list ,]

    append cmd "-auxheader $headers($k) $headervar($k) "
    }
  }

eval $cmd
.butt.label configure -text "Sending mail to $sendto...done" -foreground #000000
}

