# menues.tcl
#----------------------------------------------------------------------------
# Copyright 1994 Siemens KWU Erlangen
# Permission to use, copy, modify, and distribute this documentation
# is hereby granted, provided that this copyright notice appears
# in all copies. This software is provided without any warranty, express
# or implied. Siemens KWU Erlangen makes no representations about the
# suitability of this software for any purpose.
#
# Author: Johan Lindbladh (tet90jl@tintin.hik.se)
#----------------------------------------------------------------------------
# This script creates and packs the menues in mailwin
#----------------------------------------------------------------------------

proc menues {} {
global headers
global numberofheaders
global headervar
global alias
global address
global numberofalias
global bg1 bg2 actbg

#-----------------------------
# Menu File
#-----------------------------
frame .menu -background $bg1 -relief raised -borderwidth 1
pack .menu -side top -fill x

menubutton .menu.file -text "File   " -menu .menu.file.m -underline 0 \
	-background $bg1 -activebackground $actbg

menu .menu.file.m
.menu.file.m add command -label "About..." -command about \
        -background $bg1 -activebackground $actbg -underline 0
.menu.file.m add command -label "Include Text..." -command  textfile \
	-background $bg1 -activebackground $actbg -underline 0
.menu.file.m add command -label "Save Textbody" -command  save -underline 5 \
        -background $bg1 -activebackground $actbg
.menu.file.m add command -label "Save Selected.." -command saveselected \
	-underline 2 -background $bg1 -activebackground $actbg
.menu.file.m add command -label "Send" -command {sendmail} -underline 0 \
        -background $bg1 -activebackground $actbg
#.menu.file.m add separator 
.menu.file.m add command -label "Quit" -command {quit} \
	-background $bg1 -activebackground $actbg -underline 0

#----------------------------- 
# Menu Insert
#-----------------------------
menubutton .menu.insert -text "Insert Data   " -menu .menu.insert.m \
	-background $bg1 -activebackground $actbg -underline 0

menu .menu.insert.m
.menu.insert.m add command -label "Textbody" -background $bg1 -underline 0 \
        -activebackground $actbg -command {initinclude; textbody}

.menu.insert.m add command -label "A Raw File" -background $bg1 \
        -activebackground $actbg -command {initinclude; raw} -underline 2

.menu.insert.m add command -label "An X11 dump" -underline 3 -background \
	$bg1 -activebackground $actbg -command {initinclude; x11dump}

.menu.insert.m add command -label "A Gif File" -background $bg1 \
	-activebackground $actbg -command {initinclude; giffile} -underline 2

.menu.insert.m add command -label "A Postscript File" -underline 2 \
        -command  {initinclude; ps} -background $bg1 -activebackground $actbg

.menu.insert.m add cascade -label "A reference to data stored external" \
        -menu .menu.insert.m.extern  -background $bg1 -activebackground $actbg

menu .menu.insert.m.extern
.menu.insert.m.extern add command -label "In a Local File" -background $bg1 \
	-activebackground $actbg -underline 0 -command {initinclude; local}

.menu.insert.m.extern add command \
        -label "Under the control of a Mail Server" -background $bg1 \
	-activebackground $actbg -command {initinclude; mailserv}

.menu.insert.m.extern add command \
	-label "In an Anonymous FTP directory on the Internet" -command \
	{initinclude; anonymftp} -background $bg1 -activebackground $actbg
.menu.insert.m.extern add command \
	-label "In an Internet FTP directory that requires a valid login" \
	-command {initinclude; ftp} -background $bg1 -activebackground $actbg

#----------------------------- 
# Menu Edit 
#-----------------------------
menubutton .menu.edit -text "Edit   " -menu .menu.edit.m \
	-background $bg1 -activebackground $actbg -underline 0

menu .menu.edit.m
.menu.edit.m add command -label "Clear Textbody" -background $bg1 \
        -activebackground $actbg -command cleartextbody -underline 0
.menu.edit.m add command -label "Delete	Del" -background $bg1 \
        -activebackground $actbg -command delete -underline 0
.menu.edit.m add command -label "Cut	Shift+Del" -background $bg1 \
	-activebackground $actbg -command  cut -underline 1
.menu.edit.m add command -label "Copy	Ctrl+Insert " -background $bg1 \
        -activebackground $actbg -command copy -underline 1
.menu.edit.m add command -label "Paste	Shift+Insert" -background $bg1 \
        -activebackground $actbg -command paste -underline 0
.menu.edit.m add command -label "Select All In Textbody" -background $bg1 \
	-underline 0 -activebackground $actbg -command selectall
.menu.edit.m add command -label "Goto Line.." -background $bg1 \
        -activebackground $actbg -command gotoline -underline 0
.menu.edit.m add cascade -label "Resize Textbody" -menu .menu.edit.m.resize \
	 -background $bg1 -activebackground $actbg

menu .menu.edit.m.resize
.menu.edit.m.resize add command -label "Default" -background $bg1 \
        -activebackground $actbg -command resizedefault -underline 0
.menu.edit.m.resize add command -label "5 lines" -background $bg1 \
        -activebackground $actbg -command resize5 -underline 0
.menu.edit.m.resize add command -label "10 lines" -background $bg1 \
        -activebackground $actbg -command resize10 -underline 0
.menu.edit.m.resize add command -label "20 lines" -background $bg1 \
        -activebackground $actbg -command resize20 -underline 0
.menu.edit.m.resize add command -label "40 lines" -background $bg1 \
        -activebackground $actbg -command resize40 -underline 0

#-----------------------------
# Menu Message
#-----------------------------
menubutton .menu.message -text "Edit Messagepart   " -menu .menu.message.m \
        -background $bg1 -activebackground $actbg -underline 5

menu .menu.message.m
.menu.message.m add command -label "Cut Messagepart" -background $bg1 \
        -activebackground $actbg -command cutmenu -underline 0
.menu.message.m add command -label "Paste Messagepart" -background $bg1 \
        -activebackground $actbg -command {initinclude; pastemessagepart} \
	-underline 0
.menu.message.m add command -label "Undo Cut" -background $bg1 \
        -activebackground $actbg -command undocutmessagepart -underline 0

#-----------------------------
# Menu Headers
#-----------------------------

menubutton .menu.headers -text "Headers   " -menu .menu.headers.m \
        -background $bg1 -activebackground $actbg -underline 0

menu .menu.headers.m -background $bg1 -activebackground $actbg
#packdefaultheaders

for {set i 4} {$i <= $numberofheaders} {incr i 1} {
  .menu.headers.m add command -label "$headers($i)" -background $bg1 \
   -activebackground $actbg -command " \
   if \[winfo exists .mailheader$i\] {
     destroy .mailheader$i
     .butt.label configure -text \"Removing header $headers($i)...done\" \
	-foreground #000000
   } else {
     frame .mailheader$i -background $bg2; 
     pack .mailheader$i -after .mailheader3 -fill both; 
     label .mailheader$i.l -text \"$headers($i) : \" -width 10 \
       -background $bg1 -anchor w; 
     entry .mailheader$i.re -width 90 -relief sunken -background $bg2 \
	-textvariable headervar($i); 
     pack .mailheader$i.l -side left -anchor w;  
     pack .mailheader$i.re -side left 
     .butt.label configure -text \"Adding  header $headers($i)...done\" \
        -foreground #000000
    }"
   }

#-----------------------------
# Packing
#-----------------------------
pack .menu.file .menu.edit .menu.insert .menu.message .menu.headers \
	-side left -anchor w
}
