# $Id: bindings.tcl,v 1.2 1993/04/06 05:32:17 sls Exp $

# these entry bindings are a little more like the way the Mac or Windows
# does things.
proc bindEntry {e} {
    bind $e <Return> {
	%W select from 0
	%W select to end
    }
    bind $e <Any-KeyPress> {
	if {"%A" != ""} {
	    catch {%W delete sel.first sel.last}	
	    %W insert insert %A
	    tk_entrySeeCaret %W
	}
    }
    bind $e <Delete> {
	tk_entryBackspace %W; tk_entrySeeCaret %W; %W select clear
    }
    bind $e <BackSpace> {
	tk_entryBackspace %W; tk_entrySeeCaret %W; %W select clear
    }
    bind $e <Control-h> {
	tk_entryBackspace %W; tk_entrySeeCaret %W; %W select clear
    }
    bind $e <Control-d> {
	if [catch {%W delete sel.first sel.last}] {
	    catch {%W delete insert}
	}
	tk_entrySeeCaret %W
    }
    proc tk_entryBackchar {w} {
	$w select clear
	if {[$w index insert] > 0} {
	    $w icursor [expr {[$w index insert]-1}]
	    tk_entrySeeCaret $w
	}
    }
    proc tk_entryForwardchar {w} {
	$w select clear
	if {[$w index insert] < [$w index end]} {
	    $w icursor [expr {[$w index insert]+1}]
	    tk_entrySeeCaret $w
	}
    }
    bind $e <Control-b> {tk_entryBackchar %W}
    bind $e <Left> {tk_entryBackchar %W}
    bind $e <Control-f> {tk_entryForwardchar %W}
    bind $e <Right> {tk_entryForwardchar %W}
    bind $e <Control-k> {
	%W select clear
	%W delete insert end
    }
    proc tk_entryBOL {w} {
	$w select clear
	$w icursor 0
	tk_entrySeeCaret $w
    }
    bind $e <Home> {tk_entryBOL %W}
    bind $e <Control-a> {tk_entryBOL %W}
    proc tk_entryEOL {w} {
	$w select clear
	$w icursor end
	tk_entrySeeCaret $w
    }
    bind $e <End> {tk_entryEOL %W}
    bind $e <Control-e> {tk_entryEOL %W}
    bind $e <Control-u> { %W delete 0 end; %W select clear }
    bind $e <Control-v> {
	catch {%W insert insert [selection get]}
	tk_entrySeeCaret %W
    }
    bind $e <Control-w> {
	tk_entryBackword %W; tk_entrySeeCaret %W; %W select clear
    }
}

#
# Setup a text widget with emacs-like bindings.
#
proc bindText {w} {
    proc tk_textSeeCaret w {
	$w yview -pickplace insert
    }
    proc tk_textCaretMoved {w} {
	global tk_priv
	set tk_priv(cursorMovedSinceKillIn[set w]) 1
    }
    bind $w <Control-a> {
	%W mark set insert "insert linestart"
	tk_textCaretMoved %W
    }
    bind $w <Control-e> {
	%W mark set insert "insert lineend"
	tk_textCaretMoved %W
    }
    bind $w <Control-p> {
	%W mark set insert "insert - 1 lines"
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-n> {
	%W mark set insert "insert + 1 lines"
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-f> {
	%W mark set insert "insert + 1 chars"
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-b> {
	%W mark set insert "insert - 1 chars"
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-h> {
	tk_textBackspace %W
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Delete> {
	tk_textBackspace %W
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <BackSpace> {
	tk_textBackspace %W
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-d> {
	if [catch {%W delete sel.first sel.last}] {
	    %W delete insert
	}
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-v> {
	catch {%W insert insert [selection get]}
	tk_textSeeCaret %W
	tk_textCaretMoved %W
    }
    bind $w <Control-k> {
	global tk_priv
	if {[string trim [%W get insert "insert lineend"]] == {}} {
	    set killed [%W get insert "insert linestart + 1 lines"]
	    %W delete insert "insert linestart + 1 lines"
	} else {
	    set killed [%W get insert "insert lineend"]
	    %W delete insert "insert lineend"
	}
	if [info exists tk_priv(cursorMovedSinceKillIn%W)] {
	    set tk_priv(killBufferFor%W) $killed
	    unset tk_priv(cursorMovedSinceKillIn%W)
	} else {
	    append tk_priv(killBufferFor%W) $killed
	}
	tk_textSeeCaret %W
    }
    bind $w <Control-y> {
	global tk_priv
	if [info exists tk_priv(killBufferFor%W)] {
	    %W insert insert $tk_priv(killBufferFor%W)
	}
    }
}
