#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: select.t,v 1.1.1.1 1994/05/13 04:52:16 andy Exp $
#
# Make a toplevel window that shows the files in a directory and allow user
# to navigate around.
#

proc fileselect { w bx } {

    catch {destroy $w}
    toplevel $w
    wm geometry $w 500x200+300+300
    wm minsize $w 500 200

    global dir
    set dir [exec pwd]
    wm title $w $dir 
    grab $w
    frame $w.f -borderwidth 0
    frame $w.f.c -borderwidth 0
    scrollbar $w.f.scr -relief flat -command "$w.f.bx yview" 
    listbox $w.f.bx -yscroll "$w.f.scr set" -relief raised -font fixed 
    button $w.f.c.cancel -text "CANCEL" -command "destroy $w" 
    button $w.f.c.select -text "SELECT" -command "fileselect_cb $w $bx"

    pack append $w.f.c $w.f.c.cancel {left expand fillx}\
	    $w.f.c.select {right expand fillx}
    pack append $w.f  $w.f.c {bottom fillx} $w.f.scr {right filly}\
	    $w.f.bx {left expand fill} 

    set files [split [exec ls -al] \n]
    eval $w.f.bx insert end $files

    pack append $w $w.f {top fill expand}
    tk_listboxSingleSelect $w.f.bx
    bind $w.f.bx <B1-ButtonRelease> {navigate_cb [winfo toplevel %W]} 
    bind $w.f.bx <ButtonPress-2> {%W select from [%W nearest %y]}
    bind $w.f.bx <Button2-Motion> {%W select to [%W nearest %y]} 

}

proc navigate_cb { w } {

    global dir

    set idx [$w.f.bx curselection]
    set filename [$w.f.bx get $idx]
    # Extract the filename from the selected item.
    regexp {[0-9a-zA-Z\.]+$} $filename choice
    if {[file isdirectory $choice]} {
	cd $choice
	set dir [exec pwd]
	wm title $w $dir 
	$w.f.bx delete 0 end
	set files [split [exec ls -al] \n]
	eval $w.f.bx insert end $files
    } else {
	$w.f.bx select clear
    }
} 

proc fileselect_cb { w bx } {

    global dir

    set selections [$w.f.bx curselection] 
    foreach idx $selections {
	set filename [$w.f.bx get $idx]
	# Extract the filename from the selected item.
	regexp {[0-9a-zA-Z\.]+$} $filename choice
	# Enter this file in the list to fax
	$bx insert end $dir/$choice
    }
    $w.f.bx select clear
}
