#
# 
#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
# 
# $Id: qstatus.t,v 1.1.1.1 1994/05/13 04:52:16 andy Exp $
#
# Make a window for user to view/remove fax queue entry.
#


proc qstatus { t } {

    catch {destroy $t}
    toplevel $t

    set fn {*courier*bold-r*12*}

    wm title $t "FAX Status Display"
    wm geometry $t 600x200

    ut_mkFrame $t {f {} {} c {-relief flat} {bottom fillx}}
    scrollbar $t.f.scr -relief sunken -command "$t.f.bx yview"
    listbox $t.f.bx -yscroll "$t.f.scr set" -relief sunken -font $fn
    ut_mkButton $t.c [list b_cancel "DISMISS -command \{destroy $t\}"]
    ut_mkButton $t.c [list b_rescan "UPDATE -command \{update_cb $t\}"]
    pack append $t.f $t.f.scr {left filly} $t.f.bx {right fill expand}
    tk_listboxSingleSelect $t.f.bx
    bind $t.f.bx <B1-ButtonRelease> {remove_cb  %W} 

    if {![catch {exec faxstat} res]} {
	set items [split $res "\n"]
	foreach i $items {
	    $t.f.bx insert end $i
	}
    } else {
	tk_dialog .err "Ooops!" "$res" {} 0 OK
    }
}

proc update_cb { t } {

    # Remove whats already in the listbox
    $t.f.bx delete 0 end

    if {![catch {exec faxstat} res]} {
	set items [split $res "\n"]
	foreach i $items {
	    $t.f.bx insert end $i
	}
    } else {
	tk_dialog .err "Ooops!" "$res" {} 0 OK
    }
}

proc remove_cb { t } {

    set idx [$t curselection]
    set entry [$t get $idx]

    # Get the job number
    if {[regexp {^[0-9]+} $entry job]} {
	catch {exec faxrm $job} res
	# Delete entry
	$t delete $idx
	tk_dialog .err "Queue Entry Status" "$res" {} 0 OK
    }
    # Remove highlight
    $t select clear
}
