#  Copyright (c) 1994 A & A Custom Software.
#  All rights reserved.
# 
#  Redistribution and use in source and binary forms, with or without
#  modification, are permitted provided that the following conditions
#  are met:
#  1. Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#  2. Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#  3. All advertising materials mentioning features or use of this software
#     must display the following acknowledgement:
#       This product includes software developed by A & A Custom Software 
#       and its contributors.
#  4. Neither the name of A & A Custom Software nor the names of its 
#     contributors may be used to endorse or promote products derived from this 
#     software without specific prior written permission.
# 
#  THIS SOFTWARE IS PROVIDED BY A & A CUSTOM SOFTWARE AND CONTRIBUTORS ``AS IS''
#  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#  ARE DISCLAIMED.  IN NO EVENT SHALL A & A CUSTOM SOFTWARE OR CONTRIBUTORS BE 
#  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
#  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
#  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
#  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
#  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
#  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
#  POSSIBILITY OF SUCH DAMAGE.
#
# $Id: ff_EntryDialog.t,v 1.2 1994/05/20 17:36:44 andy Exp $
#
# Entry dialog.
#


proc EntryDialog {w msg} {

    global EntryDialog_Value

    catch {destroy $w}
    set t [toplevel $w].ed
    frame $t -borderwidth 2 -relief raised
    message $t.msg -text $msg  -aspect 99999
    entry $t.e -width 50 -borderwidth 2 -relief sunken
    frame $t.bar
    button $t.bar.ok -text "OK" \
        -command "global EntryDialog_Value
            set EntryDialog_Value \[$t.e get\]
            destroy $w"
    button $t.bar.cancel -text "Cancel" \
        -command "global EntryDialog_Value exitVal
        set exitVal 1; set EntryDialog_Value {}
        destroy $w"
    pack append $t.bar \
        $t.bar.ok {left padx 8 pady 8} \
        $t.bar.cancel {right padx 8 pady 8}
    pack append $t \
        $t.msg {top fillx} \
        $t.e {top padx 8 pady 8} \
        $t.bar {bottom fillx}
    bind . <ResizeRequest> {
        wm geometry . 0x0+%x+%y; update
    }
    bind $t <Visibility> "grab -global $w; focus $t.e"
    bind $t <Visibility> "focus $t.e"
    bind $t.e <Return> "global EntryDialog_Value
			set EntryDialog_Value \[$t.e get\]
			destroy $w"
    bind $t.e <Enter> "+focus $t.e"
    pack $t -expand true -fill both

    wm title $w "Entry Dialog"
}
