/* 
 * tmTclCommands.c --
 *
 *	This file contains the loader for the commands recognised
 *	by the moat interpreter to give Motif support.
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.

 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header$";
#endif
#include "tm.h"
#include "tmFuncs.h"

#include <X11/Intrinsic.h>
#include <Xm/ArrowB.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/Command.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>


/*
 * The following structure defines all of the commands supported by
 * Tm, and the C procedures that execute them.
 */

typedef struct {
    char *name;			/* Name of command. */
    int (*cmdProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	    int argc, char **argv));
				/* Command procedure. */
    int (*widgetCmdProc) _ANSI_ARGS_((ClientData clientData, Tcl_Interp *interp,
	    int argc, char **argv));
				/* Widget Command procedure. */
} TmCmd;

TmCmd commands[] = {
    /*
     * Commands that are part of the intrinsics:
     */

/*
    {"after",		Tk_AfterCmd},
    {"bind",		Tk_BindCmd},
    {"destroy",		Tk_DestroyCmd},
    {"focus",		Tk_FocusCmd},
    {"grab",		Tk_GrabCmd},
    {"option",		Tk_OptionCmd},
    {"pack",		Tk_PackCmd},
    {"place",		Tk_PlaceCmd},
    {"selection",	Tk_SelectionCmd},
    {"tk",		Tk_TkCmd},
    {"tkwait",		Tk_TkwaitCmd},
    {"update",		Tk_UpdateCmd},
    {"winfo",		Tk_WinfoCmd},
    {"wm",		Tk_WmCmd},
*/
    /*
     * Widget-creation commands.
     */
    {"arrowButton",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"bulletinBoard",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"bulletinBoardDialog", Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"cascadeButton",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"command",		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"drawingArea",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"drawnButton",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"errorDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"fileSelectionBox",Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"fileSelectionDialog", Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"form",		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"formDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"frame",		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"informationDialog", Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"label",		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"list",		Tm_AnyCmd, Tm_ListWidgetCmd},
    {"mainWindow",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"menuBar",		Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {"messageBox",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"messageDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"panedWindow",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"promptDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"pulldownMenu",	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {"pushButton",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"questionDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"rowColumn",	Tm_RowColumnCmd, Tm_AnyWidgetCmd},
    {"scale",		Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"scrollBar",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"scrolledList",	Tm_ScrolledCmd, Tm_ListWidgetCmd},
    {"scrolledText",	Tm_ScrolledCmd, Tm_TextWidgetCmd},
    {"selectionBox",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"selectionDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"separator",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"text",		Tm_AnyCmd, Tm_TextWidgetCmd},
    {"textField",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"toggleButton",	Tm_AnyCmd, Tm_AnyWidgetCmd},
    {"warningDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
    {"workingDialog",	Tm_DialogCmd, Tm_AnyWidgetCmd},
/*
    {"arrowButton",	Tm_AnyCmd, xmArrowButtonWidgetClass},
    {"bulletinBoard",	Tm_BulletinBoardCmd, xmBulletinBoardWidgetClass},
    {"bulletinBoardDialog", Tm_BulletinBoardCmd, xmBulletinBoardWidgetClass},
    {"cascadeButton",	Tm_AnyCmd, xmCascadeButtonWidgetClass},
    {"command",		Tm_AnyCmd, xmCommandWidgetClass},
    {"drawingArea",	Tm_AnyCmd, xmDrawingAreaWidgetClass},
    {"drawnButton",	Tm_AnyCmd, xmDrawnButtonWidgetClass},
    {"errorDialog",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"fileSelectionBox",Tm_FileSelectionCmd, xmFileSelectionBoxWidgetClass},
    {"fileSelectionDialog", Tm_FileSelectionCmd, xmFileSelectionBoxWidgetClass},
    {"form",		Tm_FormCmd, xmFormWidgetClass},
    {"formDialog",	Tm_FormCmd, xmFormWidgetClass},
    {"frame",		Tm_AnyCmd, xmFrameWidgetClass},
    {"informationDialog", Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"label",		Tm_AnyCmd, xmLabelWidgetClass},
    {"list",		Tm_ListCmd, xmListWidgetClass},
    {"mainWindow",	Tm_MainWindowCmd, xmMainWindowWidgetClass},
    {"menuBar",		Tm_RowColumnCmd, xmRowColumnWidgetClass},
    {"messageBox",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"messageDialog",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"panedWindow",	Tm_AnyCmd, xmPanedWindowWidgetClass},
    {"promptDialog",	Tm_SelectionBoxCmd, xmSelectionBoxWidgetClass},
    {"pulldownMenu",	Tm_RowColumnCmd, xmRowColumnWidgetClass},
    {"pushButton",	Tm_AnyCmd, xmPushButtonWidgetClass},
    {"questionDialog",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"rowColumn",	Tm_RowColumnCmd, xmRowColumnWidgetClass},
    {"scale",		Tm_AnyCmd, xmScaleWidgetClass},
    {"scrollBar",	Tm_AnyCmd, xmScrollBarWidgetClass},
    {"scrolledList",	Tm_ScrolledListCmd, xmListWidgetClass},
    {"scrolledText",	Tm_ScrolledTextCmd, xmTextWidgetClass},
    {"selectionBox",	Tm_SelectionBoxCmd, xmSelectionBoxWidgetClass},
    {"selectionDialog",	Tm_SelectionBoxCmd, xmSelectionBoxWidgetClass},
    {"separator",	Tm_AnyCmd, xmSeparatorWidgetClass},
    {"text",		Tm_TextCmd, xmTextWidgetClass},
    {"textField",	Tm_TextFieldCmd, xmTextFieldWidgetClass},
    {"toggleButton",	Tm_AnyCmd, xmToggleButtonWidgetClass},
    {"warningDialog",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
    {"workingDialog",	Tm_MessageBoxCmd, xmMessageBoxWidgetClass},
*/
/*
    {"canvas",		Tk_CanvasCmd},
    {"checkbutton",	Tk_ButtonCmd},
    {"entry",		Tk_EntryCmd},
    {"frame",		Tk_FrameCmd},
    {"label",		Tk_ButtonCmd},
    {"listbox",		Tk_ListboxCmd},
    {"menu",		Tk_MenuCmd},
    {"menubutton",	Tk_MenubuttonCmd},
    {"message",		Tk_MessageCmd},
    {"radiobutton",	Tk_ButtonCmd},
    {"scale",		Tk_ScaleCmd},
    {"scrollbar",	Tk_ScrollbarCmd},
    {"text",		Tk_TextCmd},
    {"toplevel",	Tk_FrameCmd},
*/
    {(char *) NULL,	(int (*)()) NULL, (Tm_WidgetCmdProc) NULL}
};

void Tm_LoadWidgetCommands (interp)
    Tcl_Interp *interp;
{
    register TmCmd *cmdPtr;

    /*
     * Bind in Tm's commands.
     */

    for (cmdPtr = commands; cmdPtr->name != NULL; cmdPtr++) {
	Tcl_CreateCommand(interp, cmdPtr->name, cmdPtr->cmdProc,
		(ClientData) cmdPtr->widgetCmdProc, (void (*)()) NULL);
    }
}

