/*
 * tmExpand.c --
 *	This module handles % expansions of callback data
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <stdio.h>
#include <string.h>
#include "tm.h"

#include <Xm/Command.h>
#include <Xm/FileSB.h>
#include <Xm/List.h>
#include <Xm/Scale.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>

/*
 *--------------------------------------------------------------
 *
 * getValue --
 *
 *	Get the value of a field from out of the callback data.
 *
 * Results:
 *
 *	places the string value in "value"
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

static char *
getValue(w, call_data, value, length)
    Widget w;
    XtPointer call_data;
    char *value;
{
    char *result;
    XrmValue from, to;
    static char buf[16];

    if (XtClass(w) == xmCommandWidgetClass) {
	XmCommandCallbackStruct *c_data = (XmCommandCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
/*
	    from.addr = c_data->value;
	    from.size = sizeof(XmString);
	    to.addr = NULL;
	    Tm_CvtXmStringToString(NULL, NULL, 0, &from, &to, NULL);
	    return *(char **)to.addr;
*/
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmFileSelectionBoxWidgetClass) {
	XmFileSelectionBoxCallbackStruct *c_data =
			(XmFileSelectionBoxCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else
	if (length == strlen("mask") &&
		strncmp(value, "mask", length) == 0) {
	    XmStringGetLtoR(c_data->mask, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("mask_length") &&
		strncmp(value, "mask_length", length) == 0) {
	    sprintf(buf, "%d", c_data->mask_length);
	    return buf;
	} else
	if (length == strlen("dir") &&
		strncmp(value, "dir", length) == 0) {
	    XmStringGetLtoR(c_data->dir, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("dir_length") &&
		strncmp(value, "dir_length", length) == 0) {
	    sprintf(buf, "%d", c_data->dir_length);
	    return buf;
	} else
	if (length == strlen("pattern") &&
		strncmp(value, "pattern", length) == 0) {
	    XmStringGetLtoR(c_data->pattern, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("pattern_length") &&
		strncmp(value, "pattern_length", length) == 0) {
	    sprintf(buf, "%d", c_data->pattern_length);
	    return buf;
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmListWidgetClass) {
	XmListCallbackStruct *c_data = (XmListCallbackStruct *) call_data;

	if (length == strlen("item") &&
		strncmp(value, "item",length) == 0) {
            XmStringGetLtoR(c_data->item, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("item_length") &&
		strncmp(value, "item_length", length) == 0) {
	    sprintf(buf, "%d", c_data->item_length);
	    return buf;
	} else
	if (length == strlen("item_position") &&
		strncmp(value, "item_position", length) == 0) {
	    sprintf(buf, "%d", c_data->item_position);
	    return buf;
	} else
	if (length == strlen("selected_items") &&
		strncmp(value, "selected_items", length) == 0) {
	    if (c_data->reason == XmCR_MULTIPLE_SELECT ||
	    	c_data->reason == XmCR_EXTENDED_SELECT) {
		String *items, items_list;
		int n, len;
		char *p, *end;

		items = (char **) XtMalloc(sizeof(char *) *
					c_data->selected_item_count);
		len= 0;
		for (n = 0; n < c_data->selected_item_count; n++) {
		    XmStringGetLtoR(c_data->selected_items[n],
					XmFONTLIST_DEFAULT_TAG, items + n);
		    len += strlen(items[n]) + 2; /* for , */
		}
		items_list = XtMalloc(len + 1); /* we overshoot by 1 */
		if (len == 0) {
		    *items_list = '\0';
		    return items_list;
		}
		end = items_list;
		for (n = 0; n < c_data->selected_item_count; n++) {
		    p = items[n];
		    while (*end++ = *p++)
			;
		    *(end - 1) = ',';
		    *end++ = ' ';
		    XtFree(items[n]);
		}
		*(end - 2) = '\0';
		return items_list;
	    }
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmScaleWidgetClass) {
	XmScaleCallbackStruct *c_data = (XmScaleCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value", length) == 0) {
	    sprintf(buf, "%d", c_data->value);
	    return buf;
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmTextWidgetClass) {
	XmTextVerifyCallbackStruct *c_data =
			(XmTextVerifyCallbackStruct *) call_data;

	if (length == strlen("doit") &&
		strncmp(value, "doit", length) == 0) {
		return TM_TEXT_DOIT;
	} else
	if (length == strlen("currInsert") &&
		strncmp(value, "currInsert", length) == 0) {
	    sprintf(buf, "%d", c_data->currInsert);
	    return buf;
	} else
	if (length == strlen("newInsert") &&
		strncmp(value, "newInsert", length) == 0) {
	    sprintf(buf, "%d", c_data->newInsert);
	    return buf;
	} else
	if (length == strlen("startPos") &&
		strncmp(value, "startPos", length) == 0) {
		return TM_TEXT_STARTPOS;
	} else
	if (length == strlen("endPos") &&
		strncmp(value, "endPos", length) == 0) {
		return TM_TEXT_ENDPOS;
	} else
	if (length == strlen("ptr") &&
		strncmp(value, "ptr", length) == 0) {
		return TM_TEXT_PTR;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
		return TM_TEXT_LENGTH;
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmSelectionBoxWidgetClass) {
	XmSelectionBoxCallbackStruct *c_data =
			(XmSelectionBoxCallbackStruct *) call_data;

	if (length == strlen("value") &&
		strncmp(value, "value",length) == 0) {
	    XmStringGetLtoR(c_data->value, 
			XmFONTLIST_DEFAULT_TAG, &result);
	    return result;
	} else
	if (length == strlen("length") &&
		strncmp(value, "length", length) == 0) {
	    sprintf(buf, "%d", c_data->length);
	    return buf;
	} else {
	    return "";
	}
    } else
    if (XtClass(w) == xmToggleButtonWidgetClass) {
	XmToggleButtonCallbackStruct *c_data =
			(XmToggleButtonCallbackStruct *) call_data;

	if (length == strlen("set") &&
		strncmp(value, "set", length) == 0) {
	    if (c_data->set) {
		return "true";
	    } else {
		return "false";
	    }
	} else {
	    return "";
	}
    }
    return "";
}


/*
 *--------------------------------------------------------------
 *
 * addChars --
 *
 *	add a list of characters to a string.
 *	grows space if neccessary
 *
 * Results:
 *
 *	"from" as appended to "after"
 *
 * Side effects:
 *
 *	may reallocate memory
 *--------------------------------------------------------------
 */

static char *
addChars(after, afterSize, end, spaceLeft, fromSize, from)
    char *after;
    int *afterSize;
    char **end;
    int *spaceLeft;
    int fromSize;
    char *from;
{
    char *newSpace;
    int extra;

    if (*spaceLeft < fromSize) {
	if (fromSize > *afterSize) {
	    extra = fromSize + 50;
	} else {
	    extra = *afterSize;
	}
	newSpace = XtRealloc(after, *afterSize + extra);
	*spaceLeft += extra;
	*afterSize += extra;
	*end = newSpace + (*end - after);
	after = newSpace;
    }
    *spaceLeft -= fromSize;

    while (fromSize) {
	**end = *from;
	from++;
	(*end)++;
	fromSize--;
    }
    return after;
}

/*
 *--------------------------------------------------------------
 *
 * Tm_ExpandPercents --
 *
 *	expand out the %field in patterns by their callback values
 *
 * Results:
 *
 *	A new string with the expansions is returned
 * Side effects:
 *
 *	none.
 *--------------------------------------------------------------
 */

char *
Tm_ExpandPercents(widget_info, call_data, before)
    Tm_Widget *widget_info;
    XtPointer call_data;
    char *before;
{
    Widget w = widget_info->widget;
    char *after, *end, *p;
    char *value;
#   define TM_STR_SIZE 128
    int afterSize = TM_STR_SIZE;
    int spaceLeft = TM_STR_SIZE;
    int wordSize;

    if (strchr(before, '%') == NULL) {
	after = XtNewString(before);
	return after;
    }

    end = after = XtMalloc(TM_STR_SIZE);

    while (*before != 0) {
	if (*before != '%') {
	    after = addChars(after, &afterSize, &end, &spaceLeft, 1, before);
	    before++;
	} else {
	    before++;
	    wordSize = 0;
	    while (isalpha(before[wordSize]) || before[wordSize] == '_') {
		wordSize++;
	    }
	    if (wordSize == 0) {
	        after = addChars(after, &afterSize, &end, &spaceLeft, 1, "%");
	    } else {
		value = getValue(w, call_data, before, wordSize);
		after = addChars(after, &afterSize, &end, &spaceLeft,
				 strlen(value), value);
		before += wordSize;
	    }
	}
    }
    *end = '\0';

    return after;
}
