/* 
 * tmCommands.c --
 *
 *	This module implements the tcl widget commands
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Copyright 1990-1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef lint
static char rcsid[] = "$Header";
#endif

#include "tm.h"
#include "tmFuncs.h"
#include <Xm/List.h>
#include <Xm/Text.h>
		
/*--------------------------------------------------------------
 *
 * Tm_AnyWidgetCmd --
 *
 *	This procedure is invoked to process the Tcl command
 *	that corresponds to a widget managed by this module.
 *	See the user documentation for details on what it does.
 *
 * Results:
 *	A standard Tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */

int
Tm_AnyWidgetCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Information about button widget. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{
    Tm_Widget *butPtr = (Tm_Widget *) clientData;
    int result = TCL_OK;
    char c;
    Arg args[TM_MAXARGS];
    int num_args;
    int bool_val;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }
    c = argv[1][0];

    if ((c == 'd') && (strcmp(argv[1], "destroy") == 0)) {
	/* destroy - most stuff done in DestroyWidgetHandler */
	XtDestroyWidget(butPtr->widget);
    } else

    if ((c == 'g') && (strcmp(argv[1], "getValues") == 0)) {
	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setValues \
-option value...", argv[0]);
	    goto error;
	}
	Tm_GetValues(butPtr->pathName, interp, (Widget) butPtr->widget, 
				XtClass(butPtr->widget), argv+2, argc-2);
    } else

    if ((c == 'm') && (strcmp(argv[1], "manageChild") == 0)) {
	/* manageChild */
	XtManageChild(butPtr->widget);
    } else

    if ((c == 'p') && (strcmp(argv[1], "parent") == 0)) {
	Tcl_SetResult(interp, XtNewString(butPtr->parent), 
			TCL_DYNAMIC);
    } else

    if ((c == 's') && (strcmp(argv[1], "setSensitive") == 0)) {
	/* set Sensitive */
	if (argc < 3) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setSensitive \
-option value", argv[0]);
	    goto error;
	}
	if (Tcl_GetBoolean(interp, argv[2], &bool_val) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XtSetSensitive(butPtr->widget, bool_val);
    } else

    if ((c == 's') && (strcmp(argv[1], "setValues") == 0)) {
	if (argc < 4) {
	    sprintf(interp->result, "wrong # args: should be \"%.50s setValues \
-option value...", argv[0]);
	    goto error;
	}
	if ( ! XtIsShell(butPtr->widget)) {
	    Tm_SetValues(butPtr->pathName, interp, butPtr->widget,
				XtParent(butPtr->widget), 
				XtClass(butPtr->widget), argv+2, argc-2, args, &num_args);
	} else {
	    Tm_SetValues(butPtr->pathName, interp, butPtr->widget,
				butPtr->widget, 
				XtClass(butPtr->widget), argv+2, argc-2, args, &num_args);
	}
	XtSetValues(butPtr->widget, args, num_args);
    } else
    if ((c == 'u') && (strcmp(argv[1], "unmanageChild") == 0)) {
	/* unmanage child */
	XtUnmanageChild(butPtr->widget);
    } else

    if (strstr(argv[1], "Callback") != NULL) {
	Tm_ClientData *client_data;

	client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
	client_data->callback_func = XtNewString(argv[2]);
	client_data->widget_info = butPtr;
	XtAddCallback(butPtr->widget, argv[1], Tm_WidgetCallbackHandler,
		client_data);
    }
    return TCL_OK;

    error:
    return TCL_ERROR;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_ListWidgetCmd --
 *
 *	This function processes the commands that may be applied
 *	to a list widget.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_ListWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w;
    int result = TCL_OK;
    char c;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }

    w = wPtr -> widget;

    c = argv[1][0];

    if ((c == 'a') && (strcmp(argv[1], "addItem") == 0)) {
	/* add item */
	XrmValue from, toItem;
	int position;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s addItem item position\"",
		argv[0]);
	    return TCL_ERROR;
	}
	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = NULL;
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	if (Tcl_GetInt(interp, argv[3], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}

	XmListAddItem(w, *(XmString *) toItem.addr, position);
	XmStringFree(*(XmString *) toItem.addr);
    } else

    if ((c == 'd') && (strcmp(argv[1], "deleteAllItems") == 0)) {
	XmListDeleteAllItems(w);
    } else

    if ((c == 'd') && (strcmp(argv[1], "deleteItem") == 0)) {
	XrmValue from, toItem;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deleteItem item\"",
		argv[0]);
	    return TCL_ERROR;
	}
	from.addr = argv[2];
	from.size = strlen(argv[2]) + 1;
	toItem.addr = NULL;
	XtConvertAndStore(w, XtRString, &from, XmRXmString, &toItem);

	XmListDeleteItem(w, *(XmString *) toItem.addr);
	XmStringFree(*(XmString *) toItem.addr);
    } else
    if ((c == 'd') && (strcmp(argv[1], "deletePosition") == 0)) {
	int position;

	if (argc != 3) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s deletePosition position\"",
		argv[0]);
	    return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListDeletePos(w, position);
    } else

    if ((c == 's') && (strcmp(argv[1], "selectPosition") == 0)) {
	int position;
	int call_callback;

	if (argc != 4) {
	    sprintf(interp->result,
		"wrong # args: should be \"%.50s selectPosition position call_callback\"",
		argv[0]);
	    return TCL_ERROR;
	}
	if (Tcl_GetInt(interp, argv[2], &position) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	if (Tcl_GetBoolean(interp, argv[3], &call_callback) == TCL_ERROR) {
	    return TCL_ERROR;
	}
	XmListSelectPos(w, position, call_callback);
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tm_TextWidgetCmd --
 *
 *	handles the methods that may be requested of Text widgets.
 *
 * Results:
 *
 * Side effects:
 *
 *--------------------------------------------------------------
 */

int
Tm_TextWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    int result = TCL_OK;
    char c;

    if (argc < 2) {
	sprintf(interp->result,
		"wrong # args: should be \"%.50s option [arg arg ...]\"",
		argv[0]);
	return TCL_ERROR;
    }
    c = argv[1][0];

    if (strcmp(argv[1], "losingFocusCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s losingFocusCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNlosingFocusCallback,
			Tm_TextVerifyCallbackHandler, client_data);
    } else

    if (strcmp(argv[1], "modifyVerifyCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s modifyVerifyCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNmodifyVerifyCallback,
			Tm_TextVerifyCallbackHandler, client_data);
    } else

    if (strcmp(argv[1], "motionVerifyCallback") == 0) {
        Tm_ClientData *client_data;

        if (argc != 3) {
            sprintf(interp->result,
                "wrong # args: should be \"%.50s motionVerifyCallback callback\"",
                argv[0]);
            return TCL_ERROR;
        }
        client_data = (Tm_ClientData *) XtMalloc(sizeof(Tm_ClientData));
        client_data->callback_func = XtNewString(argv[2]);
        client_data->widget_info = wPtr;

	XtAddCallback(wPtr->widget, XmNmotionVerifyCallback,
			Tm_TextVerifyCallbackHandler, client_data);
    } else
    if (strcmp(argv[1], "clearSelection") == 0) {
	XmTextClearSelection(wPtr->widget, CurrentTime);
    } else
    if (strcmp(argv[1], "copy") == 0) {
	XmTextCopy(wPtr->widget, CurrentTime);
    } else
    if (strcmp(argv[1], "cut") == 0) {
	XmTextCut(wPtr->widget, CurrentTime);
    } else
    if (strcmp(argv[1], "findString") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getEditable") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getInsertionPosition") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getLastPosition") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getSelection") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getSelectionPosition") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getString") == 0) {
	interp->result = XmTextGetString(wPtr->widget);
    } else
    if (strcmp(argv[1], "getSubstring") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "getTopCharacter") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "insert") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "paste") == 0) {
	XmTextPaste(wPtr->widget);
    } else
    if (strcmp(argv[1], "remove") == 0) {
	XmTextRemove(wPtr->widget);
    } else
    if (strcmp(argv[1], "replace") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "scroll") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setAddMode") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setEditable") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setHighlight") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setInsertionPosition") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setSelection") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setSource") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setString") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "setTopCharacter") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else
    if (strcmp(argv[1], "showPosition") == 0) {
	fprintf(stderr, "Text method not yet implemented\n");
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
    return TCL_OK;
}
