################################################################
####		     Image creation                         ####
################################################################

set PSResolution 140

set theImageFmt { Postscript PPM GIF Pict \
  {X Bitmap} {XPM} {X Window} {X Region} }

if {$HasInrim} {
  lvarpush theImageFmt Inrimage
}

set imCreateFuncs {
  {PPM      	{cppm}}
  {Postscript   {cps}}
  {GIF      	{cgif}}
  {Pict     	{cpict}}
  {{X Bitmap}  {cxbitmap}}
  {{XPM}       {cxpixmap}}
  {{X Window}   {cxwindow}}
  {{X Region}   {cxregion}}
}

if {$HasInrim} {
  lvarpush imCreateFuncs {Inrimage {cinrim}}
}

if {$HasInrim} {
  set currentImageFormat {Inrimage}
} else {
  set currentImageFormat {PPM}
}

set currentImageFile [pwd]
set currentImageWidth {}
set currentImageHeight {}

proc cimage_dialog {} {
  global currentImageFile currentImageFormat
  global currentImageWidth currentImageHeight

  buildImloadDialog

  .imloadDg.pathFr.pathEn delete 0 end
  .imloadDg.pathFr.pathEn insert 0 $currentImageFile

  .imloadDg.dimFr.parFr.entryFr.widthEn delete 0 end
  .imloadDg.dimFr.parFr.entryFr.widthEn insert 0 $currentImageWidth

  .imloadDg.dimFr.parFr.entryFr.heightEn delete 0 end
  .imloadDg.dimFr.parFr.entryFr.heightEn insert 0 $currentImageHeight
}

proc cimage {} {
  global currentImageFile currentImageFormat
  global currentImageWidth currentImageHeight
  global imCreateFuncs

  set currentImageFile [sglob $currentImageFile]

  saveMsg
  createStart_hook
  waitCursor
  
  if {$currentImageWidth != ""} {
    set w $currentImageWidth} { set w -1 }
  if {$currentImageHeight != ""} {
    set h $currentImageHeight} { set h -1 }
  
  keylget imCreateFuncs $currentImageFormat func
  eval "$func $currentImageFile 200 200 $w $h"

  restoreCursor
  after 2000 { restoreMsg }
  createEnd_hook
}

########  Inrimage  ########

proc cinrim {path x y w h} {
  global ImageFile

  if {[catch {exec isinrim $path} err]} {
    warn [translit "\n" " " "$err"]
  } else {
    set picfile [mkTmpFile image]
    inrim2pic $path $picfile 0
    set id [[cv] create image $x $y -path $picfile \
	    -width $w -height $h \
	      -tags {inCreation}]
    keylset ImageFile $id $picfile    
  }
}

proc cppm {path x y w h} {
  global ImageFile

  if {[catch {exec pnmfile $path} err]} {
    warn [translit "\n" " " "$err"]
  } else {
    set picfile [mkTmpFile image]
    ppm2pic $path $picfile 0
    set id [[cv] create image $x $y -path $picfile \
	    -width $w -height $h \
	      -tags {inCreation}]
    keylset ImageFile $id $picfile    
  }
}

proc cgif {path x y w h} {
  global ImageFile

  set ppmfile [mkTmpFile ppm]
  if {[catch {exec giftoppm $path > $ppmfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile}
  } else {
    set picfile [mkTmpFile image]
    if {[catch {ppm2pic $ppmfile $picfile 0} err]} {
      warn [translit "\n" " " "$err"]
      catch {exec rm $ppmfile $picfile}
    } else {
      catch {exec rm $ppmfile}
      set id [[cv] create image $x $y -path $picfile \
	      -width $w -height $h \
		-tags {inCreation}]
      keylset ImageFile $id $picfile
    }
  }
}

proc cxpixmap {path x y w h} {
  global ImageFile

  set ppmfile [mkTmpFile ppm]
  if {[catch {exec xpmtoppm $path > $ppmfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile}
  } else {
    set picfile [mkTmpFile image]
    if {[catch {ppm2pic $ppmfile $picfile 0} err]} {
      warn [translit "\n" " " "$err"]
      catch {exec rm $ppmfile $picfile}
    } else {
      catch {exec rm $ppmfile}
      set id [[cv] create image $x $y -path $picfile \
	      -width $w -height $h \
		-tags {inCreation}]
      keylset ImageFile $id $picfile
    }
  }
}

proc cxbitmap {path x y w h} {
  global currentStyle ImageFile

  if {[catch {eval "[cv] create bitmap $x $y \
                            -anchor nw \
                            -bitmap @$path $currentStyle(bitmap) \
                            -tags inCreation"} id]} {
    warn "$id"
    createEnd_hook
  } else {
    keylset ImageFile $id $path
    createEnd_hook
  }
}

proc cpict {path x y w h} {
  global ImageFile

  set ppmfile [mkTmpFile ppm]
  if {[catch {exec picttoppm $path > $ppmfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile}
  } else {
    set picfile [mkTmpFile image]
    if {[catch {ppm2pic $ppmfile $picfile 0} err]} {
      warn [translit "\n" " " "$err"]
      catch {exec rm $ppmfile $picfile}
    } else {
      catch {exec rm $ppmfile}
      set id [[cv] create image $x $y -path $picfile \
	      -width $w -height $h \
		-tags {inCreation}]
      keylset ImageFile $id $picfile
    }
  }
}

proc cxregion {path x y w h} {
  global ImageFile

  ##  -> xwd  ##
  set xwdfile [mkTmpFile xwd]
  if {[catch {exec xgrabsc -z -s 0 -W -o $xwdfile} err]} {
    warn "xgrab error : [translit "\n" " " "$err"]"
    catch {exec rm $xwdfile}
    return
  }
  
  ##  Empty region  ##

  if {![file readable $xwdfile]} {
    warn "Empty region"
    return
  }

  ##  xwd -> ppm  ##
  set ppmfile [mkTmpFile ppm]
  ## xwdtopnm has non-zero exit status ##
  catch {exec xwdtopnm $xwdfile > $ppmfile} status
  catch {exec rm $xwdfile}

  if {[catch {exec pnmfile $ppmfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile}
    return
  }

  ##  ppm -> picasso  ##
  set picfile [mkTmpFile image]
  if {[catch {ppm2pic $ppmfile $picfile 0} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile $picfile}
  } else {
    catch {exec rm $ppmfile}
    set id [[cv] create image $x $y -path $picfile \
	    -width $w -height $h \
	      -tags {inCreation}]
    keylset ImageFile $id $picfile
  }
}

proc cxwindow {path x y w h} {
  global ImageFile

  ##  -> xwd  ##
  set xwdfile [mkTmpFile xwd]
  if {[catch {exec xgrabsc -w -s 0 -W -o $xwdfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $xwdfile}
    return
  }

  ##  xwd -> ppm  ##
  set ppmfile [mkTmpFile ppm]
  ## xwdtopnm has non-zero exit status ##
  catch {exec xwdtopnm $xwdfile > $ppmfile} status
  catch {exec rm $xwdfile}

  if {[catch {exec pnmfile $ppmfile} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile}
    return
  }

  set picfile [mkTmpFile image]
  if {[catch {ppm2pic $ppmfile $picfile 0} err]} {
    warn [translit "\n" " " "$err"]
    catch {exec rm $ppmfile $picfile}
  } else {
    catch {exec rm $ppmfile}
    set id [[cv] create image $x $y -path $picfile \
	    -width $w -height $h \
	      -tags {inCreation}]
    keylset ImageFile $id $picfile
  }
}

proc cps {psfile x y w h} {
  global ImageFile PSResolution

  waitCursor

  saveMsg
  
  #  ps -> ppm  #
  msg "Converting Postscript to PPM ..."
  
  set ppmfile [mkTmpFile ppm]
  set cmd "echo \"showpage\" | gs -r$PSResolution -sDEVICE=ppmraw -sOutputFile=$ppmfile $psfile -dNODISPLAY 2>&1 > /dev/null"

  if {[catch {system "$cmd"} err] ||
    ![file readable $ppmfile]} {
      catch {exec rm $ppmfile}
      restoreMsg
      warn "Postscript to PPM conversion failed."
      restoreCursor
      return
    }

  msg "Stripping PPM image ..."
  
  #  ppm -> picasso  #
  set picfile [mkTmpFile image]
  if {[catch {ppm2pic -strip $ppmfile $picfile 0} err]} {
    warn $err
    catch {exec rm $ppmfile $picfile}
    restoreMsg
    restoreCursor
    return
  }

  catch {exec rm $ppmfile}

  #  item creation  #
  set id [[cv] create image $x $y \
	  -path $picfile \
	    -width $w -height $h \
	    -tags inCreation]
  keylset ImageFile $id $picfile

  restoreMsg
  restoreCursor
  createEnd_hook
}

################################################################
####		   Control functions                        ####
################################################################

proc setSelectionBrightness {delta} {
  ####  augment brightness of selected images by delta  ####

  set items [[cv] find withtag s]
  set imids {}
  foreach it $items {
    if {[[cv] type $it] == "image"} { lappend imids $it }
  }

  if { [lempty $imids] } { return }

  waitCursor

  foreach imid $imids {
    set int [lindex [[cv] itemconfigure $imid -brightness] 4]
    set int [min 1.0 [max -1.0 [expr "$int + $delta"]]]
    
    [cv] itemconfigure $imid -brightness $int
  }

  restoreCursor
}


proc setSelectionContrast {delta} {
  ####  augment contrast of selected images by delta  ####

  set items [[cv] find withtag s]
  set imids {}
  foreach it $items {
    if {[[cv] type $it] == "image"} { lappend imids $it }
  }

  if { [lempty $imids] } { return }

  waitCursor

  foreach imid $imids {
    set cont [lindex [[cv] itemconfigure $imid -contrast] 4]
    set cont [min 1.0 [max -1.0 [expr "$cont + $delta"]]]
    
    [cv] itemconfigure $imid -contrast $cont
  }

  restoreCursor
}
