/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 *	otMetaTempl.c
 *
 */


/*
#include <stdlib.h>
*/
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <tcl.h>
#include <tclInt.h>
#include "ot.h"

OTErr readMetaTemplate();

#ifndef LINT
static char RCSid_otMetaTempl[] =
    "$RCSfile: otMetaTempl.c,v $ $Revision: 1.1.4.2 $ $Date: 1993/10/18 20:10:37 $";

#endif


/*
 *              List of functions defined in the otMetaTemplate.c
 *
 *	otFreeMetaTemplate()
 *	otSetMetaTemplate()
 *	otDupMetaTemplate()
 *
 */



void
otFreeMetaTemplate(mStruct)
OTMetaTemplate *mStruct;	/* metatemplate structure to free */
{
    
    OTMetaTemplate *mp;

    (void)free( (char *)mStruct );
    return;
}



OTErr
otSetMetaTemplate(tDefFile)
char * tDefFile;		/* template definition file name */
{
    OTErr metaErr;
    OTProject *pStruct;

    pStruct = otCB->cb_pcb->pcb_project;
    if ( metaErr = readMetaTemplate( tDefFile, &(pStruct->otmp)) ) {
	return metaErr;
    }
    otTclInitCmds(pStruct);

    return OT_SUCCESS;
}


OTErr
otDupMetaTemplate( inMetaStruct, outMetaStruct )
OTMetaTemplate  *inMetaStruct;
OTMetaTemplate **outMetaStruct;
{

    int i;

    /*
     * Determine length of metatemplate.
     */
    for(i=0; inMetaStruct[i].field[0]; i++);
    i++;

    if (!(*outMetaStruct = (OTMetaTemplate *)calloc(i, sizeof(OTMetaTemplate))) ) {
	otPutPostedMessage( OT_MALLOC_LOCATION, "otDupMetaTemplate" );
	return OT_MALLOC_LOCATION;
    }

    memcpy(*outMetaStruct, inMetaStruct, i * sizeof(OTMetaTemplate));
    return OT_SUCCESS;
}

OTErr
readMetaTemplate(file, mtemplate)
char *  file;                           /* template file to read */
OTMetaTemplate ** mtemplate;  /* where to put the info */
{
    register int i, j, ch;
    register OTMetaTemplate * temp;
    FILE * ifile;

    if ((ifile = fopen(file, "r")) == NULL) {
	otPutPostedMessage( OT_METATEMPLATE_READ, file );
	return OT_METATEMPLATE_READ;
    }

    if ( (*mtemplate = temp = (OTMetaTemplate *)
		calloc(MAXTEMPLATE, sizeof(OTMetaTemplate))) == NULL ) {
        otPutPostedMessage( OT_MALLOC_LOCATION, "readMetaTemplate()" );
	return OT_METATEMPLATE_READ;
    }

/* now read template and setup structure */

    for (i=0;  TRUE;  ) {

	if (i >= MAXTEMPLATE)   {
	    otPutPostedMessage( OT_METATEMPLATE_LONG );
	    return OT_METATEMPLATE_LONG;
	}

	temp[i].field[0] = 0;

	if ((ch = getc(ifile)) == EOF)
	    break;

	if (ch == '\n') {
	    temp[i].line[0] = 0;
	    temp[i].field[0] = '!';
	    temp[i++].field[1] = 0;
	    continue;           /* empty line */
	}

	if (ch == '#')  {
	    while (getc(ifile) != '\n')
		;
	    continue;
	}

	if (ch == '!')  {       /* pass through -- add to line structure */
	    for (j=0;  (ch = getc(ifile)) != '\n';  j++)
		temp[i].line[j] = ch;
	    temp[i].line[j] = 0;
	    temp[i].field[0] = '!';
	    temp[i++].field[1] = 0;
	    continue;           /* end when we hit the note fields */
	}

	temp[i].field[0] = ch;

    /* get field name (everything before "~") */

	for (j=1; ((ch = getc(ifile)) != '~') && (ch != '\n'); j++) {
	    temp[i].field[j] = ch;
	}
	temp[i].field[j] = 0;

	if (ch != '~')  {
	    otPutPostedMessage( OT_METATEMPLATE_EOL, temp[i].field );
	    return OT_METATEMPLATE_EOL;
	}

    /* get options (everything before "~") */

	for (j=0; ((ch = getc(ifile)) != '~') && (ch != '\n'); j++) {
	    temp[i].opts[j] = ch;
	}
	temp[i].opts[j] = 0;

	if (temp[i].opts[j-1] == DEGREE_MANY_CHAR)
	    temp[i].degree = DEGREE_MANY;
	else
	    temp[i].degree = DEGREE_ONE;

	if ( temp[i].opts[0] == '(' ) {
	    temp[i].optionality = OPT_MAND;
	}
	else if ( temp[i].opts[0] == '[' ) {
	    temp[i].optionality = OPT_OPTL;
	}
	else {
	    temp[i].type = TYPE_NULL;
	    temp[i].list[0] = '\000';
	    temp[i].optionality = OPT_NONE;
	    DBUG_MAX((stderr, "TYPE_NULL (%d - %d): %s\n", TYPE_NULL, temp[i].type, temp[i].field));
	}

	if ( temp[i].opts[1] ) {
	    strcpy(temp[i].list, &(temp[i].opts[1]));
	    strtok(temp[i].list, "])+");
	    temp[i].type = otGetType( temp[i].list );
	}

	DBUG_MED((stderr, "readMetaTemplate field %s type %d list %s\n", temp[i].field, temp[i].type, temp[i].list));
	DBUG_MED((stderr, "readMetaTemplate   optionality %d degree %d\n", temp[i].optionality, temp[i].degree));


	if (ch != '~')  {
	    otPutPostedMessage( OT_METATEMPLATE_EOL, temp[i].field );
	    return OT_METATEMPLATE_EOL;
	}

    /* get defaults (everything before "~") */

	for (j=0; ((ch = getc(ifile)) != '~') && (ch != '\n'); j++) {
	    temp[i].defs[j] = ch;
	}
	temp[i].defs[j] = 0;

	if (ch != '~')  {
	    otPutPostedMessage( OT_METATEMPLATE_EOL, temp[i].field );
	    return OT_METATEMPLATE_EOL;
	}

    /* get abbreviation for field (everything before "~") */

	for (j=0; ((ch = getc(ifile)) != '~') && (ch != '\n'); j++) {
	    temp[i].abbr[j] = ch;
	}
	temp[i].abbr[j] = 0;

	if (ch != '~')  {
	    otPutPostedMessage( OT_METATEMPLATE_EOL, temp[i].field );
	    return OT_METATEMPLATE_EOL;
	}

    /* get heading for report (everything before "~") */

	for (j=0; ((ch = getc(ifile)) != '~') && (ch != '\n'); j++) {
	    temp[i].head[j] = ch;
	}
	temp[i].head[j] = 0;

	if (ch != '~')  {
	    otPutPostedMessage( OT_METATEMPLATE_EOL, temp[i].field );
	    return OT_METATEMPLATE_EOL;
	}

    /* get width of field for report (everything before EOL) */

	for (j=0; (ch = getc(ifile)) != '\n'; j++)  {
	    temp[i].width[j] = ch;
	}
	temp[i].width[j] = 0;

	i++;
    }

    fclose(ifile);              /* done with template */

    return OT_SUCCESS;

}
