/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 */

/*
 * dputil.c
 *
 * Copyright 1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include <sys/types.h>
#include <sys/time.h>

#include "tcl.h"
#include "tclInt.h"

#include "dputil.h"
#include "dproto.h"
#include "dp.h"

static Tcl_DString *exitCmd;


/*
 *--------------------------------------------------------------
 *
 * Tdp_AtExitCmd --
 *
 *	This procedure is invoked to process the "dp_atexit" command.
 *	See the user documentation for details.
 *
 * Results:
 *	A standard tcl result.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */
    /* ARGSUSED */
int
Tdp_AtExitCmd(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;		/* tcl interpreter */
    int argc;			/* Number of arguments */
    char *argv[];		/* Arg list */
{
    if (exitCmd == 0) {
	exitCmd = (Tcl_DString *)ckalloc(sizeof(Tcl_DString));
	Tcl_DStringInit(exitCmd);
    }
    if (argc == 1) {
	Tcl_DStringResult(interp, exitCmd);
	return TCL_OK;
    }
    if (argc != 2) {
	sprintf(interp->result, "wrong # args: should be \"%s ?cmd?\"",
		argv[0]);
	return TCL_ERROR;
    }

    Tcl_DStringAppendElement(exitCmd, argv[1]);
    return TCL_OK;
}


/*
 *--------------------------------------------------------------
 *
 * Tdp_ExitCmd --
 *
 *	This procedure is invoked to process the "dp_exit" command.
 *	It first does the dp_atexit callbacks, then calls
 *	the normal Tcl exit routines.  See the user documentation
 *	for details on what these do.
 *
 * Results:
 *	Should never return.
 *
 * Side effects:
 *	See the user documentation.
 *
 *--------------------------------------------------------------
 */
int
Tdp_ExitCmd(clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;		/* tcl interpreter */
    int argc;			/* Number of arguments */
    char *argv[];		/* Arg list */
{
    int eargc;
    char **eargv;

    if (exitCmd) {
	Tcl_SplitList(interp, Tcl_DStringValue(exitCmd), &eargc, &eargv);
	/*
	 * Eval all the commands in exitCmd, and keep going in case of
	 * errors.
	 */
	while (--eargc >= 0)
	    (void)Tcl_Eval(interp, eargv[eargc]);
	ckfree ((char *)eargv);
    }
    Tcl_ExitCmd(clientData, interp, argc, argv);
    return TCL_OK;		/* Stop compiler warnings */
}


/*
 *--------------------------------------------------------------
 *
 * Tdp_utilInit --
 *
 *	Initialize an interpreter with the util extensions to tcl.
 *
 * Results:
 *	None
 *
 * Side effects:
 *	util related commands are bound to the interpreter.
 *
 *--------------------------------------------------------------
 */
int
Tdp_utilInit(interp)
    Tcl_Interp *interp;		/* tcl interpreter */
{
    Tcl_CreateCommand(interp, "dp_atexit", Tdp_AtExitCmd,
		      (ClientData) NULL, (void (*) ()) NULL);
    Tcl_CreateCommand(interp, "dp_exit", Tdp_ExitCmd,
		      (ClientData) NULL, (void (*) ()) NULL);
    Tcl_CreateCommand(interp, "exit", Tdp_ExitCmd,
		      (ClientData) NULL, (void (*) ()) NULL);
    return TCL_OK;
}


/*
 *----------------------------------------------------------------------
 *
 * ReadSysClock --
 *
 *	Return the value of the system clock as a double.
 *
 * Results:
 *	Value of the system clock.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */
double
ReadSysClock()
{
    struct timeval tv;
    (void) gettimeofday(&tv, NULL);
    return (tv.tv_sec + tv.tv_usec / 1000000.0);
}
