/* 
 * Copyright (c) 1994 Open Software Foundation, Inc.
 * 
 * Permission is hereby granted to use, copy, modify and freely distribute
 * the software in this file and its documentation for any purpose without
 * fee, provided that the above copyright notice appears in all copies, and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation.  Further, provided that the name of Open
 * Software Foundation, Inc. ("OSF") not be used in advertising or
 * publicity pertaining to distribution of the software without prior
 * written permission from OSF.  OSF makes no representations about the
 * suitability of this software for any purpose.  It is provided "AS IS"
 * without express or implied warranty.
 */ 

/*
 * OT 3.0.2
 * Copyright 1992 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The University of California
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifndef _DP_PROTOTYPES_
#define _DP_PROTOTYPES_

#include "tclInt.h"

/* dpaddress.c */
extern char *Tdp_CreateAddress		_ANSI_ARGS_((unsigned long addr,
					     int port));
extern struct sockaddr *Tdp_FindAddr	_ANSI_ARGS_((char *name));
extern int Tdp_AddressCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char **argv));

/* dpnetwork.c */
extern int Tdp_ConnectCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_ShutdownCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_AcceptCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_FileHandlerCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_ReceiveCmd		_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_SendCmd			_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_FDIsReadable		_ANSI_ARGS_((int fd));
extern int Tdp_PacketReceive		_ANSI_ARGS_((Tcl_Interp *interp,
					     OpenFile *filePtr,
					     int block));
extern int Tdp_PacketReceiveCmd		_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_PacketSend		_ANSI_ARGS_((Tcl_Interp *interp,
					     OpenFile *filePtr,
					     char *message));
extern int Tdp_PacketSendCmd		_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_ReceiveFromCmd		_ANSI_ARGS_((ClientData notUsed,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_SendToCmd		_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern void Tdp_Tcp_Init		_ANSI_ARGS_((Tcl_Interp *interp));
extern int Tdp_GetOpenFile		_ANSI_ARGS_((Tcl_Interp *interp,
					     char *string, int forWriting,
					     int checkUsage,
					     OpenFile **filePtr));

/* dpnetworkInit.c */
extern int Tdp_networkInit		_ANSI_ARGS_((Tcl_Interp *interp));
extern int Tdp_Init			_ANSI_ARGS_((Tcl_Interp *interp));

/* dprpc.c */
/* OT CHANGE */
extern int Tdp_ReceiveRPC		_ANSI_ARGS_((Tcl_Interp *interp,
					     OpenFile *filePtrIn,
					     OpenFile *filePtrOut,
					     char *command, int respond));
extern int Tdp_ReceiveRPCCmd		_ANSI_ARGS_((ClientData unused,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_ProcessRPCMessages	_ANSI_ARGS_((Tcl_Interp *interp,
					     OpenFile *filePtrIn,
					     OpenFile *filePtrOut,
					     int wait));
extern int Tdp_ProcessRPCMessagesCmd	_ANSI_ARGS_((ClientData unused,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_RPC			_ANSI_ARGS_((Tcl_Interp *interp,
					     OpenFile *filePtrIn,
					     OpenFile *filePtrOut,
					     char *command, int events,
					     int timeout,
					     char *timeoutReturn));
extern int Tdp_RPCCmd			_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_ProcessRPCCommandCmd	_ANSI_ARGS_((ClientData unused,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_RDOCmd			_ANSI_ARGS_((ClientData unused,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_CancelRPCCmd		_ANSI_ARGS_((ClientData unused,
					     Tcl_Interp *interp,
					     int argc, char **argv));
extern int Tdp_RPCInit			_ANSI_ARGS_((Tcl_Interp *interp));

/* dputil.c */
extern int Tdp_AtExitCmd		_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_ExitCmd			_ANSI_ARGS_((ClientData clientData,
					     Tcl_Interp *interp,
					     int argc, char *argv []));
extern int Tdp_utilInit			_ANSI_ARGS_((Tcl_Interp *interp));
double ReadSysClock			_ANSI_ARGS_((void));

/* tkAppInit.c */
extern int Tcl_AppInit			_ANSI_ARGS_((Tcl_Interp *interp));

#endif

