#
# mxedit.tcl_ui --
#	Transform an mxedit window into a TCL evaluation shell.

proc TclInit {} {
    # Set an mxedit buffer up for TCL evaluation
    global tclTargetInterp
    set tclTargetInterp .
    catch {
	mxMenu Eval
	mxMenuAdd Eval "Eval Line" {tclEvalInner [mxExtract [mxLine].0 [mxLine].1000] }
	mxMenuAdd Eval "Eval Selection" { tclEvalInner [selection get] }
	mxMenuAddSeparator Eval
	mxMenuAdd Eval "List interpreters" { tclListInterps }
	mxMenuAdd Eval "Set target interp to SEL" { tclSetInterpSel }
	mxMenuAdd Eval "Reset target interp to ." { tclSetInterp . }
	mxMenuAddSeparator Eval
	mxMenuAdd Eval "source tcl_ui.mxedit" {
	    global mxLibrary
	    foreach dir { . ./lib $mxLibrary } {
		if [file exists $dir/mxedit.tcl_ui] {
		    source $dir/mxedit.tcl_ui
		    break
		}
	    }
	}
	mxMenuBind <Control-Return> Eval "Eval Line"
	mxMenuBind <Mod1-Return> Eval "Eval Selection"
    }

    # Create the output window, positioning at the end in case it exists
    global tclResultWindow
    if {[catch {mxOpen tcl_ui.log} result] == 0} {
	set tclResultWindow $result
    } else {
	if [string match "Active: *" $result] {
	    set tclResultWindow "mxedit tcl_ui.log"
	} else {
	    puts stderr "Error: >$result<"
	    error $result
	}
    }
    send $tclResultWindow {
	mxCaret eof ; mxSee caret
    }
}

proc tclEvalInner { string } {
    # Evaluate a TCL command at the top-level scope
    global tclEchoOutput tclResultWindow
    global tclInterpName tclTargetInterp

    tclEchoReset
    tclDisplayCommand $string
    if {$tclTargetInterp == "."} {
	# Evaluate in this editors TCL interpreter
	tclDisplayResult [uplevel #0 $string]
    } else {
	# Evaluate in another TCL interpreter
	tclDisplayResult [send $tclTargetInterp $string]
    }
}

proc tclDisplayCommand { string } {
    global tclResultWindow
    send $tclResultWindow {
	mxCaret eof ; mxNewline ; mxInsert {---} ; mxNewline ; mxSee caret top
    }
    send $tclResultWindow [list insert $string]
    if ![tclEndsWithNewline $string] {
	send $tclResultWindow mxNewline
    }
}

proc tclDisplayResult { result } {
    # Display an evaluation result in the result window
    global tclResultWindow tclEchoOutput

    send $tclResultWindow { mxCaret eof ; mxInsert {-} ; mxNewline ; mxSee caret }
    foreach line $tclEchoOutput {
	send $tclResultWindow [list mxInsert ${line}\n]
    }
    send $tclResultWindow [list mxInsert $result ]
}

proc tclDisplay { string } {
    # Display something in the result window
    global tclResultWindow

    send $tclResultWindow { mxCaret eof ; mxInsert {-} ; mxNewline ; mxSee caret }
    send $tclResultWindow [list mxInsert $string ]
    if ![tclEndsWithNewline $string] {
	send $tclResultWindow mxNewline
    }
}

proc tclEchoReset {} {
    global tclEchoOutput
    set tclEchoOutput {}
}
proc tclEcho { string } {
    global tclEchoOutput
    lappend tclEchoOutput $string
    return {}
}

proc tclEndsWithNewline { string } {
    expr { [string last "\n" $string] == [string length $string] - 1 }
}

proc tclListInterps {} {
    tclEchoReset
    tclDisplayCommand "Registered TCL interpreters"
    foreach interp [winfo interps] {
	tclEcho $interp
    }
    tclDisplayResult "\".\" is a synonym for your mxedit interp"
}

proc tclSetInterpSel {} {
    mxApplyToSelection "tclSetInterp"
}

proc tclSetInterp { interp } {
    global tclTargetInterp
    # Do this so 1) it affects us, and 2) the user gets feedback from tclEvalInner
    set tclTargetInterp .
    tclEvalInner [list set tclTargetInterp $interp]
}
