# mxedit.emacs

# Emacs-like bindings for the mxedit widget.  This imports the names
# of various menus in order to establish keyboard bindings and menu
# accelerators in a consistent manner via the mxMenuBind procedure.
#
# This also includes bindings for the search/replace and command entries
#
# Copyright (c) 1992 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.
#


# emacsBindings --
# This sets up emacs-like keystroke bindings for an mxedit widget.
# This procedure uses mxMenuBind to set up keyboard accelerators.
# mxMenuBind keeps the menu display up-to-date with the keyboard bindings.
#

proc emacsBindings {} {
    global mxedit
    emacsKeyBindings
    mxScrollBindings $mxedit
    mxSelectionBindings $mxedit
}

proc emacsKeyBindings { {widget NONE} } {
    global mxedit
    if {$widget == "NONE"} {
	set widget $mxedit
    }

    # Set up ASCII input
    mxBasicBindings $widget

    # Clear any existing menu bindings
    foreach menu {File Edit Search} {
	mxMenuUnBindAll $menu
    }

    # <Control-space> support
    emacsMarkBindings

    # Make this prefix harmless
    mxBind <Control-x> {set _foo ""}

    ### FILE OPERATIONS
    mxMenuBind <Control-x><Control-s>	File "Save"
    mxMenuBind <Control-x><Control-c>	File "Quit"
    mxMenuBind <Control-x>5		File "Open new window"

    # Open a new window, using the current word as the tag
    bind $widget <Escape><t> {}
#    bind $widget <Escape><t> {
#	set _t [mxMark [mxMark caret forw 1 word] back 1 char]
#	mxselection set [mxMark $_t back 1 word] $_t
#	mxApplyToSelection tagOpen
#   }

    ### EDITING OPERATIONS

    mxMenuBind <Control-x>u 	Edit "Undo"

    mxMenuBind <Mod1-w>		Edit "Copy SEL"
    mxMenuBind <Control-w>	Edit "Cut SEL"

    mxMenuBind <Control-k>	Edit "Cut eol"
    mxMenuBind <Control-d>	Edit "Cut char"
    mxMenuBind <Control-y>	Edit "Yank"
    mxMenuBind <Mod1-y>		Edit "Yank-pop"

    ### INDENTATION

    # Indent the line at the insertion point
    global mxIndent
    if ![info exists mxIndent] {
	set mxIndent 2
    }
    ### SEARCH/REPLACE OPERATIONS

    mxMenuBind <Control-s> 	Search "Forward"
    mxMenuBind <Mod1-s>    	Search "Forward for SEL"
    mxMenuBind <Control-r> 	Search "Backward"
    mxMenuBind <Mod1-r>    	Search "Backward for SEL"

    # Clear and focus on the replace window
    bind $widget <Escape><r>	{ mxReplaceClear }
    # Make sure the find window is visible
    bind $widget <Escape><s>	{ mxFindClear }

    ### KEYBOARD EDITTING

    # Delete forward character
    bind $widget <Control-d> { mxDeleteForwChar }

    # Delete backward character
    bind $widget <Delete> { mxDeleteBackChar }

    # Delete backward word
    bind $widget <Escape><Delete> { mxDeleteBackWord }

    # Delete forward word
    bind $widget <Escape><d> { mxDeleteForwWord }

    # Delete to end of line
    bind $widget <Control-k> { mxDeleteEndOfLine }

    # Open a line below this one
    bind $widget <Control-o> { mxOpenLineBelow }

    # Open a line above this one
#    bind $widget <Control-k> { mxOpenLineAbove }

    ### KEYBOARD MOTION

    # Backward one character
    bind $widget <Control-b> { mxBack1char }

    # Forward one character
    bind $widget <Control-f> { mxForw1char }

    # Down one line
    bind $widget <Control-n> { mxDown1Line }

    # Up one line
    bind $widget <Control-p> { mxUp1Line }

    # Backward one word
    bind $widget <Escape><b> { mxBack1Word }

    # Forward one word
    bind $widget <Escape><f> { mxForw1Word }

    # To end-of-line
    bind $widget <Control-e> { mxEndOfLine }

    # To beginning of line
    bind $widget <Control-a> { mxBeginOfLine }

    # Page up
    bind $widget <Escape><v> { mxPageUp }
    bind $widget <Mod1-v> { mxPageUp }

    # Page down
    bind $widget <Control-v> { mxPageDown }

    # Miscellany

    # Change focus to the command entry widget
    bind $widget <Escape><x> { mxCommandFocus }

#    bind $widget <Control-question> { mxCaretInfo }

    global mxKeyBindingProc
    set mxKeyBindingProc emacsKeyBindings
}

# emacsCommandBindings --

proc emacsCommandBindings { entry } {
    bind $entry <Return>		{ mxDoCmd }
    bind $entry <Control-Return>	{ mxEditFocus }
    bind $entry <Control-q>		{ mxCommandHide ; mxEditFocus }
}

# emacsSearchBindings --
#	Extra bindings for the search entry widget

proc emacsSearchBindings { entry } {
    bind $entry <Return>	{ mxFindInner forward }
    bind $entry <Control-f>	{ mxFindInner forward }
    bind $entry <Control-f>	{ mxFindInner forward }
    bind $entry <Control-Return> { mxFindInner backward }
    bind $entry <Control-r>	{ mxReplaceFocus }
    bind $entry <Control-q>	{ mxHideFind ; mxEditFocus }
    bind $entry <Control-c>	{ mxEditFocus }
}

# emacsReplaceBindings --
#	Extra bindings for the replace entry widget

proc emacsReplaceBindings { entry } {
    bind $entry <Return>	{ mxFindInner replace }
    bind $entry <Control-r>	{ mxFindInner replace }
    bind $entry <Mod1-r>	{ mxFindInner replaceSel }
    bind $entry <Escape><r>	{ mxFindInner replaceEverywhere }
    bind $entry <Control-f>	{ mxSearchFocus }
    bind $entry <Control-q>	{ mxHideFind ; mxEditFocus }
    bind $entry <Control-c>	{ mxEditFocus }
}


########################################################################
#
# Support for a ring of kill buffers
#
########################################################################

proc emacsKill { what {kill kill} } {
    global emacsKillBuf
    global mxMarkActive
    if [catch {
	case $what {
	    sel {
		set mark1 sel.left
		set mark2 sel.right
	    }
	    line {
		if {[string compare [mxMark caret] [mxMark caret char -1]] != 0} {
		    set mark1 caret
		    set mark2 [mxMark [mxMark caret char -1] back 1 char]]
		} else {
		    set mark1 caret
		    set mark2 caret
		}
	    }
	    char {
		set mark1 caret
		set mark2 caret
	    }
	    backchar {
		set mark1 [mxMark caret back 1 char]
		set mark2 [mxMark caret back 1 char]
	    }
	}
	if [string match emacsKill* [mxLastCommand 1]] {
	    mxGlobalEval mxKillAppend [mxExtract $mark1 $mark2]
#	    set top [_emacsCurKill]
#	    append emacsKillBuf($top) [mxExtract $mark1 $mark2]
	} else {
	    mxGlobalEval mxKillNew [mxExtract $mark1 $mark2]
#	    set top [_emacsPushKill]
#	    set emacsKillBuf($top) [mxExtract $mark1 $mark2]
	}
	if {$kill == "kill"} {
	    mxDelete $mark1 $mark2
	}
	set mxMarkActive 0	;# Not sure about this semantics
    } msg] {
	mxFeedback "mxKill: $msg"
    }
}

proc emacsKillReset {} {
    mxGlobalEval mxKillReset
}

proc emacsYank {} {
    mxInsert [mxGlobalEval mxYank]
}

proc emacsYankPop {} {
    global emacsKillStackTop
    if [string match emacsYank* [mxLastCommand 1]] {

	mxUndo	;# undo the last emacsYank

	mxGlobalEval mxYankPop
	emacsYank
    } else {
	mxFeedback "don' wanna Yank-Pop"
    }
}

############################################################################
#
# Support for the emacs "mark" (control-space)
#
############################################################################

proc emacsMarkBindings {} {
    global mxedit

    bind $mxedit <Control-space> { mxCaretSelChar $mxedit caret ; set mxMarkActive 1 }
    bind $mxedit <Control-x><Control-x> { mxExchDotMark }
}

