# $Id: mxedit.dirbrowser,v 1.1 1993/05/19 16:40:18 welch Exp $
# mxedit.dirbrowser --
#
# This script controls a directory browser whose purpose is to provide
# some trivial file management capabilities.  The primary purpose is to
# make it easier to open files.
#
# AUTHOR: David S. Herron <david@davids.mmdf.com>
# DATE:   28-July-1992
#
# $Log: mxedit.dirbrowser,v $
# Revision 1.1  1993/05/19  16:40:18  welch
# Initial revision
#
# Revision 1.2  1992/07/29  05:44:19  david
# Add directory browser to FILE menu (is this the right place?).
# Fix initial geometry & minsize settings.
#
# Revision 1.1  1992/07/28  07:05:55  david
# Initial revision.
#
#
# TODO:
#
#- Add NEW button.  Or else have OPEN button inuit conditions where it
# should create a new file.
#
#- Have OPEN button check .dir.top.file.file for a file name.
#
#- Fix up the `mode' part so it shows an `ls' style output.
#
#- Add configuration of details of describing files.
#
#- Add keyboard accelerators for the command buttons.
#
#- Finish implementing the command buttons.
#
#- Have it remember the directories which have been visited.  Make the
# Pathname label be a menu instead.  As we visit new directories, add them
# to the list.
#  Currently remembers the last directory and starts up there if the
# window is closed & then reopened.
#
#- Rework this so it can be used for SaveAs as well as opening.
#- Rework so it can be used for a "change directory" dialog.
#
#- Have DirOpenFile check regular files to see if they are ASCII.  If
# not, then bitch about it.
#
#- To help with the above, think about a command like the Unix `file' command.
#
#- When exiting a directory, remember the `top position' of the list.  Then
# when (if) the user comes back there we can re-set it.
#
#- Glance through Emacs' dired.el to get ideas of what else can be done.
#	change mode, compress/uncompress, encrypt/decrypt, etc
#
#- For less-often-used commands, attach an EXTRA's menu.
#

proc DirShowWindow {{directory "-"}} {
  global DirCurDirectory env

  if {"$directory" == "-"} {
	if {[info exists DirCurDirectory]} {
		set directory $DirCurDirectory
	} else {
		set directory [pwd]
	}
  }

  if {[catch {winfo name .dir}]} {
	toplevel .dir

	# Window manager configurations
	wm title .dir {Directory Browser}
	wm geometry .dir =350x550
	wm minsize .dir 250 250

	frame .dir.top

	##### .dir.top.filter -- specify patern to match file names with.

	frame .dir.top.filter
	entry .dir.top.filter.filter\
			    -exportselection {false}\
			    -font {*-fixed-Medium-R-Normal-*-13-*}\
			    -relief {sunken}
	label .dir.top.filter.l\
			    -anchor {e}\
			    -text {Selection Pattern: }

	pack append .dir.top.filter\
	    .dir.top.filter.l		{left frame center} \
	    .dir.top.filter.filter	{left frame center expand fillx} 

	##### .dir.top.file -- Specify file portion of file name.

	frame .dir.top.file
	entry .dir.top.file.file\
			    -exportselection {false}\
			    -font {*-fixed-Medium-R-Normal-*-13-*}\
			    -relief {sunken}
	label .dir.top.file.l\
			    -anchor {e}\
			    -text {File: }

	pack append .dir.top.file\
	    .dir.top.file.l	{left frame center padx 38} \
	    .dir.top.file.file	{left frame center expand fillx} 

	##### .dir.top.path -- Specify path portion of file name.

	frame .dir.top.path
	entry .dir.top.path.path\
			    -exportselection {false}\
			    -font {*-fixed-Medium-R-Normal-*-13-*}\
			    -relief {sunken}
	label .dir.top.path.l\
			    -anchor {e}\
			    -text {Pathname: }

	pack append .dir.top.path\
	    .dir.top.path.l   {left frame center} \
	    .dir.top.path.path   {left frame center expand fillx} 

	##### .dir.top.cmd -- Command buttons.

	frame .dir.top.cmd    -relief {raised}
	button .dir.top.cmd.rescan\
			    -command {DirRescan .dir.top}\
			    -text {Rescan}
	button .dir.top.cmd.rename\
			    -command {DirRename .dir.top}\
			    -text {Rename}
	button .dir.top.cmd.del\
			    -command {DirDeleteFile .dir.top}\
			    -text {Delete}
	button .dir.top.cmd.open\
			    -command {DirOpenFile .dir.top}\
			    -text {Open}
	button .dir.top.cmd.close\
			    -command {destroy .dir}\
			    -text {Close}

	pack append .dir.top.cmd\
	    .dir.top.cmd.close	{left frame center expand fillx} \
	    .dir.top.cmd.open   {left frame center expand fillx} \
	    .dir.top.cmd.del	{left frame center expand fillx} \
	    .dir.top.cmd.rename	{left frame center expand fillx} \
	    .dir.top.cmd.rescan	{left frame center expand fillx} 

	##### .dir.top.dir -- Contents of current directory.

	frame .dir.top.dir
	scrollbar .dir.top.dir.scroll\
			    -command {.dir.top.dir.list yview}\
			    -relief {sunken}
	listbox .dir.top.dir.list\
			    -exportselection {false}\
			    -relief {raised} \
			    -yscrollcommand {.dir.top.dir.scroll set}\
			    -font {*-fixed-Medium-R-Normal-*-10-*}\
			    -background white
	pack append .dir.top.dir\
	    .dir.top.dir.list     {left frame center expand fill} \
	    .dir.top.dir.scroll   {left frame center filly} 

	pack append .dir.top\
	    .dir.top.cmd      {bottom frame center fillx} \
	    .dir.top.dir      {top frame center expand fill} \
	    .dir.top.path     {top frame center fillx} \
	    .dir.top.file     {top frame center fillx} \
	    .dir.top.filter   {top frame center fillx} 


	# pack widget .dir
	pack append .dir\
	    .dir.top   {top frame center expand fill}

	bind .dir.top.path.path     <Return>       {.dir.top.cmd.rescan invoke}
	bind .dir.top.file.file     <Return>       {.dir.top.cmd.rescan invoke}
	bind .dir.top.filter.filter <Return>       {.dir.top.cmd.rescan invoke}
	bind .dir.top.dir.list      <Double-Button-1> {DirOpenFile .dir}
  } else {
	# Attempt to raise the window to the front.  But this does not work.
	# TK needs a `wm raise' command!
	wm deiconify .dir
  }

  DirInitDirectory .dir $directory
}

######################## Utility functions  ##########################

proc DirPathWidget   {} { return ".dir.top.path.path" }
proc DirFileWidget   {} { return ".dir.top.file.file" }
proc DirFilterWidget {} { return ".dir.top.filter.filter" }
proc DirListWidget   {} { return ".dir.top.dir.list"  }

proc DirDescribeFile {file} {
	if {![file exists $file]} {
		return "!!!!!! $file does not exist !!!!!!!"
	}
	file stat $file stat

	set code ""
	if {[file executable  $file] == 1} { set code "*" }
	if {[file isdirectory $file] == 1} { set code "/" }

	# This might look nicer with the file name at the beginning
	# of the line, instead of the end.  But if so, do we truncate
	# long names?

	return [format "%08o %2d %8d %17s %s%s" \
			$stat(mode) $stat(nlink) $stat(size) \
			[fmtclock $stat(mtime) "%h %e %Y %R"] \
			[file tail $file] $code]

}



######################## Callback functions ##########################

proc DirRescan top {
	DirScanDirectory $top [[DirPathWidget] get] [[DirFilterWidget] get]
}

proc DirRename top {
}

proc DirDeleteFile top {
	global DirCurrentFiles

	set l [DirListWidget]
	set sel [$l curselection]
	set trans "no"
	foreach s $sel {
		set file [lindex $DirCurrentFiles $s]
		if {![file isfile $file]} {
			error "DirOpenFile: File $file is not a regular file!"
		}
		unlink $file
		set trans "yes"
	}
	if {"$trans" != "no"} {
		DirRescan $top
	}
	$l select clear
	# If we could find out where the listbox WAS then we could re-set
	# it to there now.  Ohwell.
}

proc DirOpenFile top {
	global DirCurrentFiles

	set l [DirListWidget]
	set sel [$l curselection]
	foreach s $sel {
		set file [lindex $DirCurrentFiles $s]
		if {[file isdirectory $file]} {
			if {[string compare [file tail "$file"] "." ] == 0} {
				return 
			}
			if {[string compare [file tail "$file"] ".."] == 0} {
				set file [file dirname $file]
				set file [file dirname $file]
			}
			DirScanDirectory $top $file [[DirFilterWidget] get]
			return
		}
		if {![file readable $file]} {
			error "DirOpenFile: File $file is not readable!"
		}
		if {![file isfile $file]} {
			error "DirOpenFile: File $file is not a regular file!"
		}
		mxOpen $file
	}
	$l select clear
}


###################### Directory browser back end ####################

proc DirInitDirectory {top directory} {
	global DirCurDir
	set DirCurDir $directory

	set path [DirPathWidget]
	$path delete 0 end
	$path insert end $directory

	[DirFileWidget] delete 0 end
	[DirFilterWidget] delete 0 end
	[DirFilterWidget] insert end "*"

	DirScanDirectory $top $directory "*"
}

proc DirScanDirectory {top directory pattern} {
	global DirCurrentFiles DirCurDirectory
	set DirCurrentFiles ""

	set DirCurDirectory $directory

	set l [DirListWidget]

	if {"$pattern" == "*"} {
		set dotFiles [glob -nocomplain "$directory/.*"]
	} else {
		set dotFiles ""
	}
	set files [glob -nocomplain "$directory/$pattern"]

	$l delete 0 end

	foreach f [lsort $dotFiles] {
		lappend DirCurrentFiles $f
		$l insert end [DirDescribeFile $f]
	}

	foreach f [lsort $files] {
		lappend DirCurrentFiles $f
		$l insert end [DirDescribeFile $f]
	}

	set p [DirPathWidget]
	$p delete 0 end
	$p insert end $directory
}

# STUBS FOR NEOSOFT EXTENSIONS

proc unlink { filename } {
    tkerror "unlink not implemented"
}
