#
# mxedit.command --
#	Definitions for the command entry
#
# Copyright (c) 1992 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

# Imported globals
# mxBottomChild - the name of the widget before which the command
#	entry gets packed.  It is either the feedback or main
#	editing frame.

# Exported globals
# mxFocus - ordinarily the focus is shifted back to the main editing
#	window after a command, but this variable lets commands change
#	that default behavior by setting focus to the name of another widget

# File globals
# mxCommand - the name of the command entry
# mxCommandState - whether or not the command entry is visible
# mxCommandMenu - the menu that controls the command entry's visibility

proc mxCommandInit {} {
    global mxFocus
    set mxFocus default
}

# mxCommandEntry --
# An entry widget for entering commands

proc mxCommandEntry { parent { width 20 } { where {bottom fillx expand} } } {
    global mxCommand mxCommandState
    if [catch {labeledEntry $parent .command Command: $width $where} msg] {
	mxFeedback "labeledEntry failed $msg"
	return
    } else {
	set self $msg
	mxCommandBindings $self.entry
    }
    # labeldEntry packs us so the command window is visible
    set mxCommandState commandVisible
    set mxCommand $self
    return $self
}

# mxCommandFocus
#	Focus on the command window, making it visible if needed

proc mxCommandFocus { } {
    global mxCommand mxCommandState
    case $mxCommandState in {
	commandVisible { }
	commandHidden { mxCommandShow }
    }
    focus $mxCommand.entry
}

# mxCommandMenuEntry --
#	Set up the menu entry that controls the display of the command window
#	We'll remember the name of the menu so we can adjust the
#	menu entry to reflect the current state

proc mxCommandMenuEntry { menuName } {
    global mxCommandState mxCommandMenu

    set mxCommandMenu ${menuName}

    case $mxCommandState in {
	"commandVisible" {
	    mxMenuAdd $menuName "Hide command window" {mxCommandHide}
	}
	"commandHidden" {
	    mxMenuAdd $menuName "Open command window" {mxCommandShow}
	}
    }
}
# mxCommandHide --
#	Unpack the command window to save screen space

proc mxCommandHide { } {
    global mxCommand mxCommandState mxCommandMenu

    set mxCommandState commandHidden
    pack unpack $mxCommand
    mxMenuEntryConfigure $mxCommandMenu "Hide command window" \
	    -command { mxCommandShow } -label "Open command window"
}

# mxCommandShow --
#	Pack the command window so it shows up

proc mxCommandShow { } {
    global mxCommand mxCommandState mxCommandMenu
    global mxBottomChild

    set mxCommandState commandVisible
    pack before $mxBottomChild $mxCommand {bottom fillx frame s}

    mxMenuEntryConfigure $mxCommandMenu "Open command window" \
	    -command { mxCommandHide } -label "Hide command window"
}

# A flag to control if focus is returned to the editing window after a command
global focus
set focus default

# mxDoCmd --
#	Execute the commands issued to the command entry
#	This is ordinarily bound to hitting <Return> in the command entry

proc mxDoCmd { } {
    global focus
    global mxCommand

    set cmd [$mxCommand.entry get]
    if {[llength $cmd] != 0} {
	case [lindex $cmd 0] in {
	    {echo feedback mxFeedback} {
		# Echo inputs
		mxFeedback "$cmd"
	    } default {
		# Pass on the command to Tcl
		if [catch {uplevel #0 $cmd} msg] {
		    mxFeedback "Cmd failed: $msg"
		} else {
		    if {[string compare "$msg" ""] != 0} {
			mxFeedback $msg
		    } else {
			mxFeedback "ok"
		    }
		}
	    }
	}
    }
    # Let a command do its own focus if it wants,
    # otherwise return the focus to the editting window
    if {[string compare $focus "default"] == 0} {
	mxEditFocus
    }
    set focus default
}


