/*******************************************************************************

    TEST is a simple program based on the NIX utilities.  TEST registers
    standard input as an input source with the NIX I/O handler and then
    passes control to the NIX main loop.  Upon your hitting return at the
    end of a line of input, the NIX I/O handler invokes the callback function,
    READ_INPUT(), bound to the input source (standard input); READ_INPUT()
    simply reads and echoes the text you entered.

    NOTE: Because the VMS/UCX implementation of SELECT(2) only supports
          file descriptors for sockets, this test program, as written,
          won't work under VMS.  What I usually do is set up a half-
          or quarter-second NIX timer whose callback polls a channel
          assigned to standard input.

    Invocation (UNIX):

        % test
        This test of the NIX utilities echoes each line you enter ...

    Invocation (VxWorks):

        -> ld <test.vx.o
        value = 8379592 = 0x7fdcc8
        -> test
        This test of the NIX utilities echoes each line you enter ...

*******************************************************************************/


#include  <stdio.h>		/* Standard I/O definitions. */
#include  "nix_util.h"		/* Network I/O Handler definitions. */


/*******************************************************************************
    Standard input callback.
*******************************************************************************/

static  int  read_input (

#    if __STDC__ || defined(vaxc)
        NxAppContext  context,
        NxInputId  source_ID,
        int  source,
        void  *client_data)
#    else
        context, source_ID, source, client_data)

        NxAppContext  context ;
        NxInputId  source_ID ;
        int  source ;
        void  *client_data ;
#    endif

{
    char  buffer[128] ;

    if (gets (buffer) == NULL)  exit (0) ;
    printf ("read_input: %s\n", buffer) ;
}


/*******************************************************************************
    Main routine.
*******************************************************************************/

#ifdef VXWORKS

    int  test (

#        if __STDC__
            void)
#        else
            )
#        endif

#else

    int  main (

#        if __STDC__ || defined(vaxc)
            int  argc,
            char  *argv[])
#        else
            argc, argv)

            int  argc ;
            char  *argv[] ;
#        endif

#endif

{
    printf ("This test of the NIX utilities echoes each line you enter ...\n") ;
    NxAddInput (NULL, fileno (stdin), NxInputReadMask, read_input, NULL) ;
    NxMainLoop (NULL) ;
}
