# ~/.tk/edittkmodes/code-mode.tcl - mode for editing code
######################################################################

global MODE
j:read_prefs -array MODEPREFS \
  -directory $HOME/.tk/jeditmodes -file ${MODE}-defaults {
  {textfont default}
  {textwidth 80}
  {textheight 24}
  {textwrap char}
  {sabbrev 0}
  {dabbrev 0}
  {autobreak 0}
  {autoindent 1}
  {savestate 0}
}

######################################################################
# more procedures:

proc prefix {{prefix \#}} {
  jedit:pipenl [format {sed "s/^/%s/"} $prefix]
}

######################################################################
# define the Code menu:

if [winfo exists .menu.code] {
  destroy .menu.code
}

menubutton .menu.code -text {Code} -menu .menu.code.m

menu .menu.code.m
.menu.code.m add command -label {Comment with #} -command {prefix "# "}
.menu.code.m add command -label {Comment with ###} -command {prefix "### "}

pack append .menu .menu.code left

######################################################################
# define the button bar:

frame .main.buttons

button .main.buttons.done -width 8 -text {Done} -command {jedit:cmd:save; exit}
button .main.buttons.hash -width 8 -text {#} -command {prefix "# "}
button .main.buttons.hashes -width 8 -text {###} -command {prefix "### "}

pack append .main.buttons \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.done {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.hash {right pady 10} \
  [j:filler .main.buttons] {right filly} \
  .main.buttons.hashes {right pady 10}

pack after .main.status .main.buttons {top fillx}

set rule [j:rule .main]			;# so we can use in jedit:mode_cleanup
pack after .main.status $rule {top fillx}

proc jedit:mode_cleanup {} "
  pack unpack .menu.code
  destroy .menu.code
  pack unpack .main.buttons
  destroy .main.buttons
  pack unpack $rule
  destroy $rule
  rename prefix {}
"
