dnl Copyright (c) 1993 by Sanjay Ghemawat
dnl
acaux_fail=''
ccc_cflags=''
ccc_compile='$CCC $ccc_cflags $DEFS conftest.cc -o conftest >/dev/null 2>&1'
dnl
define(ACAUX_PROG_CCC,
[AC_PROVIDE([$0])AC_PROGRAMS_CHECK(CCC,cxx g++ cc++ CC)
if test -z "$CCC"; then
  cat << EOM
This package requires a C++ compiler, but I could not find one. Set
the environment variable CCC to the name of your C++ compiler and
rerun configure.
EOM
  exit 1
fi
if test "$CCC" = "g++"; then
  ccc_cflags="-Werror"
fi
])dnl
define(ACAUX_CCC_COMPILE_CHECK,
[AC_PROVIDE([$0])dnl
ifelse([$1], , , [echo checking for $1]
)dnl
cat > conftest.cc <<EOF
[$2]
int main() { return 0; }
void t() { [$3] }
EOF
dnl Don't try to run the program, which would prevent cross-configuring.
if eval $ccc_compile; then
  ifelse([$4], , :, [$4])
ifelse([$5], , , [else
  $5
])dnl
fi
rm -f conftest*]
)dnl
define(ACAUX_PROGRAM_FULLPATH,
[AC_PROVIDE([$0])AC_PROGRAMS_CHECK($1,$2)
if test -n "[$]$1"; then
  IFS="${IFS= 	}"; saveifs="$IFS"; IFS="${IFS}:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    if test "$dir" != "." && test -f "$dir/[$]$1"; then
      $1="$dir/[$]$1"
      break
    fi
  done
  IFS="$saveifs"
fi])dnl
define(ACAUX_LIB_FINDPATH,
[AC_PROVIDE([$0])
if test -z "[$]$1[lib]"; then
  echo checking for $1 library
  $1[lib]=nope
  if test -z "$prefix"; then
    dirs="/usr/local/lib /usr/lib"
  else
    dirs="$prefix/lib /usr/local/lib /usr/lib"
  fi
  for d in $dirs; do
    if test -f "$d/lib$1.a"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so.*"; then
      $1[lib]=$d
      break
    fi
  done
  if test "[$]$1[lib]" = nope; then
    cat << EOM
*** I could not find the $1 library.  Please set the environment variable
    $1[lib] to the directory that contains the library and rerun configure.
EOM
    acaux_fail=yes
  fi
fi
# Plug -L in front of it
$1[lib]="-L$[$1][lib]"
test -n "$verbose" && echo "	setting $1[lib] to [$]$1[lib]"
AC_SUBST($1[lib])])dnl
define(ACAUX_INC_FINDPATH,
[AC_PROVIDE([$0])
if test -z "$[$1]"; then
  echo checking for include file $2
  $1=nope
  if test -z "$prefix"; then
    dirs="/usr/local/include /usr/include"
  else
    dirs="$prefix/include /usr/local/include /usr/include"
  fi
  for d in $dirs; do
    if test -f "$d/$2"; then
      $1=$d
      break
    fi
  done
  if test "[$]$1" = nope; then
    cat << EOM
*** I could not find include file $2.  Please set the environment variable
    $1 to the directory that contains the include file and rerun configure.
EOM
    acaux_fail=yes
  fi
  if test "[$]$1" = "/usr/include"; then
    # Never put /usr/include in explicitly
    $1=
  fi
fi
# Plug -I in front of it
if test -n "$[$1]"; then
  $1="-I$[$1]"
fi
test -n "$verbose" && echo "	setting $1 to [$]$1"
AC_SUBST($1)])dnl
define(ACAUX_FIND_X,
[AC_PROVIDE([$0])
AC_FIND_X
if test -n "$no_x"; then
  cat << EOM
*** This package requires X11 header files and libraries but I could not find
    them.  Therefore this package may fail to compile.
EOM
  x_includes=/usr/include
  x_libraries=/usr/lib
fi
if test "$x_includes" = /usr/include; then
  x_includes=""
fi
if test -z "$x_includes"; then
  xinc=""
else
  xinc="-I$x_includes"
fi
if test "$x_libraries" = "/usr/lib"; then
  x_libraries=""
fi
if test -z "$x_libraries"; then
  xlib="-lX11"
else
  xlib="-L$x_libraries -lX11"
fi
test -n "$verbose" && echo "	setting xinc to $xinc"
test -n "$verbose" && echo "	setting xlib to $xlib"
AC_SUBST(xinc)
AC_SUBST(xlib)])dnl
dnl
dnl Exit if something failed
dnl
define(ACAUX_FAIL_CHECK,
[if test -n "$acaux_fail"; then
  exit 1
fi])dnl
