# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# String Dialog
#
# Commands
#
#	get_string <leader> <title> <message> <init> <var>
#		Get string from user.  The string is stored in <var>.
#		Returns true iff user does not cancel operation.

# Hidden global variables
#
#	str_init		Created str dialog window?
#	str_done		Is str interaction finished
#	str_value		String value

set str_init 0
set str_done 0
set str_value {}

proc get_string {leader title message init var} {
    str_make

    global str_value
    set str_value $init
    set result [str_interact $leader $title $message]
    if $result {
	upvar $var returnVar
	set returnVar $str_value
    }
    return $result
}

proc str_make {} {
    global str_init str_value str_done
    if {$str_init} {return}
    set str_init 1

    set f .string_dialog

    toplevel $f -class Dialog
    wm title $f Dialog
    wm protocol $f WM_DELETE_WINDOW {set str_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.mid -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    message $f.text -aspect 400 -text {Uninitialized message}
    entry $f.entry -relief sunken -textvariable str_value
    pack append $f.top $f.text {top expand fill padx 5m pady 5m}
    pack append $f.mid $f.entry {top expand padx 5m pady 5m}

    button $f.yes -text Okay -command {set str_done 1}
    button $f.no -text Cancel -command {set str_done 0}

    pack append $f.bot.default $f.yes {left padx 3m pady 3m}

    pack append $f.bot $f.no {left expand padx 5m pady 5m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top expand fill}
    pack append $f $f.mid {top expand fill}
    pack append $f $f.bot {bottom fill}

    bind $f.entry <Control-c> {set str_done 0}
    bind $f.entry <Return> {set str_done 1}

    wm deiconify $f
    update
}

proc str_interact {leader title message} {
    global str_done
    set f .string_dialog

    # Fix dialog contents
    $f.text configure -text $message
    wm title $f $title

    # Run dialog
    set str_done -1
    dialog_run $leader $f $f.entry str_done

    return $str_done
}
