.\" Copyright (c) 1993 by Sanjay Ghemawat
.TH ICAL 1 "October 27, 1993"
.SH NAME
ical \- X based calendar program
.PP
.SH DESCRIPTION
\fIIcal\fP provides an X interface for maintaining a calendar.  A
calendar is basically just a set of items. An item is either an
appointment, or a notice. An appointment starts at a particular time of
the day, and finishes at a particular time of the day. A notice does not
have any starting or ending time. Notices are useful for marking certain
days as special. For example, a calendar may contain a notice for April
15th indicating that taxes are due.  When the documentation below refers
to an \fIitem\fP, it applies both to notices and appointments.
The main features of \fIical\fP are:
.Ds
    * Items can be created edited and deleted easily.
    * Items can be cut, copied and pasted.
    * Items can be made to repeat in various ways.
    * \fIIcal\fP will post reminders for upcoming appointments.
    * \fIIcal\fP can print and list item occurrences.
    * An \fIical\fP calendar can include other calendars.
    * \fIIcal\fP calendars can be shared by different users.
.De
.SH GENERAL OPTIONS
You can specify various command line options to control \fIical\fP.  The
following general options can be used even when you are not logged in
on an X display.
.TP
.BI "\-calendar " file-name
The calendar is read from the specified file.  See the section
``CALENDAR FILE'' for more information.
.TP
.B \-list
Print a listing of today's items and exit immediately.  See the section
``LISTING ITEMS'' for details on the actual items printed by this option.
.TP
.BI "\-show " \fR+\fPdays
Print a listing for items in the range
[\ today\ .\|.\|.\ today\ +\ \fIdays\fP \-\ 1\ ] and exit immediately.  See
the section ``LISTING ITEMS'' for details on the actual items printed by
this option.
.SH X OPTIONS
The following options are valid only if you are logged in on an X
display.
.TP
.B \-iconic
Start up with the main window iconified.
.TP
.B \-popup
Popup a window containing a listing of today's items and exit as soon
as the window is dismissed.  See the section ``LISTING ITEMS'' for
details on the actual items printed by this option.
.TP
.B \-mono
Do not use colors even if the display supports them.
.TP
.BI "\-geometry " geometry
Use \fIgeometry\fP as the geometry for the main window.
.TP
.BI "\-fg " color
Use \fIcolor\fP as the foreground for all windows.
.TP
.BI "\-bg " color
Use \fIcolor\fP as the background for all windows.
.TP
.B "\-display " \fIdisplay\fP
Run \fIical\fP on the specified X display.
.SH CALENDAR FILE
A calendar is stored in a calendar file. The default calendar file is
named ``.calendar'' and is kept in the user's home directory. If the
``CALENDAR'' environment variable is set, its value is used as the
name of the calendar file. The ``CALENDAR'' environment variable and
the default can both be overridden by specifying a file name on the
command line \(em ``ical \-calendar \fIfile-name\fP''.
\fIIcal\fP periodically saves any modifications made to a calendar to
the corresponding calendar file. Changes can be explicitly saved to the
calendar file by selecting the \fISave\fP entry from the
\fIFile\fP menu.
You can discard any un-saved changes made to the calendar by selecting
the \fIRe-Read\fP entry from the \fIFile\fP menu. The
\fIRe-Read\fP entry is also useful for incorporating changes made to a
shared calendar by other users.
The \fIExit\fP entry in the \fIFile\fP menu saves any changes and
then kills the calendar program.
.SH WINDOWS
The main calendar window displays the appointments and notices for a
particular date.  The top left portion of the window contains a date
selector. You can click on the various arrows to change the month or
the year.  The day of the month can be selected by clicking on the
appropriate day in the month display.  The date selector contains
various other buttons for convenient date selection.
The bottom left portion of the window contains the notices for the
selected date. You can scroll this region by using the scroll bar.
The right portion of the window contains the appointments for the
selected day. You can scroll this region by using the scroll bar, or by
dragging with the middle mouse button in the background.
A menubar runs along the top of the calendar window.  The \fIFile\fP
menu allows you to create and destroy application windows.
.TP
.B New Window
Opens a new calendar window. This new window can be
used to view the items for a different date than the
original window.
.TP
.B Close Window
Closes the selected window.
.PP
The bottom portion of the window contains a status line. This status
line indicates the calendar from which the selected item comes and
whether or not the selected item repeats.
.SH NOTICES
You can enter notices by clicking in the background in the bottom-left
portion of the main calendar window. This click will create a new
notice for the selected date.  You can enter text into the notice by
typing into it while it is selected (selected notices are highlighted
by being displayed in different colors).  A notice can be selected for
editing by clicking with left button.
.SH APPOINTMENTS
You can enter appointments by left-clicking in the background in the
right portion of the main calendar window. This click will create a new
appointment for the selected date. The start time for this appointment
is determined by the click location. You can move the appointment by
dragging it with the middle mouse button held down. The appointment can
be resized by dragging with the right mouse button held down.
Appointment text can be edited by typing into the appointment window
while it is selected.  If the appointment text you are typing in does not
fit into the appointment area, then it will overflow out of the appointment
area, but will be editable normally.  If you do not like overflowing text,
you should turn off the \fIAllow Text Overflow\fP option in the \fIOptions\fP
menu.  With this option turned off, if the current text completely fills
the area allocated to the appointment, then any attempts to add to the
appointment text will be ignored until the appointment is enlarged
with the right mouse button.  Likewise, the right mouse button will
refuse to shrink an appointment window if the appointment text
completely fills the appointment window.
.SH ALARMS
\fIIcal\fP generates alarms for appointments. By default, the first
alarm is generated fifteen minutes before the appointment is
supposed to start and successive alarms are generated every five
minutes until the appointment actually starts.  You can change this
default behavior by selecting the \fIDefault Alarms\fP entry from the
\fIOption\fP menu.  You can also change the timings of these alarms
on an appointment-by-appointment basis by selecting an appointment and
then selecting the \fIChange Alarms\fP entry in the \fIEdit\fP menu.
.SH REPEATING ITEMS
Items can be made to repeat in various ways. Item repetition can be
controlled by using the entries in the \fIRepeat\fP menu.  These
entries make the item repeat in certain frequently used ways. For
example, the \fIMonthly\fP entry makes the selected item repeat once
per month.
In addition to making an item repeat in one of the pre-defined ways,
you can also restrict an item's starting and finishing date by
selecting the \fIMake First Date\fP or the \fIMake Last Date\fP
entry from the \fIRepeat\fP menu.
Normally, a modication to a repeating item applies to all occurrences of
that item. A single occurrence of a repeating item can be modified by
selecting the occurrence and then choosing the \fIMake Unique\fP entry
from the \fIEdit\fP menu.  The selected occurrence can now be modified
independently of the repeating item.
.SH X SELECTION
Dragging with the left mouse button in a selected appointment or
notice sets the X selection.  You can use the \fIInsert Selection\fP
entry in the \fIEdit\fP menu to insert the current X selection into a
selected item.  You can use the \fIImport Selection\fP entry in the
edit menu to insert the current X selection as a new item.  \fIIcal\fP
guesses the date and time for the new item from the contents of the
selection.
.SH CLIPBOARD
The application has a clipboard that can store a single item. The
\fICopy\fP entry in the \fIEdit\fP menu copies the selected item into
the clipboard.  The \fICut\fP entry does the same, but it also deletes
the item from the calendar. If the selected item repeats, then the
\fICut\fP command allows the user to delete all occurrences of the
item, or just the selected occurrence.  However, if the selected
item does not belong to you, then \fICut\fP just hides the item
from you.  Other people will still see the item.
An item in the clipboard can be inserted into the current day by
selecting \fIPaste\fP from the \fIEdit\fP menu. The newly pasted item
loses all repetition information, and occurs just on the day in which
it was pasted.
.SH HIGHLIGHTING ITEMS
By default, if any item occurs on a date, then the date is highlighted
in the date selector located in the top-left corner of the calendar
window.  You can use the \fIHighhlight\fP sub-menu in the \fIEdit\fP
menu to control this highlighting behavior on an item-by-item basis.
.IP Always
The item always causes the corresponding date to be highlighted.
This is the default behavior.
.IP Until\ Occurrence
The item causes the corresponding date to be highlighted if and
only if the date is not in the past.
.IP Never
The item never causes the corresponding date to be highlighted.
.IP As\ Holiday
The item causes the corresponding date to be highlighted as a holiday.
.SH LISTING ITEMS
You can generate listings of imminent items by selecting one of the
listing options in the \fIList\fP menu.  You can also use the command
line options \fB\-list\fP, \fB\-show\fP, or \fB\-popup\fP to generate
item listings.  The command line options are most useful in ``.login''
files.
By default an item is included in a listing for a particular date if
it occurs either on that date, or on the very next day. Sometimes, you
want to include an item in listings for earlier dates. For example, if
you have an item reminding you of a birthday on March 17th, you might
want this item to be included in all listings from March 7th to March
17th so that you will have enough time to go out and buy a present.
You can achieve this effect by selecting the \fITen Days Early\fP
option from the \fIList Item\fP entry in the \fIEdit\fP menu.  Note
that this will only change the listing behavior for the selected item.
You can make this change for all items you create from now on by
using the \fIDefault Listings\fP entry in the \fIOptions\fP menu.
The \fIA Day Early\fP entry restores the default behavior. The \fIOn
Occurence\fP entry marks the item so that it is only included in the
listing for a particular date if it occurs on that date.
.SH PRINTING
Calendar contents can be printed by selecting the \fIPrint\fP option
from the \fIFile\fP menu.  The user has the option of saving the
print-out to a file, previewing the print-out by specifying a
PostScript displaying program, or sending the print-out directly to a
PostScript printer.
.SH INCLUDING CALENDARS
You can include other calendars into your private calendar. This
facility is mainly useful for allowing a group of people to share a
common set of items. For example, members of a particular group might
have a calendar that contains the birthdays for each member of the
group. This calendar can be included in each group member's private
calendar.
You can include a calendar by selecting the \fIInclude Calendar\fP
entry from the \fIFile\fP menu. You can remove an included
calendar by selecting the \fIRemove Calendar\fP entry from the
\fIFile\fP menu.
An item can be moved between calendars by selecting the \fIMove Item
To .\|.\|.\fP entry from the \fIEdit\fP menu.
You can list all items in a particular calendar by selecting the
\fIFrom Calendar .\|.\|.\fP entry from the \fIList\fP menu.
.SH CUSTOMIZATION
Limited portions of \fIical\fP can be customized via the
\fIOptions\fP menu.
.IP Appointment\ Range
Subset of a day displayed by default in the appointment listing.
The factory settings display 8:00am to 6:00pm.
.IP Notice\ Window\ Height
This entry can be used to change the height of the notice window.
.IP Item\ Width
This entry can be used to change the width of displayed appointments
and notices.
.IP Allow\ Text\ Overflow
If this option is selected, then you can type in any amount of text into
an appointment.  The part of the text that does not fit into the
appointment will be allowed to overflow out of the appointment.  If you
do not like text overflowing out of an appointment, then you should turn
off this option.
.IP Display\ Am/Pm
If this option is selected, time will be printed in twelve hour mode
with ``am'' or ``pm'' indicators.  Otherwise, time will be printed
in twenty-four hour mode.
.IP Start\ Week\ on\ Monday
If this option is selected, month displays will start each week off
on a Monday.  Otherwise, each week will start on a Sunday.
.IP Default\ Alarms
Use this menu entry to change the time intervals at which alarms
go off.  The factory settings cause alarms to be triggered fifteen
minutes before each appointment, and then once every five minutes
until the appointment actually starts.
This menu entry changes the default alarm behavior for all appointments.
You can override this default behavior on an appointment-by-appointment
basis by selecting an appointment and then selecting the \fIChange Alarms\fP
entry in the \fIEdit\fP menu.
.IP Default\ Listings
This menu can be used to select the default listing behavior for
newly created items.  If the \fIOn Occurrence\fP entry is selected,
then a newly created item will only be shown in the listing of
the day on which the item occurs.  If the \fIA Day Early\fP entry
is selected, then a new item will be shown in listings starting a day
before the item occurrence.  Similarly, the other menu entries can
be selected to make new items show up in listings a number of days
before their actual occurrence.
This menu selects the default behavior for new items.  Individual
item behavior can be controlled by similar entries in the \fIEdit\fP
menu.
.PP
You can specify several X resources to customize the rest of the
appearance and behavior of \fIical\fP.
.SS BEHAVIOR
.IP Ical.pollSeconds
Calendar files are saved, and changes made by
other people are incorporated once every \fIpollSeconds\fP seconds.
The default value is 30.  If \fIical\fP appears sluggish, or if it is using
too much CPU time, increase this value.
.SS DIMENSIONS
.IP Ical.itemSelectWidth
The border width of selected items is set to the value of this option
to display the selected status of the item to to the user.  On color
displays, the default value of this option is ``1'' because on color
displays selection is indicated by changing the color of the selected
item.  On monochrome displays, the default value of
\fIitemSelectWidth\fP is ``4''.
.IP Ical.Dayview.geometry
X geometry specification for main calendar window.  Usually, you will
just specify the window position here.  The size of the window is
easier to control via the \fIOptions\fP menu.
.IP Ical.Reminder.geometry
X geometry specification for alarms.  Usually, you will just specify
the window position here.  The window size will be calculated
automatically.
.IP Ical.Listing.geometry
X geometry specification for item listings.  Usually, you will
just specify the window position here.  The window size will be
calculated automatically.
.SS COLORS
If \fIical\fP windows show up with illegible colors (not enough distinction
between background and foreground), it may be because your X resources
contain definitions for ``*foreground'' or ``*background'' that conflict
with \fIical\fP colors.  In general, it is a bad idea to define
``*foreground'' and ``*background'' in your resources because it will
break a number of programs.  You will be better off defining resources
on an application by application basis.
.\".RS
.IP Ical*foreground
.ns
.IP Ical*background
Set the colors used for most of the \fIical\fP windows.
.\".RS
.\".RS
.IP Ical.itemFg
.ns
.IP Ical.itemBg
The foreground and background colors for unselected items.  The default
foreground is black and the default background is gray.
.IP Ical.itemSelectFg
.ns
.IP Ical.itemSelectBg
The foreground and background colors for selected items.  The default
foreground is yellow and the default background is blue.
.IP Ical.apptLineColor
The color for the background lines and times displayed in the
appointment window.
.IP Ical.weekdayColor
The color used to display days of the week.  The default is black.
.IP Ical.weekendColor
The color used to display weekends.  The default is red.
.IP Ical.interestColor
The color used to highlight interesting dates.  The default is blue.
.SS FONTS
.IP Ical.fontFamily
Preferred font family.  Fonts for various purposes are obtained from
this family unless overridden with one of the specifications below.
The default font family is ``times''.  Some other font families you can
specify here are ``charter'', ``new century schoolbook'', and ``helvetica''.
.IP Ical.itemFont
Font used to display item contents.
.IP Ical.weekdayFont
Font used for displaying days of the week.
.IP Ical.weekendFont
Font used for displaying weekends.
.IP Ical.interestFont
Font used to highlight interesting dates.
.IP Ical.smallHeadingFont
Font used for small headings.
.IP Ical.largeHeadingFont
Font used for large headings.
.ifn.ds cL <class>
.ift.ds cL class
.IP Ical*\fI\*(cL\fP*font:
Font used for windows of a certain class.  Possible values for
\fI\*(cL\fP are ``Dialog'', ``Button'', ``Label'', ``Menubutton'', ``Menu'',
``Listbox'', and ``Reminder''.
.SH AUTHOR
Sanjay Ghemawat (sanjay@lcs.mit.edu)
.SH COPYRIGHT
Copyright (c) 1993 by Sanjay Ghemawat.
Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.
