# main.tcl
#
# Main body of the application.  Note that system-dependent global
# variable settings have been defined in the exmh script.
#
# Copyright (c) 1993 Xerox Corporation.
# Use and copying of this software and preparation of derivative works based
# upon this software are permitted. Any distribution of this software or
# derivative works must comply with all applicable United States export
# control laws. This software is made available AS IS, and Xerox Corporation
# makes no warranty about the software, its performance or its conformity to
# any specification.

proc Exmh {} {
    global exmh

    global tk_version
    if {$tk_version >= 3.3} {
	# Do this so popups related to user initialization
	# appear all alone.  However, in 3.2 there is a
	# bug with updating windows that are unmapped.
	wm withdraw .
    }
    Mh_Init		;# Defines mhProfile

    Preferences_Init exmh ~/.exmh-defaults $exmh(library)/app-defaults

    # Add this preference, which as a side effect defines
    # the exmh(userLibrary) variable from the .exmh-defaults file...
    Preferences_Add {
	{exmh(userLibrary)	userLibrary ~/.tk/exmh	{User library directory}
"You can override modules of the exmh implementation
by putting your versions into a private library directory.
Remember to update the tclIndex file with auto_mkindex
after you add things to that directory."}
    }

    ExmhArgv		;# snarf up command-line arguments

    # Support per-user customization
    if [info exists exmh(userLibrary)] {
	auto_path_update $exmh(userLibrary)
    }

    ExmhLogInit		;# Enables debug loging

    if [catch {User_Init} err] {
	puts stderr "User_Init: $err"
    }

    # The order of the following mainly determines the way
    # their associated items appear in the Preferences dialog
    Sedit_BindInit	;# Text, Entry class bindings
    Sedit_Init		;# built in editor 
    Edit_Init		;# interface to external editors
    Print_Init
    Buttons_Init	;# Before Msg_Init
    Msg_Init
    Folder_Init		;# Sets exmh(folder)
    Ftoc_Init
    Inc_Init
    Exwin_Init
    Flist_Init
    Fcache_Init
    Fdisp_Init		;# After Flist and Fcache
    Sound_Init
    Faces_Init
    Background_Init

    wm protocol . WM_DELETE_WINDOW Exmh_Done

    Exwin_Layout
    if [catch {User_Layout} err] {
	puts stderr "User_Layout: $err"
    }
    Exmh_Status $exmh(version)
    if {! $exmh(iconic)} {
	wm deiconify .
    } else {
	wm iconify .
    }
    update

    Folder_Change $exmh(folder)
    busy ExmhJunk
}
proc ExmhJunk {} {
    Inc_Startup
    Exmh_Focus
    Background_Startup
}

proc ExmhArgv {} {
    global argc argv exmh
    set extra {}
    set geo [option get . geometry Geometry]
    set icon [option get . iconposition IconPosition]
    set iconic [option get . iconic Iconic]
    for {set i 0} {$i < $argc} {incr i} {
	set arg [lindex $argv $i]
	case $arg {
	    "-geo*" {
		incr i
		set geo [lindex $argv $i]
	    }
	    "-iconposition" {
		incr i
		set icon [lindex $argv $i]
	    }
	    "-iconic" {
		set iconic 1
		option add *Fltop.iconic 1
	    }
	    default {
		lappend extra $arg
	    }
	}
    }
    # wish snarfs up -geometry and puts it into "geometry"
    global geometry
    if [info exists geometry] {
	set geo $geometry
    }
    if {$geo != {}} {
	if [catch {wm geometry . $geo} err] {
	    puts stderr "-geometry $arg: $err"
	}
    }
    if {$iconic != {}} {
	set exmh(iconic) $iconic
    } else {
	set exmh(iconic) 0
    }
    if {$icon != {}} {
	Exwin_IconPosition . $icon
    }

    set argv $extra
    set argc [llength $extra]
}
proc Exmh_Focus {} {
    global exwin
    focus $exwin(mtext)
}

set exmhPrefs {
    {exwin(ftextLines)	ftextLines 15	{Folder lines}
"Lines in the folder display window."}
    {exwin(mtextLines)	mtextLines 25	{Message lines}
"Lines in the message display window."}
    {exmh(logEnabled)	logEnabled OFF	{Debug log enabled}
"Debug information is recorded in log that you can view
from within exmh.  Turning off the log may save some
memory usage.  You can enable the log temporarily."}
}

proc Exmh_Status {string { color black } } {
    global exmh exwin
    if { $string == 0 } { set string $exmh(version) }
    if [info exists exwin(status)] {
	catch {$exwin(status) configure -fg $color}
	$exwin(status) delete 0 end
	$exwin(status) insert 0 $string
	ExmhLog $string
	update idletasks
    } else {
	puts stderr $string
    }
}

proc Exmh_CheckPoint {} {
    Scan_CacheUpdate
    Msg_CheckPoint
}

proc Exmh_Done {} {
    if { [Ftoc_Changes "exit"] == 0} then {
	Exmh_Status "Checkpointing state" red
	Exmh_CheckPoint
	Fcache_CheckPoint
	Background_Cleanup
	destroy .
    }
}
proc Exmh_Abort {} {
    Background_Cleanup
    destroy .
}

#### Exmh_Debugging

proc Exmh_Debug { args } {
    global exmhDebug
    if ![info exists exmhDebug] {
	set exmhDebug 0
    }
    if {$exmhDebug} {
	puts stderr $args
    }
    ExmhLog $args
}

proc ExmhLogInit {} {
    global exmh
    set exmh(logButton) 0
    set exmh(logWindow) 0
    Preferences_Add {
	{exmh(logEnabled)	logEnabled OFF	{Debug log enabled}
"Debug information is recorded in log that you can view
from within exmh.  Turning off the log may save some
memory usage.  You can enable the log temporarily."}
    }
}
proc ExmhLog { stuff } {
    global exmh
    if {![info exists exmh(logEnabled)]} {
	return
    }
    if {! $exmh(logEnabled)} {
	return
    }
    if {! $exmh(logButton)} {
	global exwin
	if [info exists exwin(mainButtons)] {
	    Widget_AddBut $exwin(mainButtons) log "Log" { ExmhLogShow }
	    set exmh(logButton) 1
	}
    }
    if {! $exmh(logWindow)} {
	set exmh(logWindow) 1
	set exmh(logTop) [Widget_Toplevel .log "Exmh Log" Log]
	wm withdraw $exmh(logTop)
	Widget_Frame $exmh(logTop) but Menubar {top fill}
	Widget_AddBut $exmh(logTop).but quit "Dismiss" [list wm withdraw $exmh(logTop)]
	Widget_AddBut $exmh(logTop).but trunc "Truncate" ExmhLogTrunc
	Widget_AddBut $exmh(logTop).but save "Save To File" ExmhLogSave
	set exmh(log) [Widget_Text $exmh(logTop) 20 -setgrid true]
    }
    if [info exists exmh(log)] {
	$exmh(log) insert end $stuff
	$exmh(log) insert end \n
	$exmh(log) yview -pickplace "end - 1 lines"
    }
}
proc ExmhLogShow {} {
    global exmh
    wm deiconify $exmh(logTop)
}
proc ExmhLogTrunc {} {
    global exmh
    $exmh(log) delete 1.0 end
}
proc ExmhLogSave {} {
    global exmh
    for {set id 0} {$id < 100} {incr id} {
	set name /tmp/exmhlog.$id
	if ![file exists $name] {
	    if ![catch {open $name w} logfile] {
		break
	    }
	}
    }
    if [catch {
	puts $logfile [$exmh(log) get 1.0 end]
	close $logfile
	Exmh_Status "Saved log in /tmp/exmhlog.$id" blue
    } msg] {
	Exmh_Status "Cannot save log: $msg" purple
    }
}
#### Misc

proc TraceInfo {} {
    if {[info commands tclanalyze] != {}} {
	catch {destroy .traceinfo}
	Widget_Toplevel .traceinfo
	text .traceinfo.msg -width 50 -height 10
	pack append .traceinfo .traceinfo.msg {top expand fill}
	.traceinfo.msg insert end [tclanalyze info]
	bind .traceinfo.msg <Button-1> {destroy .traceinfo}
    }
}

proc DoNothing { args } {
    return ""
}



