# Bindings for managing the Beth window.


# Beth grab control

set beth_control 0

proc take_control {f} {
	global beth_control ;	set beth_control 1
	catch {label $f.grab -text "Grab"}
	pack $f.grab -side left
	update ; update idletasks
	catch {grab -global .}
}

proc relinquish_control {f} {
	global beth_control ;	set beth_control 0
	catch {grab release .}
	catch {destroy $f.grab}
}

proc toggle_control {f} {
	if {([grab status .] != "none")} {relinquish_control $f
	} else {take_control $f}
}

proc wm_raise {f} {
	set regrab [grab status .]
	if {![winfo ismapped .]} {wm deiconify .}
	raise .
	if {($regrab != "none")} {relinquish_control $f; take_control $f}
}


# Window configuration options
# To resize windows, we do a widget_resize on the text widget

# Used in a hack in window_move, this gets set to the outer border width later.
set border ""

# Returns proper window geometry (i.e. doing wm geometry . results does the
# Right Thing)
proc wm_geometry {} {
	scan [wm geometry .] {%dx%d+%d+%d} h v hp vp
	global border
	if {($border == "")} {
		scan [winfo geometry .] {%dx%d+%d+%d} ih iv ihp ivp
		set border [expr "$ihp - $hp"]
	}
	return "$hp $vp"
}

# Moves window up/down/left/right based on option and d (same as widget_resize)
proc window_move {option d} {
	set grid [wm grid .]
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {incr hp [expr "(0 $d)*[lindex $grid 2]"]
	} else {incr vp [expr "(0 $d)*[lindex $grid 3]"]}

	wm geometry . "+$hp+$vp"
	update ; update idletasks
}

# A handy option, this moves window under window of previous interp,
# or previous deiconified interp.
proc wm_move_under {t iconified} {
	set interp [another_interp -1 $iconified]
	if {[scan [check_send $interp winfo geometry .] {%dx%d+%d+%d} \
			his_width his_height his_x his_y] < 4} return
	wm geometry . "+$his_x\+[expr $his_y + $his_height]"
}

# Puts window on top/left edge of scrren based on option.
proc window_set {option} {
	global border
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {set string "+$border+$vp"
	} else {		set string "+$hp+$border"}

	wm geometry . $string
	update ; update idletasks
}


# Using the grid.

set grid_on_x 0
set grid_on_y 0

if {![info exists grid_x]} {
	if {[winfo parent [winfo parent $text]] == {.}} {set grid_x .gridx
	} else {set grid_x "[winfo parent [winfo parent $text]].gridx"}
}
if {![info exists grid_y]} {
	if {[winfo parent $text] == {.}} {set grid_y .gridy
	} else {set grid_y "[winfo parent $text].gridy"}
	set grid_width 4
	set text_nowrap_on_grid 1
}

proc fill_gx_text {t gx} {
	$gx configure -state normal
	set width [lindex [$t configure -width] 4]
	$gx delete 1.0 end
	for {set column 0} {$column <= $width} {incr column} {
		set char [string index $column [expr [string length $column] - 1]]
		if {$char == 0} {$gx insert end "_"
		} else {$gx insert end $char}}
	$gx configure -state disabled
}

proc toggle_grid_x {t g} {
	global text_configs grid_on_x

	if {[winfo exists $g]} {
# turn grid off
		set grid_on_x 0
		destroy $g
	} else {
# turn grid on
		set grid_on_x 1
		set columns [lindex [$t configure -width] 4]
		set configs "-font [lindex [$t configure -font] 4] \
			-width $columns -setgrid false -height 1"
		eval text $g $text_configs $configs -relief raised
		fill_gx_text $t $g
		pack $g -side top -anchor e -pady 5
}}

# Called by a text widget to tell t what to yview
proc text_yview {t dummy1 dummy2 y dummy4} {$t yview $y}

proc toggle_grid_y {t g} {
	global text_configs scrollbar grid_on_y grid_width
	global text_nowrap_on_grid text_wrap

	if {[winfo exists $g]} {
# turn grid off
		set grid_on_y 0
		preserve_window_size {
			destroy $g
			if {[lindex [$t configure -wrap] 4] != $text_wrap} {
				$t configure -wrap $text_wrap}
			$t configure -yscrollcommand "$scrollbar set"}
	} else {
# turn grid on
		set grid_on_y 1
		set configs "-font [lindex [$t configure -font] 4] \
			-height [lindex [$t configure -height] 4] \
			-width $grid_width -wrap none"
# Figure out the scrollbar being used.
		scan [lindex [$t configure -yscrollcommand] 4] "%s set" scrollbar
		eval text $g $text_configs $configs -relief raised \
			-yscrollcommand [list [list $scrollbar set]]
		$t configure -yscrollcommand "text_yview $g"
		if $text_nowrap_on_grid {
			set text_wrap [lindex [$t configure -wrap] 4]
			$t configure -wrap none
		}
		pack $g -side left
		scan [$t index end] "%d." lines
		for {set line 1} {$line <= $lines} {incr line} {
			$g insert end "$line\n"}
#noop command, intended to cancel out scanning.
		parse_bindings $g {B2-Motion ButtonPress-2} {info tclversion}
		$g configure -state disabled
}}


# Maintaining proper window size.

# Executes cmds while not reconfiguring the window.
proc execute_window_adjustments {cmds} {
	set binding [bind all <Configure>]
	bind all <Configure> {}
	uplevel 1 $cmds
	wm geometry . {}
	update
	bind all <Configure> $binding
}

proc absolute_text_resize {t gx gy width height} {execute_window_adjustments {
	set old_width [lindex [$t configure -width] 4]
	set old_height [lindex [$t configure -height] 4]
	if {$height != $old_height} {
		$t configure -height $height
		if {[winfo exists $gy]} {
			$gy configure -height $height
	}}
	if {$width != $old_width} {
		$t configure -width $width
		if {[winfo exists $gx]} {
			$gx configure -width $width
			fill_gx_text $t $gx
}}}}

proc preserve_window_size {cmds} {
	global text grid_x grid_y
	set height [lindex [$text configure -height] 4]
	set width [lindex [$text configure -width] 4]
	uplevel 1 $cmds
	absolute_text_resize $text $grid_x $grid_y $width $height
}

# For resizing stuff via the window manager
proc external_text_resize {t gx gy} {
	if {[lindex [$t configure -setgrid] 4] == 0} {return}
	scan [wm geometry .] {%dx%d} width height
	absolute_text_resize $t $gx $gy $width $height
}

# For resizing stuff via a menu option or keybinding.
proc internal_text_resize {t gx gy option value} {
	if {[lindex [$t configure -setgrid] 4] == 0} {return}
	execute_window_adjustments {
		widget_resize $t $option $value
		if {[winfo exists $gy] && ($option == "-height")} {
			widget_resize $gy $option $value}
		if {[winfo exists $gx] && ($option == "-width")} {
			widget_resize $gx $option $value
			fill_gx_text $t $gx
}}}


# Window bindings. f is a frame widget to put messages in. gx and gy are
# possible grid widgets.
proc windowbind {f t m gx gy} {
	global Keys

	parse_bindings Text \
$Keys(C_bracketleft)		"internal_text_resize %W $gx $gy -height -1" \
$Keys(C_braceleft)		"internal_text_resize %W $gx $gy -height +1" \
$Keys(C_bracketright)		"internal_text_resize %W $gx $gy -width -1" \
$Keys(C_braceright)		"internal_text_resize %W $gx $gy -width +1"

	parse_bindings Entry \
$Keys(C_bracketright)		{widget_resize %W -width -1} \
$Keys(C_braceright)		{widget_resize %W -width +1}

	parse_bindings all \
Configure			"external_text_resize $t $gx $gy" \
M-C-c				"toggle_control $f" \
M-i				"wm_raise $f" \
M-K-M				"wm_move_under $t 1" \
M-m				"wm_move_under $t 0" \
M-x				"toggle_grid_x $t $gx" \
M-y				"toggle_grid_y $t $gy" \
$Keys(M_bracketright)		{window_move -width -1} \
$Keys(M_braceright)		{window_move -width +1} \
$Keys(M_bracketleft)		{window_move -height -1} \
$Keys(M_braceleft)		{window_move -height +1} \
$Keys(C_M_bracketright)		{window_set -width} \
$Keys(C_M_bracketleft)		{window_set -height}

	if {[winfo exists $m]} {parse_menu $m \
{Window 0} \
{Interpreter 0}

		$m.interpreter.m add checkbutton -label Control -underline 0 \
			-command [return_menubinding Meta-Control-c c] \
			-variable beth_control -offvalue 0 -onvalue 1 \
			-accelerator M-C-c

		$m.window.m add checkbutton -label "Horizontal Grid" \
			-command [return_menubinding Meta-x x] \
			-variable grid_on_x -offvalue 0 -onvalue 1 \
			-accelerator M-x -underline 0
		$m.window.m add checkbutton -label "Vertical Grid" \
			-command [return_menubinding Meta-y y] \
			-variable grid_on_y -offvalue 0 -onvalue 1 \
			-accelerator M-y -underline 0

		parse_menuentries $m.window.m {
				separator
	{Resize 0 ""	{"Right Edge Left" 11 {C-bracketright {]}}}
			{"Right Edge Right" 11 {C-braceright "\}"}}
			{"Bottom Edge Up" 12 {C-bracketleft {[}}}
			{"Bottom Edge Down" 12 {C-braceleft "\{"}}}
	{Move 0	""	{Left 0 {M-bracketright {]}}}
			{Right 0 {M-braceright "\}"}}
			{Up 0 {M-bracketleft {[}}}
			{Down 0 {M-braceleft "\{"}}
			{"Left of Screen" 1 {C-M-bracketright {]}}}
		 	{"Top of Screen" 2 {C-M-bracketleft {[}}}
			{"Below last Shown Interpreter" 0 M-m}
			{"Below last Interpreter" 4 {M-K-M M-M}}}
			{Raise 1 M-i}}

# This can't be specified above. (since bind thinks Meta-M = Meta-Meta)
		$m.window.m.move entryconfigure 7 -accelerator M-M
}}


windowbind $frame $text $menu $grid_x $grid_y
