# Bindings for a make command
#
# This mainly defines one procedure: visit_next_error, which brings up a Beth
# interpreter on the next compiler error.

# Checks to see if index begins a line with a compiler error on it.
proc check_error {t index} {
	set list [split [$t get $index "$index lineend"] ":, "]

# The line number is the first number in the string. IF none exist, return "".
	set prelims ""
	set line -1
	foreach item $list {
		if {($item != "") && ([scan $item "%d.%d" line column] != 0)} {
			break
		} else {lappend prelims $item}
	}
	if {$line == -1} {return ""}

# Now prelims contains the stuff before the line#. Last item in prelim is
# either 'line' or the filename. (possibly in quotes).
	set file_no [llength $prelims]	; incr file_no -1
	while {([string toupper [lindex $prelims $file_no]] == "LINE") ||
		([lindex $prelims $file_no] == "")} {incr file_no -1}

# Now file_no points to file in prelims. If nonexistant, return ""
	set file [string trim [lindex $prelims $file_no] {"}]
	if {![file exists $file]} {return ""}
	return [list $file $line]
}

proc visit_file_line {file line} {
	global frame
	set path [file dirname $file]
	set cwd [pwd]
	cd $path
	set path [pwd]
	cd $cwd
	set interp [goto_file $frame $path [file tail $file]]
	if {$interp == ""} {return 0}
	send $interp "move_insert \$text $line.0"
	return 1
}

proc visit_next_error {t} {
	scan [$t index insert] "%d.%d" row dummy
	incr row
	while {[$t compare "$row.0" < end]} {
		set info [check_error $t "$row.0"]
		if {$info != ""} {
			if {[eval visit_file_line $info]} {
				set index "$row.0"
			} else {set index "$row.0 -1c"}
			move_insert $t $index
			return}
		incr row
	}
	beep ; return
}


# Make bindings.
proc makebind {m} {
	parse_bindings Text \
M-e		{visit_next_error %W}

	if {[winfo exists $m]} {
		parse_menuentries $m.extras.m {
					{"Next Error" 5 M-e}}
}}

makebind $menu
