# Command execution


# Executes cmds, but meanwhile declares that Beth is busy.
proc beth_busy {t args} {
	update ; update idletasks

	# Indicate process is busy
	set cursor [lindex [$t config -cursor] 4]
	set offtime [lindex [$t config -insertofftime] 4]
	$t config -cursor watch -insertofftime 0
	set title [wm title .];	set iconname [wm iconname .]
	wm title . "*BUSY* $title";	wm iconname . "* $iconname"
	update ; update idletasks

	set error [catch {uplevel eval [list $args]} result]

	# Free up program now.
	wm title . $title ; 	wm iconname . $iconname
	update ; update idletasks
	$t config -cursor $cursor -insertofftime $offtime
	if $error {	error $result} else {	return $result
}}

# Figures out how to undo inserting output into text widget.
proc figure_out_undo_insert {t output} {
	global modified ; 	set modified 1

	# Figure out how to undo pasting command.
	set ustart [gensym];	set uend [gensym]
	$t mark set $uend insert
	$t mark set $ustart "insert -[string length $output] chars"
	register_undoable_cmd $t [list $t delete $ustart $uend] "Insert $output" "$ustart $uend"
}

# Inserts some output into text widget.
proc insert_output {t output} {
	global edit_flag
	if {$output == ""} {return}
	if {(!$edit_flag)} {
		tkerror "can't insert:\n$output"
		return 0
	}
	$t insert insert "$output\n"
	figure_out_undo_insert $t "$output\n"
}

set use_output 1
set use_input 0

# Execs a command to exec
proc execute_shell_command {t cmd} {
	set input 0 ; set output 0
	if {[string match \|* $cmd]} {
		set cmd [string range $cmd 1 [expr [string length $cmd] - 1]]
		set input 1
	}
	if {[string match *\| $cmd]} {
		set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
		set output 1
	}

	global use_output use_input
	if $use_output {set output 1}
	if $use_input {set input 1}

	if $input {
		global default_tmpfile
		if {([catch {$t get sel.first}])} {
			set beginning 1.0
			set end end
		} else {set beginning sel.first
			set end sel.last
		}
		set p [open $default_tmpfile w+]
		puts $p [$t get $beginning $end]
		flush $p
		seek $p 0
		set er [catch "exec <@ $p $cmd" result]
		close $p
		exec rm $default_tmpfile
	} else {set er [catch "exec $cmd" result]}

	if $output {insert_output $t $result
	} elseif $er {tkerror $result
}}

# Executes shell command, after prompting user for cmd.
proc setup_shell_cmd_aux {t l e default_cmd} {
	set cmd [$e get]
	destroy_f_entry $t $l $e
	global $default_cmd ; 	set $default_cmd $cmd

	set index [$t index insert]

	beth_busy $t execute_shell_command $t $cmd
}

# Prompts user for a shell cmd.
proc setup_shell_cmd {t f {prompt "Cmd to execute:"} {default_cmd sh_cmd}} {
	global $default_cmd default_tmpfile Keys
	if {($default_cmd == "sh_cmd")} {set $sh_cmd ""
	} else {global use_input ; set use_input 0
		global use_output ; set use_output 0
	}
	create_f_entry $t $f.shl $f.she {complete_string filter_glob ""}
	$f.shl configure -text $prompt
	$f.she insert 0 [set $default_cmd]
	parse_bindings $f.she $Keys(C_m) \
			"setup_shell_cmd_aux $t $f.shl $f.she $default_cmd"
}

# Execs a command in wish
proc execute_wish_command {t cmd} {
	set output 0
	if {[string match *\| $cmd]} {
		set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
		set output 1
	}
	global use_output
	if $use_output {set output 1}

	set er [catch {uplevel #0 $cmd} result]

	if $output {insert_output $t $result
	} elseif $er {tkerror $result
}}

# Executes wish command, after prompting user for cmd.
proc setup_wish_cmd_aux {t l e default_cmd} {
	set cmd [$e get]
	destroy_f_entry $t $l $e
	global $default_cmd ; 	set $default_cmd $cmd

	set index [$t index insert]

	beth_busy $t execute_wish_command $t $cmd
}

# Default command to send to wish
set wish_cmd ""

# Prompts user for a wish cmd.
proc setup_wish_cmd {t f} {
	global wish_cmd Keys
	create_f_entry $t $f.shl $f.she {complete_string filter_cmds ""}
	$f.shl configure -text "Wish Command:"
	$f.she insert 0 $wish_cmd
	parse_bindings $f.she $Keys(C_m) \
			"setup_wish_cmd_aux $t $f.shl $f.she wish_cmd"
}


# Command bindings. f is a frame widget to put messages in.
proc commandbind {f t m} {

	parse_bindings all \
C-g		"+catch \{destroy_f_entry $t $f.shl $f.she\}" \
M-C-e		"setup_shell_cmd $t $f {Exec Command:} sh_cmd" \
M-C-h		"setup_shell_cmd $t $f \
			{Help Command: (Press Return to view help)} help_cmd" \
M-C-m		"setup_shell_cmd $t $f {Make Command:} make_cmd" \
M-C-p		"setup_shell_cmd $t $f {Print Command:} print_cmd" \
M-C-w		"setup_wish_cmd $t $f" \
M-C-x		"setup_shell_cmd $t $f {View Selection Command:} browse_cmd"

	if {[winfo exists $m]} {parse_menu $m \
{Command 0
			{"Wish Command" 0 M-C-w}
			{"Shell Command" 2 M-C-e}
		separator
			{Make 0 M-C-m}
			{Print 0 M-C-p}
			{"View X Selection" 5 M-C-x}
			{Help 0 M-C-h}
		separator}

		$m.command.m add checkbutton -label "Get input from text" \
			-underline 4 -variable use_input -offvalue 0 -onvalue 1
		$m.command.m add checkbutton -label "Send output to text" \
			-underline 5 -variable use_output -offvalue 0 -onvalue 1
}}


commandbind $frame $text $menu

after 2000 {flash_label $frame -text "Press Meta-Control-h for help"}
