# Beth example configuration file
# Illustrates some useful configs. To use this, copy it to ~/.beth

# Prevents this file from being configed twice. (This shouldn't happen, but
# due to the myriads of directory names and symlinks, anything's possible)
if {![info exists beth_configed]} {set beth_configed 1


# Set some variables to load the modules in lib.
foreach module [exec ls $beth_dir/lib] {
	if {[string match *.tcl $module]} {
		set module2 [file tail $module]
		set add_[string range $module2 0 [expr [string length \
		    $module2]  - 5]] "source $beth_dir/lib/$module2"
}}

# These are the modules we could add to Beth. Give them menuentries, bindings,
# and set a trace to disable the entries when they're loaded.
set addable_modules {
{{Parentheses Balancing} 12 M-0 $add_balancebind balancebind_loaded}
{{Text Processing} 0 M-C-t $add_textbind textbind_loaded}
}

proc disable_menuentries {m entry args} {$m entryconfigure $entry -state disabled}
foreach am $addable_modules {eval parse_bindings all [lrange $am 2 3]}
if {[winfo exists $menu]} {
	parse_menuentries $menu.extras.m {{"Add Module" 0 ""}}
	foreach am $addable_modules {
		trace variable [lindex $am 4] w "disable_menuentries \
			$menu.extras.m.add [list [lindex $am 0]]"
		parse_menuentries $menu.extras.m.add [list [lrange $am 0 2]]}}


# Beth uses some tags for things like search...here are some configs to
# play with them.

# Several tags are used in the text widget to mark text, but no visible changes
# are provided with those tags...these are best determined by the user.

# This tag graces any text that is currently being examined by search.
$text tag configure search -background gold

# This tag graces any text that was examined by the current search.
$text tag configure was_search -background gold4

# This tag graces any text that was replaced by the current search/replace.
$text tag configure was_replaced -background gold4

# This tag graces any open paren/bracket/brace whenever its closing partner
# is entered, according to balancebind.tcl
$text tag configure balance -background magenta

# $frame.fpl contains the file path, which is set to the current directory.
# The following command 'toggles' the label, so the file path is hidden, you
# can reveal it again by clicking mousebutton 1 on it. This saves space
# in the $frame widget.
catch {label_expand_toggle $frame.fpl fsBox(path)}


# When should balancebind.tcl be loaded? The following command loads it
# for every Beth instance.
set balance_list {{\( \) parenright} {\[ \] bracketright} {\{ \} braceright}}
eval $add_balancebind

# When should textbind.tcl be loaded?
# The following code loads textbind.tcl iff the option is a file: *.txt
if {(![string match \|* $option]) && ([file extension $option] == ".txt")} {
	eval $add_textbind
}

# Which file prompter should be used?
# Defaults to Beth's own, to use Sven Delmas's FSBox code, remove the leading
# #'s from the following lines, and give the appropriate pathnamne for FSBox.
#if $edit_flag {
# 	set path $fsBox(path);	set name $fsBox(name)
# 	source FSBox.tcl
# 	set fsBox(path) $path;	set fsBox(name) $name
# 	set file_prompter FSBox
#}
}
