/* 
 * tkSippAppInit.c --
 *
 *  Tk-SIPP initialization and main.
 *
 *-----------------------------------------------------------------------------
 * Copyright 1992-1995 Mark Diekhans
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies.  Mark Diekhans makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *-----------------------------------------------------------------------------
 * $Id: tkSippAppInit.c,v 5.8 1996/10/26 19:00:05 markd Exp $
 *-----------------------------------------------------------------------------
 */

#include "../tsipp/tSippInt.h"
#include "tk.h"

/*
 * The following variable is a special hack that insures the tcl
 * version of matherr() is used when linking against shared libraries
 */
EXTERN int matherr _ANSI_ARGS_((struct exception *));
int *tclDummyMathPtr = (int *) matherr;


/*=============================================================================
 * Tcl_AppInit --
 *
 *   Tk SIPP aplication initialization. 
 *-----------------------------------------------------------------------------
 */
int
Tcl_AppInit(interp)
    Tcl_Interp *interp;
{
    if (Tcl_Init(interp) == TCL_ERROR)
	return TCL_ERROR;

    if (Tclx_Init(interp) == TCL_ERROR)
	return TCL_ERROR;
    Tcl_StaticPackage (interp, "Tclx", Tclx_Init, Tclx_SafeInit);

    if (Tk_Init(interp) == TCL_ERROR)
        return TCL_ERROR;
    Tcl_StaticPackage(interp, "Tk", Tk_Init, (Tcl_PackageInitProc *) NULL);

    if (Tkx_Init(interp) == TCL_ERROR)
        return TCL_ERROR;
    Tcl_StaticPackage(interp, "Tkx", Tkx_Init, (Tcl_PackageInitProc *) NULL);

    /*
     * Initialize SIPP, and the TSIPP & TKSIPP commands.
     */
    if (Tsipp_Init (interp) == TCL_ERROR)
        return TCL_ERROR;
    if (Tksipp_Init (interp) == TCL_ERROR)
        return TCL_ERROR;

    /*
     * Specify a startup file.
     */
    Tcl_SetVar(interp, "tcl_rcFileName", "~/.tsipprc", TCL_GLOBAL_ONLY);
    return TCL_OK;
}


/*=============================================================================
 * main --
 *
 *   Main program entry point.
 *
 *-----------------------------------------------------------------------------
 */
int
main (argc, argv)
    int    argc;
    char **argv;
{
    TkX_Main (argc, argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}
