# Auswahl- und Ausfhrungs-Men fr "Sonstige Programme"
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc so  {} {


global  vv hlp_dir dateiliste
global  utcmd uttext utoptions ut_file utback utbackup ut_filesel sosep


toplevel .so
wm title .so "$vv(sovor)"
wm minsize .so 0 0


set tyh 18
set dir [pwd]

set utcmd      ""
set uttext     ""
set utoptions  ""
set utbackup   "1"
set ut_file    ""
set ut_filesel ""
set utback     ""


# Bereich a fuer erste Buttons

frame .so.a
pack configure .so.a -in .so -pady 10 -anchor w -fill x
 
frame .so.a.1 -relief raised -borderwidth 1
frame .so.a.2 -relief raised -borderwidth 1
 
pack configure .so.a.1 -in .so.a -side left -anchor w
pack configure .so.a.2 -in .so.a -side right -anchor e -padx 30

button .so.a.1.e -text "$vv(ae)"
bind   .so.a.1.e <Button-3>   {+ cat_file0 "${hlp_dir}z_vstquit.hlp" .so.d.tt}

button .so.a.1.h -text "$vv(ah)" 
bind   .so.a.1.h <Any-Button> {+ cat_file0 "${hlp_dir}so_h.hlp" .so.d.tt}

button .so.a.1.l -text "$vv(al)" -command {clearscr .so.d.tt}
bind   .so.a.1.l <Button-3>   {+ cat_file0 "${hlp_dir}z_loeschetf.hlp" .so.d.tt}

pack configure .so.a.1.e .so.a.1.h .so.a.1.l -in .so.a.1 -side left -padx 3 -pady 3

button .so.a.2.e -text "$vv(soa2e)" -command {
  .so.a.2.e configure -state disabled
  update idletasks
  set ut_file "$ut_filesel"
  writescr0 .so.d.tt "\n" 
  if { $utcmd == "" } {writescr .so.d.tt "***** $vv(so1)\n\n"; bell}
  if { $ut_file == "" }  {writescr .so.d.tt "***** $vv(so2)\n\n"; bell}
  if { ($utcmd != "") &&  ($ut_file != "") } {
    utility .so.d.tt austext; writescr .so.d.tt "$austext"
    set utcmd ""; set utback ""; set uttext ""; set utoptions ""
    .so.b.ko configure -text "$vv(sobko)  $utcmd$utback  $uttext"
    set ut_filesel ""
    .so.b.fi configure -text "$vv(sobfi)  $ut_filesel"
    set utbackup "1"
    .so.b.ba.2 configure -text "$vv(sobba2)"
  }
  .so.a.2.e configure -state normal
  update idletasks
}
bind   .so.a.2.e <Button-3>   {+ cat_file0 "${hlp_dir}so_exec.hlp" .so.d.tt}
pack configure .so.a.2.e -in .so.a.2 -side left


# Bereich b fuer Anzeigen Einstellungen

frame .so.b
pack configure .so.b -in .so -pady 3 -anchor w

label .so.b.ko -text "$vv(sobko)  $utcmd$utback  $uttext" \
               -width 90 -anchor w
bind  .so.b.ko <Button-3> {+ cat_file0 "${hlp_dir}so_utcmd.hlp" .so.d.tt}
label .so.b.fi -text "$vv(sobfi)  $ut_filesel" -width 90 -anchor w
bind  .so.b.fi <Button-3> {+ cat_file0 "${hlp_dir}so_datei.hlp" .so.d.tt}
frame .so.b.ba
pack configure .so.b.ko .so.b.fi .so.b.ba -in .so.b -anchor w

label  .so.b.ba.1 -text "$vv(sobba1)" -anchor w -padx 1
bind   .so.b.ba.1 <Button-3> {+ cat_file0 "${hlp_dir}so_back.hlp" .so.d.tt}
button .so.b.ba.2 -text "$vv(sobba2)" -width 7 -command {
  if { $utbackup == "0" } {
    set utbackup "1"
    .so.b.ba.2 configure -text "$vv(sobba2)"
    writescr0 .so.d.tt ""
  } else {
    set utbackup "0"
    .so.b.ba.2 configure -text "$vv(sobba22)"
    writescr0 .so.d.tt ""
  }  
}
bind   .so.b.ba.2 <Button-3> {+ cat_file0 "${hlp_dir}so_back.hlp" .so.d.tt}
label  .so.b.ba.3 -text "$vv(sobba3)" -anchor w 
bind   .so.b.ba.3 <Button-3> {+ cat_file0 "${hlp_dir}so_back.hlp" .so.d.tt}
pack configure .so.b.ba.1 .so.b.ba.2 .so.b.ba.3 -in .so.b.ba -side left


# Bereich c fuer Wechsel   

frame .so.c
pack configure .so.c -in .so -anchor w

# Bereich c.1 fuer Programmauswahl     

frame .so.c.1 
pack configure .so.c.1  -in .so.c -side left -anchor n

label .so.c.1.fl -text "$vv(soc1fl)" -anchor w 
bind  .so.c.1.fl <Button-3> {+ cat_file0 "${hlp_dir}so_komsel.hlp" .so.d.tt}
pack configure .so.c.1.fl -in .so.c.1 -anchor w

frame .so.c.1.fr -relief raised -borderwidth 2 
pack configure .so.c.1.fr -in .so.c.1 -anchor w

scrollbar .so.c.1.fr.sb -command ".so.c.1.fr.li yview"
listbox   .so.c.1.fr.li -yscroll ".so.c.1.fr.sb set" -geometry 50x12
set sosep [fillboxsep   .so.c.1.fr.li utility.vst]
bind      .so.c.1.fr.li <Triple-Button-1> { }
bind      .so.c.1.fr.li <Double-Button-1> {
  global sosep
  foreach i [selection get] {set ii $i}
  set uttext     [getvalue $ii 0 $sosep]
  set utcmd   [getvalue $ii 1 $sosep]
  set utoptions [getvalue $ii 2 $sosep]
  progback  utcmd  utback
  .so.b.ko configure -text "$vv(sobko)  $utcmd$utback  $uttext"
  writescr0 .so.d.tt "$vv(so3)  $utcmd$utback  $uttext"
}
bind     .so.c.1.fr.sb <Button-3> {+ cat_file0 "${hlp_dir}so_komsel.hlp" .so.d.tt}
bind     .so.c.1.fr.li <Button-3> {+ cat_file0 "${hlp_dir}so_komsel.hlp" .so.d.tt}
pack configure .so.c.1.fr.sb .so.c.1.fr.li -in .so.c.1.fr -side right -fill y

# Bereich c.2 fuer Dateiauswahl    

frame .so.c.2
pack configure .so.c.2  -in .so.c -side left -anchor n

label .so.c.2.1 -text "$vv(soc21)"
pack configure .so.c.2.1  -in .so.c.2

frame .so.c.2.2   
pack configure .so.c.2.2  -in .so.c.2

listbox .so.c.2.2.1 -relief raised -geometry 6x10
        .so.c.2.2.1 insert end "*"
fillbox .so.c.2.2.1 texsuffix.vst
frame .so.c.2.2.2 -relief raised -borderwidth 2    
pack configure .so.c.2.2.1 .so.c.2.2.2 -in .so.c.2.2 -side left -anchor n

scrollbar .so.c.2.2.2.sb -command ".so.c.2.2.2.li yview"
listbox .so.c.2.2.2.li -yscroll ".so.c.2.2.2.sb set" -geometry 20x12
pack configure .so.c.2.2.2.sb .so.c.2.2.2.li -in .so.c.2.2.2 -side right -fill y

# List-Box fuellen
set dateiliste [lsort [glob -nocomplain -- *]]
foreach i $dateiliste {
  if { [file isfile $i] && [string match "*.tex" $i] } {
    .so.c.2.2.2.li insert end $i 
  }
}

#bind 
bind .so.c.2.1 <Button-3> {+ cat_file0 "${hlp_dir}so_filesel.hlp" .so.d.tt}

bind .so.c.2.2.1 <Triple-Button-1> { }
bind .so.c.2.2.1 <Double-Button-1> {
  foreach i [selection get] {set kosuff $i}
  writescr0 .so.d.tt "$vv(so4)  $kosuff"
  set ut_filesel ""
  .so.b.fi configure -text "$vv(sobfi)  $ut_filesel" 
  .so.c.2.2.2.li delete 0 end
  foreach ii $dateiliste {
    if { [file isfile $ii] && [string match "*$kosuff" $ii] } {
      .so.c.2.2.2.li insert end $ii 
    }
  }
  set utbackup 1
  .so.b.ba.2 configure -text "$vv(sobba2)"
}
bind .so.c.2.2.1 <Button-3> {+ cat_file0 "${hlp_dir}so_suffsel.hlp" .so.d.tt}

bind .so.c.2.2.2.li <Triple-Button-1> { }
bind .so.c.2.2.2.li <Double-Button-1> {
  set ut_filesel ""
  set ii [catch {selection get} i]
  if { $ii == 0 } {
    set ut_filesel $i
    writescr0 .so.d.tt "$vv(so5)  $ut_filesel"
  }
  .so.b.fi configure -text "$vv(sobfi)  $ut_filesel" 
}
bind .so.c.2.2.2.sb <Button-3> {+ cat_file0 "${hlp_dir}so_filesel.hlp" .so.d.tt}
bind .so.c.2.2.2.li <Button-3> {+ cat_file0 "${hlp_dir}so_filesel.hlp" .so.d.tt}


# Bereich d fuer Hilfe-Ausgaben

frame .so.d -relief raised -borderwidth 2
pack configure .so.d -in .so -anchor sw -pady 6

scrollbar .so.d.sb -command ".so.d.tt yview"
bind      .so.d.sb <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .so.d.tt}
text      .so.d.tt -yscroll ".so.d.sb set" -height $tyh
          .so.d.tt tag configure err
          .so.d.tt tag configure end -relief raised -borderwidth 1 -background white
bind      .so.d.tt <Button-3> {+ cat_file0 "${hlp_dir}z_textfeld.hlp" .so.d.tt}
pack configure .so.d.sb .so.d.tt -in .so.d -side right -fill y
.so.d.tt configure -state disabled
 
}
