# Voreinstellungsmen fr Editor   
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen

proc evanzeigen {s1} {
  global vv edtext editor edback edxterm edoptions esuffl efile esuff
  writescr0 .ev.d.tt "$s1\n\n" "$edtext\n" \
                     " $vv(ev2) $editor$edback\n" \
                     " $vv(ev1) $edxterm\n" \
                     " $vv(ev3) $edoptions\n" \
                     " $vv(ev4) $esuffl\n" \
                     [alternative $efile \
                       " $vv(bad1)\n" \
                       " $vv(bad2) $efile$esuff\n\n"]
}


proc evanzeige {} {
  global vv efile esuff
  if {$efile == ""} {set t "$vv(bad1)"} else {set t "$vv(bad2) $efile$esuff"}
 .ev.b.ad configure -text "$t"
}


proc ev  {} {

global  vv hlp_dir edatsort
global  efile dir editor edback edtext edxterm edoptions esuff esuffl evsep

toplevel .ev
wm title .ev "$vv(evvor)"
wm minsize .ev 0 0


set tyh 17
set dir [pwd]

if {$esuff=="*"||$esuff==""} {set esuff ""; set esuffl "*"} else {set esuffl $esuff}

proc efuellen {} {
  global  esuff edatsort sub

  set subalt $sub
  .ev.c.2.a.fr.li delete 0 end
  if { $edatsort == "0" } {set liste [exec ls]} else {set liste [exec ls -t]}
  foreach i $liste {
    if [file isfile $i] {
      if { $esuff == "" || [string match "*$esuff" $i]} {
        .ev.c.2.a.fr.li insert end $i
      }
    }
  }
  lock
  set sub $subalt
}

# Bereich a fuer erste Buttons

frame .ev.a -relief raised -borderwidth 1
pack configure .ev.a -in .ev -pady 10 -anchor w
 
button .ev.a.e -text "$vv(ae)"
bind   .ev.a.e  <Button-3>   {cat_file0 "${hlp_dir}z_vstquit.hlp" .ev.d.tt}
button .ev.a.h -text "$vv(ah)" 
bind   .ev.a.h  <Any-Button> {cat_file0 "${hlp_dir}ev_h.hlp" .ev.d.tt}
button .ev.a.l -text "$vv(al)" -command {clearscr .ev.d.tt}
bind   .ev.a.l  <Button-3>   {cat_file0 "${hlp_dir}z_loeschetf.hlp" .ev.d.tt}
button .ev.a.g -text "$vv(ag)" -command {
  global evsep
  set o $esuff
  set foid [open_vst default.vst]
  while { [getscl $foid ein] > 0 } { 
    mtest $ein 19 editor
    mtest $ein 19 edtext
    mtest $ein 19 esuff
    mtest $ein 19 edxterm
    mtest $ein 19 edoptions
  }
  close $foid
  if {$esuff != $o} {set efile  "";  evanzeige}
  set esuffl $esuff
  if {$esuff == "*"} {set esuff "";   set esuffl "*"}
  efuellen
  .ev.c.2.a.f.l configure -text "$vv(c2al) (*$esuff):"
  .ev.c.2.n.l configure -text "$vv(c2nl) (*$esuff):"
  progback  editor  edback
  evanzeigen "$vv(ausg1)"
}
bind   .ev.a.g  <Button-3>   {cat_file0 "${hlp_dir}ev_grund.hlp" .ev.d.tt}

pack configure .ev.a.e .ev.a.h .ev.a.l .ev.a.g -in .ev.a -side left -padx 3 -pady 3


# Bereich bv fuer eigene Einstellungen

frame .ev.bv
pack configure .ev.bv -in .ev -pady 13 -anchor w

label  .ev.bv.dv -text "$vv(bvdv)" -width 23 -anchor w
bind   .ev.bv.dv <Button-3> {cat_file0 "${hlp_dir}z_voreinst1.hlp" .ev.d.tt}
button .ev.bv.va -text "$vv(bvva)" -command {evanzeigen "$vv(aus0)"}
bind   .ev.bv.va <Button-3> {cat_file0 "${hlp_dir}z_voreinst1.hlp" .ev.d.tt}

pack configure .ev.bv.dv .ev.bv.va -in .ev.bv -side left


# Bereich b fuer Anzeigen   

frame .ev.b
pack configure .ev.b -in .ev -anchor w

label .ev.b.ad -width 60 -anchor w
bind  .ev.b.ad <Button-3> {cat_file0 "${hlp_dir}ev_anzeig.hlp" .ev.d.tt }
label .ev.b.dv -text "$vv(bdv) $dir" -width 70 -anchor w
bind  .ev.b.dv <Button-3> {cat_file0 "${hlp_dir}ev_anzeig.hlp" .ev.d.tt }

pack configure .ev.b.ad .ev.b.dv -in .ev.b -anchor w
evanzeige


# Bereich c fuer Wechsel   

frame .ev.c
pack configure .ev.c -in .ev -anchor w

frame .ev.c.1
frame .ev.c.2
  
pack configure .ev.c.1  -in .ev.c -side left -fill x
pack configure .ev.c.2 -in .ev.c -side right -fill x -ipadx 0


# Bereich c1 (Editor-Liste, Suffix-Liste)

frame .ev.c.1.e
frame .ev.c.1.s

pack configure .ev.c.1.e .ev.c.1.s -in .ev.c.1 -anchor e -pady 12

# Editor-Liste

label .ev.c.1.e.l -text "$vv(evc1el)"
bind  .ev.c.1.e.l <Button-3> {cat_file0 "${hlp_dir}ev_edisel.hlp" .ev.d.tt}
frame .ev.c.1.e.fr -relief raised -borderwidth 2 
pack configure .ev.c.1.e.l .ev.c.1.e.fr -in .ev.c.1.e -side left -anchor w

scrollbar .ev.c.1.e.fr.sb -command ".ev.c.1.e.fr.li yview"
listbox   .ev.c.1.e.fr.li -yscroll ".ev.c.1.e.fr.sb set" -geometry 30x8
set evsep [fillboxsep   .ev.c.1.e.fr.li editor.vst]
bind   .ev.c.1.e.fr.sb <Button-3> {cat_file0 "${hlp_dir}ev_edisel.hlp" .ev.d.tt}
bind   .ev.c.1.e.fr.li <Button-3> {cat_file0 "${hlp_dir}ev_edisel.hlp" .ev.d.tt}
focus     .ev.c.1.e.fr.li
bind      .ev.c.1.e.fr.li <Triple-Button-1> {}
bind      .ev.c.1.e.fr.li <Double-Button-1> {
  foreach i [selection get] {set ii $i}
  set edtext    [getvalue $ii 0 $evsep]
  set edxterm   [getvalue $ii 1 $evsep]
  set editor    [getvalue $ii 2 $evsep]
  set edoptions [getvalue $ii 3 $evsep]
  progback  editor  edback
  evanzeigen "$vv(evt1):"
}
pack configure .ev.c.1.e.fr.sb .ev.c.1.e.fr.li -in .ev.c.1.e.fr -side right -fill y


# Suffix-Liste

label .ev.c.1.s.l -text "$vv(evc1sl)"
bind  .ev.c.1.s.l <Button-3> {cat_file0 "${hlp_dir}ev_suffsel.hlp" .ev.d.tt }
frame .ev.c.1.s.fr -relief raised -borderwidth 2    
pack configure .ev.c.1.s.l .ev.c.1.s.fr -in .ev.c.1.s -side left 

scrollbar .ev.c.1.s.fr.sb -command ".ev.c.1.s.fr.li yview"
bind      .ev.c.1.s.fr.sb <Button-3> {cat_file0 "${hlp_dir}ev_suffsel.hlp" .ev.d.tt}
listbox   .ev.c.1.s.fr.li -yscroll ".ev.c.1.s.fr.sb set" -geometry 30x10
fillbox   .ev.c.1.s.fr.li suffix.vst
bind      .ev.c.1.s.fr.li <Button-3> {cat_file0 "${hlp_dir}ev_suffsel.hlp" .ev.d.tt}
bind      .ev.c.1.s.fr.li <Triple-Button-1> {}
bind      .ev.c.1.s.fr.li <Double-Button-1> {
  .ev.c.2.n.i delete 0 end; 
  set o $esuff
  foreach i [selection get] {set esuff [string trim $i]}
  if {$esuff != $o} {set efile  "";  evanzeige}
  .ev.d.tt insert end "$vv(evt2): $esuff\n"
  set esuffl $esuff
  if {$esuff == "*"} {set esuff "";   set esuffl "*"}
  efuellen
  writescr0 .ev.d.tt "$vv(evt3): *$esuff\n\n" 
  .ev.c.2.a.f.l configure -text "$vv(c2al) (*$esuff):"
  .ev.c.2.n.l configure -text "$vv(c2nl) (*$esuff):"
  selection clear .ev.c.1.s.fr.li
}
pack configure .ev.c.1.s.fr.sb .ev.c.1.s.fr.li -in .ev.c.1.s.fr -side right -fill y


# Bereich c2 (Datei-Auswahl, Neue Datei)

frame .ev.c.2.a
frame .ev.c.2.n
pack configure .ev.c.2.a .ev.c.2.n -in .ev.c.2 -anchor e -pady 5

# Datei-Auswahl-Liste (Datei-Selektion)

frame .ev.c.2.a.f
frame .ev.c.2.a.fr -relief raised -borderwidth 2 
pack configure .ev.c.2.a.f .ev.c.2.a.fr -in .ev.c.2.a -side left -padx 2

label .ev.c.2.a.f.l  -text "$vv(c2al) (*$esuff):" -anchor c -width 18
radiobutton .ev.c.2.a.f.t -text "$vv(c2aft)" -variable edatsort -value "0" \
                          -width 12 -anchor w -command {
  efuellen
}
radiobutton .ev.c.2.a.f.tt -text "$vv(c2aftt)" -variable edatsort -value "1" \
                           -width 12 -anchor w -command {
  efuellen
}


pack configure .ev.c.2.a.f.l .ev.c.2.a.f.t .ev.c.2.a.f.tt -in .ev.c.2.a.f -anchor c

bind  .ev.c.2.a.f.l <Button-3> {cat_file0 "${hlp_dir}ev_filesel.hlp" .ev.d.tt}
bind  .ev.c.2.a.f.t <Button-3> {cat_file0 "${hlp_dir}ev_filesel.hlp" .ev.d.tt}
bind  .ev.c.2.a.f.tt <Button-3> {cat_file0 "${hlp_dir}ev_filesel.hlp" .ev.d.tt}

scrollbar .ev.c.2.a.fr.sb -command ".ev.c.2.a.fr.li yview"
listbox   .ev.c.2.a.fr.li -yscroll ".ev.c.2.a.fr.sb set" -geometry 20x17
bind  .ev.c.2.a.fr.sb <Button-3> {cat_file0 "${hlp_dir}ev_filesel.hlp" .ev.d.tt}
bind  .ev.c.2.a.fr.li <Button-3> {cat_file0 "${hlp_dir}ev_filesel.hlp" .ev.d.tt}
pack configure .ev.c.2.a.fr.sb .ev.c.2.a.fr.li -in .ev.c.2.a.fr -side right -fill y

efuellen

# bind fuer Datei-Selektion
focus .ev.c.2.a.fr.li
bind  .ev.c.2.a.fr.li <Triple-Button-1> { }
bind  .ev.c.2.a.fr.li <Double-Button-1> {
  foreach ii [catch {selection get} i] {
    if { $ii == 0 } {
      .ev.c.2.n.i delete 0 end
      if {$esuff == ""} {set efile $i} else {regsub "$esuff\$" $i "" efile}
      evanzeige
      writescr0 .ev.d.tt "$vv(aus2) $efile$esuff\n\n" 
    }
  }
  selection clear .ev.c.2.a.fr.li
}

# Eingabe eines neuen Dateinamens

label .ev.c.2.n.l -text "$vv(c2nl) (*$esuff):" -anchor e -width 18
bind  .ev.c.2.n.l  <Button-3> {cat_file0 "${hlp_dir}ev_fileedi.hlp" .ev.d.tt}

entry .ev.c.2.n.i -width 22 -relief sunken
bind  .ev.c.2.n.i <Button-3> {cat_file0 "${hlp_dir}ev_fileedi.hlp" .ev.d.tt}
.ev.c.2.n.i icursor 0

pack configure .ev.c.2.n.l .ev.c.2.n.i -in .ev.c.2.n -side left

focus none
bind .ev.c.2.n.i <Return> {
  set datvar [string trim [.ev.c.2.n.i get]]
  regsub "${esuff}$" $datvar "" hvar
  if { "$hvar$esuff" == "$datvar"} {set datvar "$hvar"}
  set efile [string trim $datvar]
  writescr0 .ev.d.tt "$vv(aus3): $efile$esuff\n\n" 
  testfilename $efile .ev.d.tt $esuff
  evanzeige
  set datvar ""
  .ev.c.2.n.i configure -textvariable datvar
  .ev.c.2.n.i icursor 0
  focus none
}
bind .ev.c.2.n.i <Button-2> {
  writescr0 .ev.d.tt "$vv(aus1)  $efile$esuff\n"
  .ev.c.2.n.i delete 0 end; 
  if { $efile == "" } {
    .ev.c.2.n.i insert end $efile
  } else {
    .ev.c.2.n.i insert end $efile$esuff
  }
  focus none
}


# Bereich d fuer Hilfe-Ausgaben

frame .ev.d -relief raised -borderwidth 2
pack configure .ev.d -in .ev -anchor sw -pady 6

scrollbar .ev.d.sb -command ".ev.d.tt yview"
bind      .ev.d.sb <Button-3> {cat_file0 "${hlp_dir}z_textfeld.hlp" .ev.d.tt}
text      .ev.d.tt -yscroll ".ev.d.sb set" -height $tyh
bind      .ev.d.tt <Button-3> {cat_file0 "${hlp_dir}z_textfeld.hlp" .ev.d.tt}
pack configure .ev.d.sb .ev.d.tt -in .ev.d -side right -fill y
.ev.d.tt configure -state disabled
 
}
