#!/usr/local/bin/wish -f
#
# TERM WINDOW
#


proc xTerm {} {

    global inputFile \
	    ppp \
	    exit_now \
	    rows \
	    cols \
	    term \
	    term_standout \
	    console_open


    set term .cTerm.bframe.txt
    set exit_now 0
    set rows 20
    set cols 70
    set term_standout 0



    #
    # Set up high level window functions
    #
    catch {destroy .cTerm}
    toplevel .cTerm
    wm geometry .cTerm +300+300
    wm title .cTerm "TERMINAL"
    wm iconname .cTerm "TERM"


    #
    # Create top and botton slave widgets
    #
    message .cTerm.msg  \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -aspect 1000 -relief raised -bd 2 \
	    -text "This TERMINAL window shows \"raw\" data packets, for readability packet is trimmed to screen width. Click \"CLS\" to clear screen"


    frame .cTerm.bframe -relief raised -bd 2

    button .cTerm.quit -text "QUIT" -command {
	# Console window is closed, can't accept text
	set console_open 0
	destroy .cTerm
    }


    button .cTerm.cls -text "CLS" -command "term_clear"
    pack .cTerm.msg -side top -fill both
    pack .cTerm.bframe -side top -fill both -expand yes
    pack .cTerm.quit .cTerm.cls -side left -expand yes -fill both -pady 5


    #
    # Create canvas located in the middle
    #
    text .cTerm.bframe.txt \
	    -width $cols -height $rows -relief raised -bd 2

    pack .cTerm.bframe.txt -in .cTerm.bframe -expand yes -fill both

    # Initialize console window
    term_init

    # Console window is open to accept text
    set console_open 1
}






#
# Initialize display, fill rows and columns with blanks, "mark" insertion point
#
proc term_init {} {

    global rows cols \
	    term \
	    cur_row \
	    cur_col

    set blankline [format %*s $cols ""]\n

    for {set i 1} {$i <= $rows} {incr i 1} {
	$term insert $i.0 $blankline
    }

    set cur_row 1
    set cur_col 0

    $term mark set insert $cur_row.$cur_col
}





#
# Clear Screen, delete all characters and then call initialize screen
#
proc term_clear {} {

    global term

    $term  delete 1.0 end
    term_init
}






#
# Move cursor down one line, if at bottom, scroll up.
# Do by deleting first line, then creating a new one at the end.
#
proc term_down {} {

    global cur_row \
	    rows cols \
	    term

	if {$cur_row < $rows} {
	    incr cur_row

	} else {
	    # at last line scroll up & recreate line at end
	    $term delete 1.0 "1.end + 1 chars"
	    $term insert end [format %*s $cols ""]\n
	}
    }




#
# Insert write a string to the current location on the screen.
#
proc term_insert {s} {

    global cols \
	    cur_col \
	    cur_row \
	    term \
	    term_standout


    # Force all packets to size of screen, delete or append as necessary
    set s_len [string length $s]

    if {$s_len > $cols} {
	set s [string range $s 0 [expr $cols - 1]]

    } else {

	set s [append s [format %*s [expr $cols - $s_len] ""]]
    }



    set chars_rem_to_write [string length $s]
    set space_rem_on_line [expr $cols - $cur_col]
    
    if {$term_standout} {
	set tag_action "add"

    } else {

	set tag_action "remove"
    }



    # write the first line
    if {$chars_rem_to_write > $space_rem_on_line} {
	set chars_to_write $space_rem_on_line
	set newline 1

    } else {

	set chars_to_write $chars_rem_to_write
	set newline 0
    }


    $term delete $cur_row.$cur_col \
	    $cur_row.[expr $cur_col + $chars_to_write]

    $term insert $cur_row.$cur_col \
	    [string range $s 0 [expr $space_rem_on_line-1]]

    $term tag $tag_action standout $cur_row.$cur_col \
	    $cur_row.[expr $cur_col + $chars_to_write]

    # discard first line alread written
    incr chars_rem_to_write -$chars_to_write
    set s [string range $s $chars_to_write end]
    
    incr cur_col $chars_to_write			;# update cur_col
    if $newline {term_down}				;# update cur_row

    # Write full lines
    while {$chars_rem_to_write >= $cols} {
	$term delete $cur_row.0 $cur_row.end
	$term insert $cur_row.0 [string range $s 0 [expr $cols-1]]
	$term tag $tag_action standout $cur_row.0 $cur_row.end
	
	set s [string range $s $cols end]	;# discard line from buffer
	incr chars_rem_to_write -$cols

	set cur_col 0
	term_down
    }

    # Write last line
    if {$chars_rem_to_write} {
	$term delete $cur_row.0 $cur_row.$chars_rem_to_write
	$term insert $cur_row.0 $s
	$term tag $tag_action standout $cur_row.0 \
		$cur_row.$chars_rem_to_write
	set cur_col $chars_rem_to_write
    }
}




#
# To update the visible cursor
#
proc term_update_cursor {} {

    global cur_row \
	    cur_col \
	    term

    $term mark set insert $cur_row.$cur_col
}

	









