#!/usr/local/bin/wish -f
#
# PREFS WINDOW
#
# This procedure allows the user to configure the serial port.
#

proc xPrefs {} {

    global input_port \
	    serial_port \
	    baud \
	    stopbits \
	    framesize \
	    parity \
	    rbaud \
	    hrd_to \
	    uhrd_to \
	    con_to \
	    xNet_stopped

    set input_port dumm
    set serial_port dumf
    set title_f -Adobe-helvetica-bold-r-normal--*-120*
    set title_c brown
    set lab_font -Adobe-helvetica-medium-r-normal--*-120*


    catch {destroy .cPref}
    toplevel .cPref
    wm geometry .cPref +500+300
    wm title .cPref "PREFERENCES"
    wm iconname .cPref "PREFS"

    message .cPref.msg \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -aspect 500 \
	    -text "Set miscellaneous preferences here. To exit without making changes select \"Cancel\". To save settings, select \"SAVE\"."



    frame .cPref.frame -relief flat
    frame .cPref.frame.rbaud -relief raised -bd 2
    frame .cPref.frame.hto -relief raised -bd 2
    frame .cPref.frame.uto -relief raised -bd 2
    frame .cPref.frame.cto -relief raised -bd 2
    frame .cPref.botframe
    
    pack .cPref.msg -side top
    pack .cPref.frame -side top -fill x -expand yes -pady 2
    pack .cPref.botframe -side bottom -fill x
    pack .cPref.frame.rbaud .cPref.frame.hto \
	    .cPref.frame.uto   .cPref.frame.cto \
	    -side left -expand yes -fill both



    #
    # Select Radio Baud Rate, for utilization graph only.
    #
    label .cPref.frame.rbaud.lab \
	    -text "Radio Baud Rate" -fg $title_c -font $title_f

    radiobutton .cPref.frame.rbaud.300 \
	    -text " 300 bps" \
	    -font $lab_font -variable rbaud -relief flat -value 300
    
    radiobutton .cPref.frame.rbaud.1200 \
	    -text "1200 bps" \
	    -font $lab_font -variable rbaud -relief flat -value 1200
    
    radiobutton .cPref.frame.rbaud.2400 \
	    -text "2400 bps" \
	    -font $lab_font -variable rbaud -relief flat -value 2400
    
    radiobutton .cPref.frame.rbaud.9600 \
	    -text "9600 bps" \
	    -font $lab_font -variable rbaud -relief flat -value 9600
    
    radiobutton .cPref.frame.rbaud.19200 \
	    -text "19200 bps" \
	    -font $lab_font -variable rbaud -relief flat -value 19200
    
    pack .cPref.frame.rbaud.lab .cPref.frame.rbaud.300 \
	    .cPref.frame.rbaud.1200 .cPref.frame.rbaud.2400 \
	    .cPref.frame.rbaud.9600 .cPref.frame.rbaud.19200 \
	    -side top -pady 2 -anchor nw


    #
    # Select heard station time out
    #
    label .cPref.frame.hto.lab \
	    -text "Hrd Sta TO" -fg $title_c -font $title_f

    radiobutton .cPref.frame.hto.30 \
	    -text "30 secs" \
	    -font $lab_font -variable hrd_to -relief flat -value 30
    
    radiobutton .cPref.frame.hto.1 \
	    -text " 1 mins" \
	    -font $lab_font -variable hrd_to -relief flat -value 60
    
    radiobutton .cPref.frame.hto.5 \
	    -text " 5 mins" \
	    -font $lab_font -variable hrd_to -relief flat -value 300
    
    radiobutton .cPref.frame.hto.10 \
	    -text "10 mins" \
	    -font $lab_font -variable hrd_to -relief flat -value 600
    
    radiobutton .cPref.frame.hto.20 \
	    -text "20 mins" \
	    -font $lab_font -variable hrd_to -relief flat -value 1200
    
    radiobutton .cPref.frame.hto.60 \
	    -text "60 mins" \
	    -font $lab_font -variable hrd_to -relief flat -value 3600
    
    pack .cPref.frame.hto.lab .cPref.frame.hto.30 .cPref.frame.hto.1 \
	    .cPref.frame.hto.5 .cPref.frame.hto.10 \
	    .cPref.frame.hto.20 .cPref.frame.hto.60 \
	    -side top -pady 2 -anchor nw


    #
    # Select unheard station time out
    #
    label .cPref.frame.uto.lab \
	    -text "Uhrd Sta TO" -fg $title_c -font $title_f

    radiobutton .cPref.frame.uto.30 \
	    -text "30 secs" \
	    -font $lab_font -variable uhrd_to -relief flat -value 30
    
    radiobutton .cPref.frame.uto.1 \
	    -text " 1 mins" \
	    -font $lab_font -variable uhrd_to -relief flat -value 60
    
    radiobutton .cPref.frame.uto.5 \
	    -text " 5 mins" \
	    -font $lab_font -variable uhrd_to -relief flat -value 300
    
    radiobutton .cPref.frame.uto.10 \
	    -text "10 mins" \
	    -font $lab_font -variable uhrd_to -relief flat -value 600
    
    radiobutton .cPref.frame.uto.20 \
	    -text "20 mins" \
	    -font $lab_font -variable uhrd_to -relief flat -value 1200
    
    radiobutton .cPref.frame.uto.60 \
	    -text "60 mins" \
	    -font $lab_font -variable uhrd_to -relief flat -value 3600
    
    pack .cPref.frame.uto.lab .cPref.frame.uto.30 .cPref.frame.uto.1 \
	    .cPref.frame.uto.5 .cPref.frame.uto.10 \
	    .cPref.frame.uto.20 .cPref.frame.uto.60 \
	    -side top -pady 2 -anchor nw


    #
    # Connection timeout
    #
    label .cPref.frame.cto.lab -text "Cont TO" -fg $title_c -font $title_f

    radiobutton .cPref.frame.cto.30 \
	    -text "30 secs" \
	    -font $lab_font -variable con_to -relief flat -value 30
    
    radiobutton .cPref.frame.cto.1 \
	    -text " 1 mins" \
	    -font $lab_font -variable con_to -relief flat -value 60
    
    radiobutton .cPref.frame.cto.5 \
	    -text " 5 mins" \
	    -font $lab_font -variable con_to -relief flat -value 300
    
    radiobutton .cPref.frame.cto.10 \
	    -text "10 mins" \
	    -font $lab_font -variable con_to -relief flat -value 600
    
    radiobutton .cPref.frame.cto.20 \
	    -text "20 mins" \
	    -font $lab_font -variable con_to -relief flat -value 1200
    
    radiobutton .cPref.frame.cto.60 \
	    -text "60 mins" \
	    -font $lab_font -variable con_to -relief flat -value 3600
    
    pack .cPref.frame.cto.lab .cPref.frame.cto.30 .cPref.frame.cto.1 \
	    .cPref.frame.cto.5 .cPref.frame.cto.10 \
	    .cPref.frame.cto.20 .cPref.frame.cto.60 \
	    -side top -pady 2 -anchor nw

    
    #
    # SAVE new Preferences to file and exit.
    #
    button .cPref.botframe.save -text "SAVE" -width 12 -command {
	set fp [open prefs w]
	puts $fp $input_port
	puts $fp $serial_port
	puts $fp $baud
	puts $fp $stopbits
	puts $fp $framesize
	puts $fp $parity
	puts $fp $rbaud
	puts $fp $hrd_to
	puts $fp $uhrd_to
	puts $fp $con_to
	close $fp
	if {! $xNet_stopped} {attn_pref_dialog}
	destroy .cPref
    }



    #
    # CANCEL Exit
    #
    button .cPref.botframe.can -text "CANCEL" -width 12 -command {
	destroy .cPref
    }

    pack .cPref.botframe.can .cPref.botframe.save \
	    -side left -fill x -expand yes -pady 2



    #
    # GET PREFERENCES
    #
    set pf [open prefs r]
    gets $pf input_port
    gets $pf serial_port
    gets $pf baud
    gets $pf stopbits
    gets $pf framesize
    gets $pf parity
    gets $pf rbaud
    gets $pf hto
    gets $pf uto
    gets $pf cto
    close $pf

    switch $rbaud {
	300 {.cPref.frame.rbaud.300 invoke}
	1200 {.cPref.frame.rbaud.1200 invoke}
	2400 {.cPref.frame.rbaud.2400 invoke}
	9600 {.cPref.frame.rbaud.9600 invoke}
	19200 {.cPref.frame.rbaud.19200 invoke}
    }


    switch $hto {
	0    {.cPref.frame.hto.0 invoke}
	60   {.cPref.frame.hto.1 invoke}
	300  {.cPref.frame.hto.5 invoke}
	600  {.cPref.frame.hto.10 invoke}
	1200 {.cPref.frame.hto.20 invoke}
	3600 {.cPref.frame.hto.60 invoke}
    }


    switch $uto {
	0    {.cPref.frame.uto.0 invoke}
	60   {.cPref.frame.uto.1 invoke}
	300  {.cPref.frame.uto.5 invoke}
	600  {.cPref.frame.uto.10 invoke}
	1200 {.cPref.frame.uto.20 invoke}
	3600 {.cPref.frame.uto.60 invoke}
    }


    switch $cto {
	0    {.cPref.frame.cto.0 invoke}
	60   {.cPref.frame.cto.1 invoke}
	300  {.cPref.frame.cto.5 invoke}
	600  {.cPref.frame.cto.10 invoke}
	1200 {.cPref.frame.cto.20 invoke}
	3600 {.cPref.frame.cto.60 invoke}
    }


}


proc attn_pref_dialog {} {

    toplevel .attn
    wm title .attn "ATTENTION"

    message .attn.msg \
	    -font -Adobe-helvetica-bold-r-normal--*-140* \
	    -width 2i -justify center -fg brown\
	    -text "\n ATTENTION \n \n Saved changes effective on next update."

    frame .attn.frame -relief raised -bd 2
    label .attn.bmap -bitmap info -fg blue
    button .attn.ok -text "OK" -command {destroy .attn}


    pack .attn.msg -side top -anchor center
    pack .attn.bmap -side top -pady .25i
    pack .attn.ok -side left -expand yes -fill both


    # Wait for user to acknowledge warning dialog
    tkwait visibility .attn
    grab set -global .attn
    tkwait window .attn
    grab release .attn


}