proc xgpl_FitWindow { } {
  global Xgpl gpl_line gpl_fitfile gpl_fitres

#
# Procedure to implement a window for interfacing to the fitting
# program linfit.  This version assumes linfit is in the current path.
#

# create a new top-level window
  set w .xgpfit
  catch {destroy $w}
  toplevel $w
  wm title $w "Linear Fitting"
  wm iconname $w "Linear Fitting"

# create a bar of commands for this window
  pack [frame $w.bar -relief flat] -side top -fill x -padx 2 -pady 2
   pack [button $w.bar.dismiss -text Dismiss -command "destroy $w" \
         -width 8 -relief raised -borderwidth 1] -side left -anchor w
   pack [button $w.bar.fit -text Fit -command "xgpl_doFit" \
         -width 8 -relief raised -borderwidth 1] -side left -anchor w

# create a place to enter the filename
  pack [frame $w.file -relief groove -borderwidth 2] \
        -side top -fill x -padx 2 -pady 4
   pack [label $w.file.l -text File: -width 8 -anchor w] \
        -side left -anchor w
   pack [entry $w.file.e -width 20 -relief sunken -textvariable gpl_fitfile] \
        -side left -anchor w -expand 1 -fill x

# add a label to display results
  pack [frame $w.res -relief groove -borderwidth 2] \
        -side top -fill x -padx 2 -pady 4
   pack [label $w.res.l -text Fit: -width 8 -anchor w] \
        -side left -anchor w
   pack [entry $w.res.e -width 20 -relief flat -textvariable gpl_fitres] \
        -side left -anchor w -expand 1 -fill x
}

proc xgpl_doFit { } {
  global Xgpl gpl_line gpl_fitfile gpl_fitres
  if {[string length $gpl_fitfile] && [file isreadable $gpl_fitfile]} then {
    set gpl_fitres [linfit $gpl_fitfile]
    set gpl_line(type,1) function
    set gpl_line(entry,1) $gpl_fitres
    set gpl_line(on,1) 1
    set gpl_line(type,2) file
    set gpl_line(entry,2) $gpl_fitfile
    set gpl_line(on,2) 1
    xgpl_Plot
  }
}
   
proc linfit { file } {

   # check that the supplied file can be read
   if [file isreadable $file] then {
     set results [exec linfit << $file]
   } else {
     tkerror "File $file is not readable by you"
     return {}
   }

   # on successful fitting return the equation of the fitted line
   return "$m * x  + $c"
   
}
