#
# Copyright P. Alexander, MRAO, Cambridge
# All rights reserved.
# Version 1.0 30/04/93
#
# The following procedures are used to implement additional bindings
# not defined in the standard TK bindings.
#

# Entry_bindings :::: set standard bindings for entry widgets
proc Entry_bindings { } {

# key movement 
   bind Entry <Key-Left>  {Entry_MoveCursor %W -1}
   bind Entry <Key-Right> {Entry_MoveCursor %W 1}

# standard selection handling
   bind Entry <Control-v> {catch {%W insert insert [selection get]} 
                           tk_entrySeeCaret %W }
   bind Entry <Control-d> {catch {%W delete sel.first sel.last}
                           tk_entrySeeCaret %W}

# alternative selection handling
   bind Entry <Control-1> {catch {%W insert insert [selection get]} 
                           tk_entrySeeCaret %W }
   bind Entry <Control-w> {catch {%W delete sel.first sel.last}
                           tk_entrySeeCaret %W}

}


# Text_bindings :::: set standard bindings for text widgets
proc Text_bindings { } {

# button bindings
  bind Text <1>         {Text_InsertCursor %W @%x,%y}
  bind Text <2>         {%W scan mark %y}
  bind Text <3>         {Text_ResetAnchor %W @%x,%y
                         Text_SelectTo %W @%x,%y   }

  bind Text <B1-Motion> {Text_SelectTo %W @%x,%y}
  bind Text <B2-Motion> {%W scan dragto %y}

  bind Text <Shift-1>   {Text_ResetAnchor %W @%x,%y
                         Text_SelectTo %W @%x,%y   }
  bind Text <Shift-B1-Motion> {
                         Text_SelectTo %W @%x,%y}


  bind Text <Double-1>  {Text_SelectWord %W @%x,%y}
  bind Text <Triple-1>  {Text_SelectLine %W @%x,%y}


# other keyboard actions (non-control keys)
  bind Text <Any-KeyPress>   {Text_InsertChar %W %A}
  bind Text <Return>         {Text_InsertNewline %W}
  bind Text <Delete>         {Text_DeleteChar %W}
  bind Text <BackSpace>      {Text_DeleteChar %W}
  bind Text <Left>           {Text_MoveLeft %W}
  bind Text <Up>             {Text_MoveUp %W}
  bind Text <Right>          {Text_MoveRight %W}
  bind Text <Down>           {Text_MoveDown %W}
  bind Text <Shift-Left>     {Text_MoveStart %W}
  bind Text <Shift-Right>    {Text_MoveEnd %W}
  bind Text <Shift-Up>       {Text_MoveUppage %W}
  bind Text <Shift-Down>     {Text_MoveDownpage %W}
  bind Text <Control-Up>     {Text_MoveTop %W}
  bind Text <Control-Down>   {Text_MoveBottom %W}

# bindings affecting selection
  bind Text <Control-1>      {Text_InsertSelection %W}
  bind Text <Control-v>      {Text_InsertSelection %W}
  bind Text <Control-d>      {Text_DeleteSelection %W}
  bind Text <Control-w>      {Text_DeleteSelection %W}
  bind Text <Control-Delete> {Text_DeleteSelection %W}

}


