# radio.tcl --
#
# This demonstration script creates a toplevel window containing
# several radiobutton widgets.
#
# @(#) radio.tcl 1.2 95/06/15 13:01:37

set w .radio
catch {destroy $w}
toplevel $w
wm title $w "Radiobutton Demonstration"
wm iconname $w "radio"
positionWindow $w
label $w.msg -font $font -wraplength 5i -justify left \
    -text "ɂ 2̃WI{^O[v\Ă܂B{^NbNƁÃ{^̃O[v̒őI܂BeO[vɑ΂ẴO[v̒̂ǂ̃{^IĂ邩ϐ蓖ĂĂ܂B݂̕ϐ̒lɂ́uϐQƁv{^NbNĂB"

pack $w.msg -side top

frame $w.buttons
pack  $w.buttons -side bottom -expand y -fill x -pady 2m
button $w.buttons.dismiss -text  -command "destroy $w"
button $w.buttons.code -text "R[hQ" -command "showCode $w"
button $w.buttons.vars -text "ϐQ"  \
	-command "showVars $w.dialog size color"
pack $w.buttons.dismiss $w.buttons.code $w.buttons.vars -side left -expand 1

frame $w.left
frame $w.right
pack $w.left $w.right -side left -expand yes  -pady .5c -padx .5c

foreach i {10 12 18 24} {
    radiobutton $w.left.b$i -text "|CgTCY $i" -variable size \
	    -relief flat -value $i
    pack $w.left.b$i  -side top -pady 2 -anchor w
}

foreach color {     } {
    set lower [string tolower $color]
    radiobutton $w.right.$lower -text $color -variable color \
	    -relief flat -value $lower
    pack $w.right.$lower -side top -pady 2 -anchor w
}
