/* 
 * useEntInit.c --
 *
 *      Use_EntInit to initialize USE's entities interpreter;
 *      may be customized to install own Tcl packages
 *
 */

#include <tcl.h>
#include <tk.h>

extern int Blt_Init(Tcl_Interp*);

/*
 * The following lines are added to support USE's customization
 * on systems that don't find the main function in a library.
 * NOTE: the USE library must be linked before the Tk library!
 */
extern int main();
int *useDummyMainPtr = (int *) main;

/*
 *----------------------------------------------------------------------
 *
 * Use_EntInit --
 *	This procedure is similar to Tcl_AppInit, but called by 
 *      useMainWinCmd. It performs initializations for USE's entities
 *      interpreter. It may be extended with additional package 
 *      initializations in order to design user shell components 
 *      for applications with them.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	none
 *
 *----------------------------------------------------------------------
 */
int Use_EntInit(Tcl_Interp *interp)
{
  if (Tcl_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }
  if (Tk_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

  /*
   *  following lines might be deleted if BLT commands are not needed
   */
  if (Blt_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

  return TCL_OK;
}
