# ----------------------------------------------------------------------
#  PURPOSE:  drag&drop send routine for "use_component" data 
#            (a component name)
#
#  Widgets that are to participate in drag&drop operations for
#  "use_component" data should be registered as follows:
#
#      blt_drag&drop source .win handler use_component dd_send_use_component
#      blt_drag&drop target .win handler use_component my_use_component_handler
#
#      proc my_use_component_handler {} {
#          global DragDrop
#
#          set data $DragDrop(use_component)
#            .
#            .  do something with $data
#            .
#      }
#
#   AUTHOR:  rf
#
# ======================================================================

# ----------------------------------------------------------------------
# COMMAND: dd_send_use_component <interp> <ddwin> <data>
#
#   INPUTS
#     <interp> = interpreter for target application
#      <ddwin> = pathname for target drag&drop window
#       <data> = data returned from -tokencmd
#
#   RETURNS
#     ""
#
#   SIDE-EFFECTS
#     Sends data to remote application DragDrop(use_component), and then
#     invokes the "use_component" handler for the drag&drop target.
# ----------------------------------------------------------------------
proc dd_send_use_component {interp ddwin data} {
   send $interp "
      global use
      if {\[catch \{set use(tree,$data)\}\] != 0} {
         error \{no component tree \"$data\"\}
      }
      global DragDrop
      set DragDrop(use_component) [list $data]
   "
   send $interp "blt_drag&drop target $ddwin handle use_component"
}
