#!../treesh/treesh -f
#
# partree: tree widget for displaying parse trees
# mfk update for tree-3.6 950518
# add the files and dirs under the given one to the tree

proc partreeListDirs {tree dir} {
    global treebitmapdir
    set count 0
    foreach i [partreeGetComps $dir] {
	set count [expr "$count + 1"]
	if {[partreeIsLeaf $dir/$count]} then {
            tree_addNode $tree $dir $dir/$count $treebitmapdir/dir.xbm "[partreeLeafVal $dir/$count]"
	} else {
            tree_addNode $tree $dir $dir/$count $treebitmapdir/dir.xbm "$i"
	}
    }
}

proc partreeRecListDirs {tree dir} {
  global treebitmapdir
  set count 0
    foreach i [partreeGetComps $dir] {
      set count [expr "$count + 1"]

	if {[partreeIsLeaf $dir/$count]} then {
            tree_addNode $tree $dir $dir/$count $treebitmapdir/dir.xbm "[partreeLeafVal $dir/$count]"
	} else {
            tree_addNode $tree $dir $dir/$count $treebitmapdir/dir.xbm "$i"
	}
        if {![partreeIsLeaf $dir/$count]} {
	    partreeRecListDirs $tree $dir/$count 
	    }
    }
}

proc partreeIsLeaf {dirpath} {
  global yyParseTree
  set branch [concat stub $yyParseTree]
# step down the tree along a path
    foreach elem [split $dirpath/0 /] { 
      set branch [lindex $branch $elem]
      }
# return true if leaf
    return [string match $branch LEAF] 
  }

proc partreeLeafVal {dirpath} {
  global yyParseTree
  set branch [concat stub $yyParseTree]
# step down the tree along a path
    foreach elem [split $dirpath /] { 
      set branch [lindex $branch $elem]
      }
# return the rest of the tree is life
# not!
#   return [lrange $branch 1 end] 
   return [lindex $branch 1] 
  }

# called when the text of a node is double-clicked
proc partreeToggleChildren {tree} {
    set path [tree_getCurrent $tree]
    if [$tree isleaf $path] {
	if {[partreeIsLeaf $path]} {
    	  puts stderr "leaf node [partreeLeafVal $path]" 
	} else {
	  partreeListDirs $tree $path
	}
     } else {
	$tree prune $path
    }
    $tree draw
}

# called when bitmap of a node is double-clicked
proc dirtreeRecToggleChildren {tree} {
    set path [tree_getCurrent $tree]
    puts stderr "path $path"
    if [$tree isleaf $path] {
	if {[partreeIsLeaf $path]} {
    	  puts stderr "leaf node [partreeLeafVal $path]" 
	} else {
	  partreeRecListDirs $tree $path
	}
     } else {
	$tree prune $path
    }
    $tree draw


#--------------
#     if [$tree isleaf $path] {
#	partreeRecListDirs $tree $path
#     } else {
#	$tree prune $path
#    }
#    $tree draw
}


# create the menu bar

proc menubar_create {tree} {
    set menubar [frame .menu -relief raised -bd 2]
    pack $menubar -side top -fill x -ipady 1m
    
    # file menu
    set mb  [menubutton $menubar.file -text "File" -menu $menubar.file.m]
    set m [menu $mb.m]
    pack $mb -side left -padx 1m -ipadx 1m
    $m add command -label "Exit" -command {destroy .}

    # view menu
    set mb  [menubutton $menubar.view -text "View" -menu $menubar.view.m]
    set m [menu $mb.m]
    pack $mb -side left -padx 1m -ipadx 1m
    $m add command -label "Toggle Tree Layout" \
	-command "tree_toggleLayout $tree"
}

proc partreeGetComps {dirpath} {
  global yyParseTree
  set branch [concat stub $yyParseTree]
# step down the tree along a path
    foreach elem [split $dirpath /] { 
      set branch [lindex $branch $elem]
      }
# at end of path get the name of each child
  set complist ""
  foreach component [lrange $branch 1 end] {
      lappend complist [lindex $component 0]
    }
  return $complist
  }



#--------------------------------------------------------------------------------
# parse the command line options
#
# Usage: dirtree ?dir? ?opartreeion arg option arg?
#

proc dirtreeOptions {argv} {
 	if {!([llength $argv]==1) ||  ![file isfile [lindex $argv 0]]} then { 			
         puts stderr "       usage: ptree parsetreefile -pf"
         puts stderr "       pf = print the input file to stderr"
         exit 1
        }
}

#--------------------------------------------------------------------------------
lappend auto_path /projects/tcl/extensions/tree-3.6/demos
set treebitmapdir /projects/tcl/extensions/tree-3.6/demos/bitmaps

dirtreeOptions $argv
wm title . "Parse Tree"
wm minsize . 10 10 
option readfile  /projects/tcl/extensions/tree-3.6/demos/app-defaults/parsetree

set canvas .canvas
set tree $canvas.tree
menubar_create $tree
canvas_create . $canvas
tree_create $tree "partreeToggleChildren $tree" "dirtreeRecToggleChildren $tree"


# parse the command line options

#read in the parsetree
puts stderr "Parse Tree from file [lindex $argv 0]"
set yyParseTree [read [open [lindex $argv 0] r]]
puts stderr "Parse Tree $yyParseTree"
# read X defaults file
#teReadDefaults Dirtree


# add the root node
set dir 1
tree_addNode $tree "" $dir $treebitmapdir/dir.xbm [lindex [lindex $yyParseTree 0] 0]
partreeListDirs $tree $dir

$tree draw
tkwait visibility $canvas
tree_center $tree
