# 940502 Added awk filter so complete glide spec can be in one file
# ------------------------------------------------------------------------------- Lex Stuff
# These tcl procedures use the real lex to put a list of the lexemes found into
# a global list yyTokenList. The tcl procedure yylex then iterates through this
# list on request ( by the tcl procedure yyparse).

# -------------------------------------------------------- create lexer
proc TyaccGenerateLexer {lexdotlfile} {

# 1) invoke standard lex to generate a lex.yy.c file
  exec lex $lexdotlfile
# 2) invoke byac -d to get y.tab.h header file

# 3) invoke c compiler to create lexer
  exec cc lex.yy.c -ll -o LexerForTyacc
}

# -------------------------------------------------------- use lexer
proc TyaccExecuteLexer {SentenceFile} {
  global yyTokenList Tyacc
  set tyacclibdir "/projects/tcl/extensions/tyacc-0.8/lib"


  if $Tyacc(vinput) {
  if $Tyacc(awkfilterflg) then { 
    puts stderr "$tyacclibdir/$awkfilter"
    set awkfilter $Tyacc(awkfilter)
    puts stderr [exec awk -f "$tyacclibdir/$awkfilter" < $SentenceFile] 
   } else { 
    puts stderr [exec cat $SentenceFile] 
   }
}
# Execute lex and put bind output with global variable
  if $Tyacc(awkfilterflg) then { 
    set yyTokenList [exec awk -f "$tyacclibdir/$awkfilter" | LexerForTyacc < $SentenceFile]
  } else  {
    set yyTokenList [exec LexerForTyacc < $SentenceFile]
  }
}

# -------------------------------------------------------- tcl lex
proc yylex {} {
  global lexindex yyTokenList yylval yyname yydebug
  set yylval [lindex [lindex $yyTokenList $lexindex] 0]
  set rval   [lindex [lindex $yyTokenList $lexindex] 1]

  incr lexindex
  if $yydebug {
     puts stderr "LEX:\t lexeme value is $yylval, lexeme type code is $rval"
  }
  return $rval
}

# -------------------------------------------------------------------------- End of Lex Stuff
# -------------------------------------------------------------------- Command Line Options
# parse the command line options

proc TyaccOptions {argv} {
    global Tyacc

    # save options
    set Tyacc(argv) "$argv"

    # for error message
    set usage {
usage: parser.tcl 

Option              Arg Type      Description
-----------------------------------------------------------------------
-l                  file          lex .l  file to process (required)
-e                  file          file of examples sentences to parse
-vstates	    none	  verbose: print states parser goes through
-vtree		    none	  verbose: print parse tree
-vinput		    none          verbose: print input sentences (what went in with -e)
-vlexout	    none    	  verbose: print output of lexer (lexical tokens)
-awkfilter          file          run this awkfilter program, e.g. to extract appropriate part of a file
}

    # set initial values
    set Tyacc(lexfile) ""
    set Tyacc(yaccfile) ""
    set Tyacc(sentencefile) ""
    set Tyacc(cwd) ""
    set Tyacc(debug) ""
    set Tyacc(vstates) 0
    set Tyacc(vtree) 0
    set Tyacc(vinput) 0
    set Tyacc(vlexout) 0
    set Tyacc(awkfilterflg) 0

    puts stderr "Parser command line args:  $argv"

    # parse options
    set n [llength $argv]
    for {set i 0} {$i < $n} {incr i} {
	set opt [lindex $argv $i]
	if {"[string index $opt 0]" == "-"} {
	    set arg [lindex $argv [incr i]]
	}
	case $opt in {
	    -l    		{set Tyacc(lexfile) $arg}
	    -y    		{set Tyacc(yaccfile) $arg}
	    -e           	{set Tyacc(sentencefile) $arg}
            -D                  {set Tyacc(debug) 1}
            -vstates            {set Tyacc(vstates) 1}
            -vtree              {set Tyacc(vtree) 1}
            -vinput             {set Tyacc(vinput) 1}
            -vlexout            {set Tyacc(vlexout) 1}
            -awkfilter          {set Tyacc(awkfilter) $arg ; set Tyacc(awkfilterflg) 1}
	    default		{puts stderr "$usage"}
	}
    }

    # set any values that were not explicitly set as options
    if {"$Tyacc(cwd)" == ""} {
        set Tyacc(cwd) [exec pwd]
    }
    if {"$Tyacc(debug)" == ""} {
        set Tyacc(debug) 0
    }
}


# -------------------------------------------------------------------- Main Program
proc TyaccWholeEnchilada {} {
  global yyParseTree yyTokenList yydebug lexindex Tyacc
  global yyStateTable yyParseTreeList yyParseLoopCount

  set yydebug $Tyacc(debug)
  set lexindex 0
  set yyParseLoopCount 0
  set yyStateTable ""

  puts stderr "Generating and compiling lexer for $Tyacc(lexfile)..."
  TyaccGenerateLexer $Tyacc(lexfile)

  puts stderr "Executing lexer on $Tyacc(sentencefile)..."
  TyaccExecuteLexer  $Tyacc(sentencefile)
  if $Tyacc(vlexout) {
    puts stderr "\nThe Token List is: $yyTokenList" }

  puts stderr "Executing tcl parser ..."
  set result [yyparse]
  if $Tyacc(vtree) {
    puts stderr "\nThe Parse Tree List is: $yyParseTreeList($yyParseLoopCount)" }
  if $Tyacc(vstates) {
    puts stderr "\nThe State Transition List is:"
    foreach a $yyStateTable {
      puts stderr "\t $a" } }
  puts stderr "Done"
}

# -------------------------------------------------------------------- Initializations
TyaccOptions $argv


# -------------------------------------------------------------------- Execute Main Program
TyaccWholeEnchilada


