# tkxpilots Version 2.0pl0 - funky interface to xpilots
# Copyright (C) 1993-1994 Richard Oak.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

proc set_check {button value} {
	if {$value == 0} {
		$button deselect
	} else {
		$button select
	}
}

proc read_real {variable e1 value} {
	global $variable

	set e2 [expr $e1 + 1]
	set is_e [string first "e-" $value]
	set zeros "0000000000"
	if {$is_e != -1} {
		set exponent [string range $value [expr $is_e + 2] end]
		set value [string range $value 0 $is_e]
	}
	set int [string range $value 0 [expr [string first "." $value] \
                        -1]]
                set dec [string range $value [expr [string first "." $value] \
                        + 1] end]

                set mantissa $int$dec
                if {$is_e != -1} {
                        if {[expr $exponent > $e2]} {
				puts $variable
                                puts "Exponent too low"
                                puts "Defaulting  to zro"
				set $variable 0
			}
			if {[expr $exponent < $e1]} {
				puts $variable
                                puts "Exponent too high"
                                puts "Defaulting to 99"
                                set $variable 99
			}
			if {$exponent == $e1} {
                                set $variable [string range $mantissa 0 1]
                        }
                        if {$exponent == $e2} {
                                set $variable [string range $mantissa 0 0]
                        }
                } else {
                        set mantissa $mantissa$zeros
                        set $variable [string range $mantissa $e1 $e2]
                }
        }

proc parse {flspa flib} {

global gravity shipMass shotsMass shotspeed shotLife fireRepeatRate\
                wantedNumRobots robotsLeave robotLeaveLife robotLeaveScore \
                robotLeaveRatio maxPlayerShots shotsGravity idleRun noQuit \
                mapWidth mapHeight mapFileName mapName mapAuthor contactPort \
                mapData crashWithPlayer bounceWithPlayer playerKillings \
                playerShielding playerStartsShielded shotsWallBounce \
                ballsWallBounce minesWallBounce missilesWallBounce \
                sparksWallBounce debrisWallBounce maxObjectWallBounceSpeed \
                maxShieldedWallBounceSpeed maxUnshieldedWallBounceSpeed \
                maxShieldedWallBounceAngle maxUnshieldedWallBounceAngle \
                playerWallBrakeFactor objectWallBrakeFactor \
                objectWallBounceLifeFactor wallBounceFuelDrainMult \
                wallBounceDestroyItemProb reportToMetaServer limitedVisibility \
                limitedLives worldLives teamPlay teamAssign teamImmunity \
                playerMinimumStartFuel targetKillTeam targetTeamCollision \
                treasureKillTeam treasureCollisionDestroys \
                treasureCollisionMayKill onePlayerOnly timing edgeWrap \
                edgeBounce extraBorder gravityPoint gravityAngle \
                gravityPointSource gravityClockwise gravityAnticlockwise \
                framesPerSecond allowNukes allowClusters allowModifiers \
                allowLaserModifiers allowShipShapes playersOnRadar \
                missilesOnRadar minesOnRadar nukesOnRadar distinguishMissiles \
                shieldedItemPickup shieldedMining laserIsStunGun nukeMinSmarts \
                nukeMinMines nukeClusterDamage mineFuseTime movingItemProb \
                dropItemOnKillProb destroyItemInCollisionProb itemProbMult \
                maxItemDensity itemEnergyPackProb itemTankProb itemECMProb \
                itemMineProb itemMissileProb itemCloakProb itemSensorProb \
                itemWideangleProb itemRearshotProb itemAfterburnerProb \
                itemTransporterProb itemLaserProb itemEmergencyThrustProb \
                itemTractorBeamProb itemAutopilotProb initialFuel initialTanks \
                initialECMs initialMines initialMissiles initialCloaks \
                initialSensors initialWideangles initialRearshots \
                initialAfterburners initialTransporters initialLasers \
                initialEmergencyThrusts initialTractorBeams initialAutopilots \
                gameDuration defaultsFileName motd tkxpilot_library tmp_dir \
		gravX gravY itemsWallBounce maptoxbm

        set is_compressed [string first ".gz" $flspa]

        if {$is_compressed == -1} {
                set is_compressed [string first ".z" $flspa]
        }
        if {$is_compressed == -1} {
                set is_compressed [string first ".Z" $flspa]
        }

        if {$is_compressed != -1} {
                set CAT zcat
        } else {
                set CAT cat
        }

        foreach i [exec $CAT $flspa | $tkxpilot_library/quote] {
                set comment [string first "#" $i]

                if {$comment != -1} {
                        set i [string range $i 0 [expr $comment - 1]]
                }

                set colon [string first ":" $i]

                if {$colon != -1} {
                        set option [string tolower [string trim [string range \
                                $i 0 [expr $colon - 1]]]]
			if {$option != "mapname" && $option != "mapauthor" \
				&& $option != "mapfilename"} {
                        set value [string tolower [string trim [string range \
                                $i [expr $colon + 1] end ]]]
			} else {
			set value [string trim [string range \
                                $i [expr $colon + 1] end ]]
			}

                if {$value == "yes" || $value == "true"} {
                        set value 1
                }
                if {$value == "no" || $value == "false"} {
                        set value 0
                }
	if {$flib == 1} {
                switch -glob $option {
			mapwidth {
				set mapWidth $value
				.mainpanel.maps.info.picture.m entryconfigure \
					2 -label [format "Map Width : %s" $mapWidth]
				.mainpanel.grav.a.point.point.a.h configure \
					-to $mapWidth
			}
			mapheight {
				set mapHeight $value
				.mainpanel.maps.info.picture.m entryconfigure \
                                        3 -label [format "Map Height : %s" $mapHeight]
				set bm_file $tmp_dir/[file tail $mapFileName].xbm
				if {[file exists $bm_file] == 0} {
                                         exec $CAT $mapFileName | $maptoxbm 150 > $bm_file
					 exec chmod 666 $bm_file
                                }
                                .mainpanel.maps.info.picture configure -bitmap\
                                        @$bm_file

				scan [exec grep height $bm_file] "#define noname_height %d" bm_height

				.mainpanel.grav.a.point.point.v configure \
					-to $mapHeight -length [expr $bm_height\
						+ 34]
                        }
			mapname {
                                set mapName $value
                                .mainpanel.maps.info.picture.m entryconfigure \
                                        0 -label [format "Map Name : %s" $mapName]
			}
			mapauthor {
				set mapAuthor $value
				.mainpanel.maps.info.picture.m entryconfigure \
                                        1 -label [format "Map Author : %s" $mapAuthor]
			}
			mapdata {
				set bm_file $tmp_dir/[file tail $mapFileName].xbm
				if {[file exists $bm_file] == 0} {
					 exec $CAT $mapFileName | $maptoxbm 150 > $bm_file
					 exec chmod 666 $bm_file
		        	}
				.mainpanel.maps.info.picture configure -bitmap\
					@$bm_file
				.mainpanel.grav.a.point.point.a.pic configure \
					-bitmap @$bm_file
			}
			mapfilename {
				set mapFileName $value
			}
		}
		}
		switch -glob $option {
			shotswallbounce {
				set shotsWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.shots \
					$value
			}
			ballswallbounce {
				set ballsWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.balls \
					$value
			}
			mineswallbounce {
				set minesWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.mines \
					$value
			}
			itemswallbounce {
				set itemsWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.items \
					$value
			}
			missileswallbounce {
				set missilesWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.missiles \
					$value
			}
			sparkswallbounce {
				set sparksWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.sparks \
					$value
			}
			debriswallbounce {
				set debrisWallBounce $value
				set_check .mainpanel.grav.grav.bounce.frame.check.debris \
					$value
			}
			maxobjectwallbouncespeed {
				set maxObjectWallBounceSpeed $value
				.mainpanel.grav.grav.bounce.frame.s1.objspd.scale \
					set $value
			}
			maxobjectbouncespeed {
                                set maxObjectWallBounceSpeed $value
                                .mainpanel.grav.grav.bounce.frame.s1.objspd.scale \
                                        set $value
                        }
			maxshieldedwallbouncespeed {
				set maxShieldedWallBounceSpeed $value
				.mainpanel.grav.grav.bounce.frame.s1.shldspd.scale \
                                        set $value
			}
			maxshieldedbouncespeed {
                                set maxShieldedWallBounceSpeed $value
                                .mainpanel.grav.grav.bounce.frame.s1.shldspd.scale \
                                        set $value
                        }
			maxunshieldedwallbouncespeed {
				set maxUnshieldedWallBounceSpeed $value
				.mainpanel.grav.grav.bounce.frame.s1.unsdspd.scale \
					set $value
			}
			maxunshieldedbouncespeed {
                                set maxUnshieldedWallBounceSpeed $value
                                .mainpanel.grav.grav.bounce.frame.s1.unsdspd.scale \
                                        set $value
                        }
			maxshieldedplayerwallbounceangle {
                                set maxShieldedWallBounceAngle $value
                                .mainpanel.grav.grav.bounce.frame.s1.shldang.scale \
                                        set $value
                        }
			maxshieldedbounceangle {
                                set maxShieldedWallBounceAngle $value
                                .mainpanel.grav.grav.bounce.frame.s1.shldang.scale \
                                        set $value
                        }
			maxunshieldedplayerwallbounceangle {
				set maxUnshieldedWallBounceAngle $value
				.mainpanel.grav.grav.bounce.frame.s1.unsdang.scale \
					set $value
			}
			maxunshieldedbounceangle {
                                set maxUnshieldedWallBounceAngle $value
                                .mainpanel.grav.grav.bounce.frame.s1.unsdang.scale \
                                        set $value
                        }
			playerwallbrake {
				read_real playerWallBrakeFactor 1 $value
				.mainpanel.grav.grav.bounce.frame.s2.pyrbrk.scale \
					set $playerWallBrakeFactor
			}
			playerwallbouncebrakefactor {
				read_real playerWallBrakeFactor 1 $value
                                .mainpanel.grav.grav.bounce.frame.s2.pyrbrk.scale \
                                        set $playerWallBrakeFactor
                        }
			objectwallbrake {
				read_real objectWallBrakeFactor 1 $value
				.mainpanel.grav.grav.bounce.frame.s2.objbrk.scale \
					set $objectWallBrakeFactor
			}
			objectwallbouncebrakefactor {
				read_real objectWallBrakeFactor 1 $value
                                .mainpanel.grav.grav.bounce.frame.s2.objbrk.scale \
                                        set $objectWallBrakeFactor
                        }
			objectwallbouncelifefactor {
				read_real objectWallBounceLifeFactor 1 $value
				.mainpanel.grav.grav.bounce.frame.s2.objlif.scale \
					set $objectWallBounceLifeFactor
			}
			wallbouncefueldrainmult {
				read_real wallBounceFuelDrainMult -1 $value
				.mainpanel.grav.grav.bounce.frame.s2.fueldn.scale \
                                        set $wallBounceFuelDrainMult
			}
			wallbouncedrain {
				read_real wallBounceFuelDrainMult -1 $value
                                .mainpanel.grav.grav.bounce.frame.s2.fueldn.scale \
                                        set $wallBounceFuelDrainMult
                        }
			wallbouncedestroyitemprob {
				read_real wallBounceDestroyItemProb 2 $value
				.mainpanel.grav.grav.bounce.frame.s2.destit.scale \
					set $wallBounceDestroyItemProb
			}
			gravity {
				if {[string index $value 0] == "-"} {
					read_real gravity 0 [string range \
						$value 1 end ]
					set gravity -$gravity
				} else {
					read_real gravity 0 $value
				}
				.mainpanel.grav.grav.a.gravity.grav.scale set \
					$gravity
			}
			gravitypoint {
				scan $value "%d,%d" gravX gravY
				.mainpanel.grav.a.point.point.a.h set $gravX
			}
			gravityangle {
				set gravityAngle $value
				.mainpanel.grav.grav.a.gravity.ang.scale set \
					$gravityAngle
			}
			gravitypointsource {
				set gravityPointSource $value
				set_check .mainpanel.grav.grav.a.gravity.pnt $value
			}
			gravityclockwise {
				set gravityClockwise $value
				set_check .mainpanel.grav.grav.a.gravity.clock $value
			}
			gravityanticlockwise {
				set gravityAnticlockwise $value
				set_check .mainpanel.grav.grav.a.gravity.anti $value
			}
			robots {
				set wantedNumRobots $value
				.mainpanel.grav.grav.a.robots.rob.scale set \
					$wantedNumRobots
			}
			maxrobots {
                                set wantedNumRobots $value
                                .mainpanel.grav.grav.a.robots.rob.scale set \
					$wantedNumRobots
                        }
			robotleavelife {
				set robotLeaveLife $value
				.mainpanel.grav.grav.a.robots.life.scale set \
					$robotLeaveLife
			}
			robotleaveratio {
				set robotLeaveRatio $value
				.mainpanel.grav.grav.a.robots.ratio.scale set \
					$robotLeaveRatio
			}
			robotleavescore {
				set robotLeaveScore $value
				.mainpanel.grav.grav.a.robots.score.scale set \
					$robotLeaveScore
			}
			robotsleave {
				set robotsLeave $value
				set_check .mainpanel.grav.grav.a.robots.leave $value
			}
			teamplay {
				set teamPlay $value
				set_check .mainpanel.grav.grav.a.teams.play $value
				set_teams
			}
			teams {
				set teamPlay $value
                                set_check .mainpanel.grav.grav.a.teams.play $value
                        }
			teamassign {
				set teamAssign $value
				set_check .mainpanel.grav.grav.a.teams.ass $value
			}
			teamimmunity {
				set teamImmunity $value
				set_check .mainpanel.grav.grav.a.teams.imm $value
			}
			targetkillteam {
				set targetKillTeam $value
				set_check .mainpanel.grav.grav.a.teams.tarkt $value
			}
			targetteamcollision {
				set targetTeamCollision $value
				set_check .mainpanel.grav.grav.a.teams.tartc $value
			}
			targetcollision {
                                set targetTeamCollision $value
                                set_check .mainpanel.grav.grav.a.teams.tartc $value
                        }
			treasurekillteam {
				set treasureKillTeam $value
				set_check .mainpanel.grav.grav.a.teams.trekt $value
			}
			treasurecollisiondestroys {
				set treasureCollisionDestroys $value
				set_check .mainpanel.grav.grav.a.teams.trecd $value
			}
			treasurecollisiondestroy {
				set treasureCollisionDestroys $value
                                set_check .mainpanel.grav.grav.a.teams.trecd $value
                        }
			treasurecollisionmaykill {
				set treasureCollisionMayKill $value
				set_check .mainpanel.grav.grav.a.teams.treck $value
			}
			treasureunshieldedcollisionkills {
				set treasureCollisionMayKill $value
                                set_check .mainpanel.grav.grav.a.teams.treck $value
                        }
			movingitemprob {
				read_real movingItemProb 1 $value
				.mainpanel.items.others.moving.scale set \
					$movingItemProb
			}
			itemprobmult {
				set dec [string first "." $value]
				if {$dec != -1} {
					set value [string range $value 0 \
						[expr $dec - 1]]
				}
				set itemProbMult $value
				.mainpanel.items.others.mult.scale set \
					$itemProbMult 
			}
			itemprobfact {
                                set dec [string first "." $value]
                                if {$dec != -1} {
                                        set value [string range $value 0 \
                                                [expr $dec - 1]]
                                }
                                set itemProbMult $value
                                .mainpanel.items.others.mult.scale set \
					$itemProbMult
                        }
			maxitemdensity {
				read_real maxItemDensity 4 $value
				.mainpanel.items.others.maxden.scale set \
					$maxItemDensity
			}
			itemenergypackprob {
				read_real itemEnergyPackProb 9 $value
				.mainpanel.items.a.b.pr.2 set $itemEnergyPackProb
			}
			initialfuel {
				set $initialFuel $value
				.mainpanel.items.a.b.in.2 set $value
			}
			itemtankprob {
				read_real itemTankProb 9 $value
                                .mainpanel.items.a.b.pr.3 set $itemTankProb
			}
			initialtanks {
				set $initialTanks $value
				.mainpanel.items.a.b.in.3 set $value
			}
			itemecmprob {
				read_real itemECMProb 9 $value
				.mainpanel.items.a.b.pr.4 set $itemECMProb
			}
			initialecms {
				set initialECMs $value
				.mainpanel.items.a.b.in.4 set $value
			}
			itemmineprob {
				read_real itemMineProb 9 $value
				.mainpanel.items.a.b.pr.5 set $itemMineProb
			}
			initialmines {
				set initialMines $value
				.mainpanel.items.a.b.in.5 set $value
                        }
                        itemmissileprob {
                                read_real itemMissileProb 9 $value
                                .mainpanel.items.a.b.pr.6 set $itemMissileProb
                        }       
                        initialmissiles {
                                set initialMissiles $value
                                .mainpanel.items.a.b.in.6 set $value
                        }
                        itemcloakprob {
                                read_real itemCloakProb 9 $value
                                .mainpanel.items.a.b.pr.7 set $itemCloakProb
                        }       
			initialcloaks {
                                set initialCloaks $value
                                .mainpanel.items.a.b.in.7 set $value
                        }
                        itemsensorprob {
                                read_real itemSensorProb 9 $value
                                .mainpanel.items.a.b.pr.8 set $itemSensorProb
                        }
                        initialsensors {
                                set initialSensors $value
                                .mainpanel.items.a.b.in.8 set $value
                        }
                        itemwideangleprob {
                                read_real itemWideangleProb 9 $value
                                .mainpanel.items.a.b.pr.9 set $itemWideangleProb
			}
                        initialwideangles {
                                set initialWideangles $value
                                .mainpanel.items.a.b.in.9 set $value
                        }
                        itemrearshotprob {
                                read_real itemRearshotProb 9 $value
                                .mainpanel.items.a.b.pr.10 set $itemRearshotProb
			}
                        initialrearshots {
                                set initialRearshots $value
                                .mainpanel.items.a.b.in.10 set $value
                        }
                        itemafterburnerprob {
                                read_real itemAfterburnerProb 9 $value
                                .mainpanel.items.a.b.pr.11 set $itemAfterburnerProb
			}
                        initialafterburners {
                                set initialAfterburners $value
                                .mainpanel.items.a.b.in.11 set $value
			}
			itemlaserprob {
                                read_real itemLaserProb 9 $value
                                .mainpanel.items.a.b.pr.12 set $itemLaserProb
			}
                        initiallasers {
                                set initialLasers $value
                                .mainpanel.items.a.b.in.12 set $value
                        }
                        itememergencythrustprob {
				read_real itemEmergencyThrustProb 9 $value
				.mainpanel.items.a.b.pr.13 set $itemEmergencyThrustProb
			}
			initialemergencythrusts {
				set initialEmergencyThrusts $value
				.mainpanel.items.a.b.in.13 set $value
			}
			itemtractorbeamprob {
                                read_real itemTractorBeamProb 9 $value
                                .mainpanel.items.a.b.pr.14 set $itemTractorBeamProb
			}
			initialtractorbeams {
                                set initialTractorBeams $value
                                .mainpanel.items.a.b.in.14 set $value
			}
			itemautopilotprob {
                                read_real itemAutopilotProb 9 $value
                                .mainpanel.items.a.b.pr.15 set $itemAutopilotProb
			}
                        initialautopilots {
                                set initialAutopilots $value
                                .mainpanel.items.a.b.in.15 set $value
                        }
                        itemtransporterprob {
                                read_real itemTransporterProb 9 $value
                                .mainpanel.items.a.b.pr.16 set $itemTransporterProb
                        }
                        initialtransporters {
                                set initialTransporters $value
                                .mainpanel.items.a.b.in.16 set $value
                        }
			nukeminsmarts {
				set nukeMinSmarts $value
				.mainpanel.items.others.minsmarts.scale set \
					$value
			}
			nukeminmines {
				set nukeMinMines $value
				.mainpanel.items.others.minmines.scale set \
					$value
			}
			nukeclusterdamage {
				read_real nukeClusterDamage 1 $value
				.mainpanel.items.others.nukeclus.scale set \
					$nukeClusterDamage
			}
			minefusetime {
				read_real mineFuseTime 1 $value
				.mainpanel.items.others.minefuse.scale set \
					$mineFuseTime
			}
			dropitemonkillprob {
				read_real dropItemOnKillProb 1 $value
				.mainpanel.items.others.dpkill.scale set \
                                        $dropItemOnKillProb
                        }
			destroyitemincollisionprob {
				read_real destroyItemInCollisionProb 1 $value
				.mainpanel.items.others.dstcol.scale set \
					$destroyItemInCollisionProb
			}
			crashwithplayer  {
                                set crashWithPlayer $value
                                set_check .mainpanel.items.check.crash $value
                        }
			allowplayercrashes {
				set crashWithPlayer $value
				set_check .mainpanel.items.check.crash $value
			}
			allowplayerbounces {
				set bounceWithPlayer $value
				set_check .mainpanel.items.check.bounce $value
			}
			allowplayerkilling {
				set playerKillings $value
				set_check .mainpanel.items.check.kills $value
			}
			playerkillings {
			        set playerKillings $value
                                set_check .mainpanel.items.check.kills $value
                        }
			killings {
				set playerKillings $value
                                set_check .mainpanel.items.check.kills $value
                        }
			allowshields {
				set playerShielding $value
				set_check .mainpanel.items.check.shields $value
			}
			shields {
                                set playerShielding $value
                                set_check .mainpanel.items.check.shields $value
                        }
			playershielding {
                                set playerShielding $value
                                set_check .mainpanel.items.check.shields $value
                        }
			playerstartsshielded {
				set playerStartsShielded $value
				set_check .mainpanel.items.check.stshld $value
			}
			allownukes {
				set allowNukes $value
				set_check .mainpanel.items.check.nukes $value
			}
			nukes {
                                set allowNukes $value
                                set_check .mainpanel.items.check.nukes $value
                        }
			allowclusters {
				set allowclusters $value
				set_check .mainpanel.items.check.clusters $value
			}
			clusters {
                                set allowclusters $value
                                set_check .mainpanel.items.check.clusters $value
                        }
			allowmodifiers {
				set allowModifiers $value
                                set_check .mainpanel.items.check.modif $value
			}
			modifiers {
                                set allowModifiers $value
                                set_check .mainpanel.items.check.modif $value
                        }
			allowlasermodifiers {
				set allowLaserModifiers $value
				set_check .mainpanel.items.check.lmod $value
                        }
			lasermodifiers {
                                set allowLaserModifiers $value
                                set_check .mainpanel.items.check.lmod $value
                        }
			allowshipshapes {
				set allowShipShapes $value
				set_check .mainpanel.items.check.shshps $value
			}
			shipshapes {
                                set allowShipShapes $value
                                set_check .mainpanel.items.check.shshps $value
                        }
			playersonradar {
				set playersOnRadar $value
				set_check .mainpanel.items.check.plyrad $value
                        }
			playersradar {
                                set playersOnRadar $value
                                set_check .mainpanel.items.check.plyrad $value
                        }
			missilesonradar {
                                set missilesOnRadar $value
                                set_check .mainpanel.items.check.misrad $value
                        }
                        missilesradar {
                                set missilesOnRadar $value
                                set_check .mainpanel.items.check.misrad $value
                        }
			minesonradar {
                                set minesOnRadar $value
                                set_check .mainpanel.items.check.minrad $value
                        }
                        minesradar {
                                set minesOnRadar $value
                                set_check .mainpanel.items.check.minrad $value
                        }
			nukesonradar {
                                set nukesOnRadar $value
                                set_check .mainpanel.items.check.nukerad $value
                        }
                        nukesradar {
                                set nukesOnRadar $value
                                set_check .mainpanel.items.check.nukerad $value
                        }
			distinguishmissiles {
				set distinguishMissiles $value
				set_check .mainpanel.items.check.dismis $value
			}
			shieldeditempickup {
				set shieldedItemPickup $value
				set_check .mainpanel.items.check.shldpu $value
			}
			shielditem {
                                set shieldedItemPickup $value
                                set_check .mainpanel.items.check.shldpu $value
                        }       
			shieldedmining {
                                set shieldedMining $value
                                set_check .mainpanel.items.check.shldmn $value
                        }       
                        shieldmine {
                                set shieldedMining $value
                                set_check .mainpanel.items.check.shldmn $value
                        }       
			laserisstungun {
                                set laserIsStunGun $value
                                set_check .mainpanel.items.check.lasstn $value
                        }       
			shipmass {
				read_real shipMass 1 $value
				set shipMass [string index $value 0]$shipMass
				.mainpanel.misc.a.slid.shpmas.scale set \
					$shipMass
			}
			shotmass {
				read_real shotsMass 1 $value
                                .mainpanel.misc.a.slid.shtmas.scale set \
                                        $shotsMass
			}
			shotspeed {
				read_real shotspeed 1 $value
				set shotspeed [string index $value 0]$shotspeed
				.mainpanel.misc.a.slid.shtspd.scale set \
                                        $shotspeed
			}
			playerminstartfuel {
				set playerMinStartFuel [string range $value \
					0 2]
				.mainpanel.misc.a.slid.fuel.scale set \
                                        $playerMinStartFuel
			}
			playerminimumstartfuel {
                                set playerMinStartFuel [string range $value \
                                        0 2]
                                .mainpanel.misc.a.slid.fuel.scale set \
                                        $playerMinStartFuel
                        }
			shotlife {
				set shotLife $value
				.mainpanel.misc.a.slid.shtlif.scale set $value
			}
			firerepeatrate {
				set fireRepeatRate $value
				.mainpanel.misc.a.slid.firrep.scale set $value
                        }
                        firerepeat {
                                set fireRepeatRate $value
                                .mainpanel.misc.a.slid.firrep.scale set $value
                        }
			maxplayershots {
				set maxPlayerShots $value
				.mainpanel.misc.a.slid.maxsht.scale set $value
			}
			shots {
                                set maxPlayerShots $value
                                .mainpanel.misc.a.slid.maxsht.scale set $value
                        }
			worldlives {
				set worldLives $value
				.mainpanel.misc.a.slid.lives.scale set $value
			}
			lives {
                                set worldLives $value
                                .mainpanel.misc.a.slid.lives.scale set $value
                        }
			framespersecond {
				set framesPerSecond $value
				.mainpanel.misc.a.slid.fps.scale set $value
                        }
			fps {
                                set framesPerSecond $value
                                .mainpanel.misc.a.slid.fps.scale set $value
                        }
			gameduration {
				read_real gameDuration -1 $value
				.mainpanel.misc.a.slid.pizza.scale set $gameDuration
                        }
			time {
				read_real gameDuration -1 $value
				.mainpanel.misc.a.slid.pizza.scale set $gameDuration
                        }
			extraborder {
				set extraBorder $value
				set_check .mainpanel.misc.a.check.extra $value
				set_extra
			}
			edgewrap {
				set edgeWrap $value
				set_check .mainpanel.misc.a.check.ewrap $value
				set_wrap
			}
			edgebounce {
				set edgeBounce $value
				set_check .mainpanel.misc.a.check.ebnce $value
				set_bounce
			}
			oneplayeronly {
				set onePlayerOnly $value
				set_check .mainpanel.misc.a.check.oneplayer \
					$value
			}
			shotsgravity {
				set shotsGravity $value
				set_check .mainpanel.misc.a.check.shtgrv \
					$value
			}
			rawmode {
				set rawMode $value
				set_check .mainpanel.misc.a.check.raw $value
			}
			idlerun {
                                set rawMode $value
                                set_check .mainpanel.misc.a.check.raw $value
                        }
			noquit {
				set noQuit $value
				set_check .mainpanel.misc.a.check.noquit $value
			}
			reporttometaserver {
				set reportToMetaServer $value
				set_check .mainpanel.misc.a.check.report $value
                        }
			limitedvisibility {
				set limitedVisibility $value
				set_check .mainpanel.misc.a.check.limvis $value
			}
			limitedlives {
				set limitedLives $value
				set_check .mainpanel.misc.a.check.limliv $value
			}
			timing {
				set timing $value
				set_check .mainpanel.misc.a.check.race $value
			}
			race {
                                set timing $value
                                set_check .mainpanel.misc.a.check.race $value
                        }
			contactport {
				.mainpanel.misc.a.ent.port.ent delete 0 \
					[string length $contactPort]
				set contactPort $value
				.mainpanel.misc.a.ent.port.ent insert 0 $value
			}
			port {
                                .mainpanel.misc.a.ent.port.ent delete 0 \ 
                                        [string length $contactPort]
                                set contactPort $value
                                .mainpanel.misc.a.ent.port.ent insert 0 $value
                        }
			team_to_join {
				.mainpanel.misc.a.ent.port.team.$team_to_join \
					configure -state normal
				set $team_to_join $value
				.mainpanel.misc.a.ent.port.team.$team_to_join \ 
                                        configure -state active
			}
			default {
			}
		}
		}
	}
}
