# RCS Id:
#  $Id: basicWidgets.tcl,v 1.2 1995/05/13 19:53:38 ndanger Exp $

###     basicWidgets.tcl : Some simple combo widgets.
###     Copyright (C) 1995 Norman Danner
### 
###     This program is free software; you can redistribute it and/or modify
###     it under the terms of the GNU General Public License as published by
###     the Free Software Foundation; either version 2 of the License, or
###     (at your option) any later version.
### 
###     This program is distributed in the hope that it will be useful,
###     but WITHOUT ANY WARRANTY; without even the implied warranty of
###     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
###     GNU General Public License for more details.
### 
###     You should have received a copy of the GNU General Public License
###     along with this program; if not, write to the Free Software
###     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

set BWint(entryBox,type) label
set BWint(entryBox,orient) hor
set BW(entryBox,expand) no
set BW(buttonPanel,padx) 10
set BW(scrollListBox,mode_single) 1
set BW(scrollListBox,sel) ""


proc UniqueSubwindow {w p} {
	
	set i 0
	while {[winfo exists $w.$p$i]} {incr i}
	return "$w.$p$i"
	
}


proc EntryBox {f lbl} {

    global BWint
    global BW
    
    frame $f
    $BWint(entryBox,type) $f.l -text "$lbl"
    entry $f.e -relief sunken
    
    if {[string match "hor" $BWint(entryBox,orient)]} {
    	pack $f.l -side left
    	pack $f.e -side right -fill x -expand $BW(entryBox,expand)
    } \
    else {
    	pack $f.l -side top
    	pack $f.e -side bottom -fill x -expand $BW(entryBox,expand)
    }
    
    if {[catch "rename $f ${f}_cmd"]} {rename ${f}_cmd "" ; rename $f ${f}_cmd}
    proc $f {args} "
    	if \{\"$BWint(entryBox,type)\" == \[lindex \$args 0\]\} \{return $f.l\}
    	if \{\[lindex \$args 0\] == \"entry\"\} \{return $f.e\}
    	return \[eval \"${f}_cmd \" \$args\]
    "
    
    return "$f.e $f.l"

}


proc LabelEntryH {f lbl {entryargs {}} {labelargs {}}} {

    global BWint
    
    set BWint(entryBox,type) label
    set BWint(entryBox,orient) hor
    set ret_val [EntryBox $f "$lbl"]
    if {$entryargs != ""} {eval [$f entry] configure $entryargs}
    if {$labelargs != ""} {eval [$f label] configure $labelargs}
    return $f
    
}


proc LabelEntryV {f lbl {entryargs {}} {labelargs {}}} {

    global BWint
    
    set BWint(entryBox,type) label
    set BWint(entryBox,orient) ver
    set ret_val [EntryBox $f "$lbl"]
    if {$entryargs != ""} {eval [$f entry] configure $entryargs}
    if {$labelargs != ""} {eval [$f label] configure $labelargs}
    return $f
    
}


proc ButtonEntryH {f lbl {entryargs {}} {buttonargs {}} } {

    global BWint
    
    set BWint(entryBox,type) button
    set BWint(entryBox,orient) hor
    set ret_val [EntryBox $f "$lbl"]
    if {$entryargs != ""} {eval [$f entry] configure $entryargs}
    if {$buttonargs != ""} {eval [$f button] configure $buttonargs}
    return $f
}


proc ButtonEntryV {f lbl {entryargs {}} {buttonargs {}} } {

    global BWint
    
    set BWint(entryBox,type) button
    set BWint(entryBox,orient) ver
    set ret_val [EntryBox $f "$lbl"]
    if {$entryargs != ""} {eval [$f entry] configure $entryargs}
    if {$buttonargs != ""} {eval [$f button] configure $buttonargs}
    return $f
    
}


proc MButtonEntryH {f lbl {entryargs {}} {mbuttonargs {}}} {

    global BWint
    
    set BWint(entryBox,type) menubutton
    set BWint(entryBox,orient) hor
    EntryBox $f "$lbl"
    set button [$f menubutton]
    set entry [$f entry]
    set mnu $button.m
    menu $mnu
    $button configure -menu $mnu
    if {$entryargs != ""} {eval $entry configure $entryargs}
    if {$mbuttonargs != ""} {eval $button configure $mbuttonargs}
    
    proc $f {args} "
    	if \{\"menubutton\" == \[lindex \$args 0\]\} \{return $button\}
    	if \{\"menu\" == \[lindex \$args 0\]\} \{return $mnu\}
    	if \{\"entry\" == \[lindex \$args 0\]\} \{return $entry\}
    	return \[eval \"${f}_cmd \" \$args\]
    "
    
    return $f
    
}


proc MButtonEntryV {f lbl {entryargs {}} {mbuttonargs {}}} {

    global BWint
    
    set BWint(entryBox,type) menubutton
    set BWint(entryBox,orient) ver
    EntryBox $f "$lbl"
    set button [$f menubutton]
    set entry [$f entry]
    set mnu $button.m
    menu $mnu
    $button configure -menu $mnu
    if {$entryargs != ""} {eval $entry configure $entryargs}
    if {$mbuttonargs != ""} {eval $button configure $mbuttonargs}
    
    proc $f {args} "
    	if \{\"menubutton\" == \[lindex \$args 0\]\} \{return $button\}
    	if \{\"menu\" == \[lindex \$args 0\]\} \{return $mnu\}
    	if \{\"entry\" == \[lindex \$args 0\]\} \{return $entry\}
    	return \[eval \"${f}_cmd \" \$args\]
    "
    
    return $f
    
}


proc ScrollListBox {w {lbargs {}} {sbxargs {}} {sbyargs {}}} {

    global BW
    
    frame $w

    scrollbar $w.sbx -orient hor -relief sunken
    scrollbar $w.sby -orient ver -relief sunken
    listbox $w.lb

    pack $w.sbx -side bottom -fill x
    pack $w.sby -side left -fill y
    pack $w.lb -side left -fill y -expand yes

    $w.lb configure -yscrollcommand "$w.sby set" -xscrollcommand "$w.sbx set"
    $w.sby configure -command "$w.lb yview"
    $w.sbx configure -command "$w.lb xview"
    
    if {$lbargs != ""} {eval $w.lb configure $lbargs}
    if {$sbxargs != ""} {eval $w.sbx configure $sbxargs}
    if {$sbyargs != ""} {eval $w.sby configure $sbyargs}
        
    if {[catch "rename $w ${w}_cmd"]} {rename ${w}_cmd "" ; rename $w ${w}_cmd}
    proc $w {args} "
    	if \{\"listbox\" == \[lindex \$args 0\]\} \{return $w.lb\}
    	if \{\"scrollx\" == \[lindex \$args 0\]\} \{return $w.sbx\}
    	if \{\"scrolly\" == \[lindex \$args 0\]\} \{return $w.sby\}
    	return \[eval \"${w}_cmd \" \$args\]
    "
    
    return $w

}


proc ScrollText {f {textargs {}} {sbargs {}} } {

    frame $f

    scrollbar $f.sby -orient ver -relief sunken
    text $f.text

    pack $f.sby $f.text -side left -fill y -expand yes

    $f.text configure -yscrollcommand "$f.sby set"
    $f.sby configure -command "$f.text yview"

    if {$textargs != ""} {eval $f.text configure $textargs}
    if {$sbargs != ""} {eval $f.sby configure $sbargs}

    if {[catch "rename $f ${f}_cmd"]} {rename ${f}_cmd "" ; rename $f ${f}_cmd}
    proc $f {args} "
    	if \{\"text\" == \[lindex \$args 0\]\} \{return $f.text\}
    	if \{\"scrolly\" == \[lindex \$args 0\]\} \{return $f.sby\}
    	return \[eval \"${f}_cmd \" \$args\]
    "

    return $f

}
