#!/usr/local/bin/wish -f

source new.tcl
source pie.tcl

set normalFont -adobe-helvetica-medium-r-*-120-*
set boldFont -adobe-helvetica-bold-r-*-120-*

# Create a pie, child of the . window, with a width of 150 pixels, a height of
# 50 pixels (that defined the ellipse), and a height of 20 pixels (use 0 if you
# don't like 3D):

set testPie [new pie . 400 100 20]
# set testPie [new pie . 400 100 20 "" "" auto "white cyan gray"] ### with user defined color list

# Pies graphics and slice labels are contained in a frame which you must pack or
# place:
pack $pie($testPie,frame)

pack [button .d -text "Delete pie" -command {set deletePie 1}] -fill x
pack [button .q -text Quit -command exit] -fill x

# create a couple of slices:
set slice1 [pie::newSlice $testPie "slice1 label text"]
set slice2 [pie::newSlice $testPie "slice2 label text"]
set slice3 [pie::newSlice $testPie "slice3 label text"]
set slice4 [pie::newSlice $testPie "slice4 label text"]
set slice5 [pie::newSlice $testPie "slice5 label text"]

# now size the slices in a semi randow way (slice size in per cent of whole pie)

set deletePie 0
set u 1
while {!$deletePie} {
    set v 100
    pie::sizeSlice $testPie $slice1 [set u [expr (3*$u)%31]]
    incr v -$u
    pie::sizeSlice $testPie $slice2 [set u [expr (5*$u)%31]]
    incr v -$u
    pie::sizeSlice $testPie $slice3 [set u [expr (7*$u)%31]]
    incr v -$u
    pie::sizeSlice $testPie $slice4 [set u [expr (11*$u)%31]]
    incr v -$u
    pie::sizeSlice $testPie $slice5 $v
    update
}

destroy .d
# delete pie thus freeing pie data and destroying pie widgets
delete pie $testPie
