#
# Tcl Library for tkCVS
#

#
# checkout.tcl,v 1.16 1995/11/06 05:02:01 davide Exp
#
# Set up a check out dialog.
#

proc checkout_setup {} {
  global checkout_mcode
  global checkout_version

  # This variable is a list containing all of the directories and
  # subdirectories that are expanded on the listbox.

  global displayed_list

  toplevel .checkout
  frame .checkout.menubar -relief raised -border 2
  frame .checkout.down -relief groove -border 2
  frame .checkout.up
  frame .checkout.up.left -relief raised
  frame .checkout.up.right -relief raised

  pack .checkout.menubar .checkout.up -side top -fill x
  pack .checkout.down -side bottom -fill x
  pack .checkout.up.left -side left -fill both
  pack .checkout.up.right -side left -fill both -expand 1

  label .checkout.lmcode -text "Module Code" -anchor w
  label .checkout.lvers -text "Tag A" -anchor w
  label .checkout.lvers2 -text "Tag B" -anchor w
  entry .checkout.tmcode -relief sunken -textvariable checkout_mcode
  entry .checkout.tvers -relief sunken -textvariable checkout_version
  entry .checkout.tvers2 -relief sunken -textvariable checkout_version2

  # bind_motifentry .checkout.tmcode
  # bind_motifentry .checkout.tvers
  # bind_motifentry .checkout.tvers2

  pack .checkout.lmcode .checkout.lvers .checkout.lvers2 -in .checkout.up.left \
    -side top -fill x -pady 3
  pack .checkout.tmcode .checkout.tvers .checkout.tvers2 -in .checkout.up.right \
    -side top -fill both -expand 1 -pady 3

  #
  # Create the Menu bar
  #

  menubutton .checkout.menubar.reports -text Reports -underline 0 \
    -menu .checkout.menubar.reports.m
  menubutton .checkout.menubar.search -text Search -underline 0 \
    -menu .checkout.menubar.search.m
  menubutton .checkout.menubar.patch -text Patch -underline 0 \
    -menu .checkout.menubar.patch.m
  menubutton .checkout.menubar.tag -text Tag -underline 0 \
    -menu .checkout.menubar.tag.m
  menubutton .checkout.menubar.help -text Help -underline 0 \
    -menu .checkout.menubar.help.m
  pack .checkout.menubar.reports .checkout.menubar.search \
    .checkout.menubar.patch .checkout.menubar.tag \
    -side left
  pack .checkout.menubar.help \
    -side right

  #
  # Create menus
  #

  menu .checkout.menubar.reports.m
  .checkout.menubar.reports.m add command -label "Module Tree ..." \
    -underline 7 \
    -command {modlist_by_code $checkout_mcode 0 $checkout_version}
  .checkout.menubar.reports.m add command -label "Modules Sorted by Name ..." \
    -underline 18 \
    -command {modlist_by_name 0 $checkout_version}
  .checkout.menubar.reports.m add command -label "Version Tree ..." \
    -command {modlist_by_code $checkout_mcode 1 $checkout_version}
  .checkout.menubar.reports.m add command -label "Version Listing by Name ..." \
    -command {modlist_by_name 1 $checkout_version}

  menu .checkout.menubar.search.m
  .checkout.menubar.search.m add command \
    -label "Search Repository by Code ..." \
    -underline 21 \
    -command code_search
  .checkout.menubar.search.m add command \
    -label "Search Repository by Name ..." \
    -underline 21 \
    -command name_search
  .checkout.menubar.search.m add command \
    -label "Search Repository by Keyword ..." \
    -underline 21 \
    -command keyword_search

  menu .checkout.menubar.patch.m
  .checkout.menubar.patch.m add command -label "Make Patch File ..." \
    -command {
      cvs_patch $checkout_mcode $checkout_version $checkout_version2
      wm withdraw .checkout
    }
  .checkout.menubar.patch.m add command -label "View Patch Summary ..." \
    -command {
      cvs_patch_summary $checkout_mcode $checkout_version $checkout_version2
    }

  menu .checkout.menubar.tag.m
  .checkout.menubar.tag.m add command -label "Tag Module" \
    -command {
      cvs_rtag $checkout_mcode "no" $checkout_version $checkout_version2
    }
  .checkout.menubar.tag.m add command -label "Branch Tag Module" \
    -command {
      cvs_rtag $checkout_mcode "yes" $checkout_version $checkout_version2
    }

  menu .checkout.menubar.help.m
  .checkout.menubar.help.m add command -label "Overview ..." \
    -command module_browser
  .checkout.menubar.help.m add separator
  .checkout.menubar.help.m add command -label "Checking out Modules ..." \
    -command checking_out_modules
  .checkout.menubar.help.m add command -label "Exporting ..." \
    -command exporting
  .checkout.menubar.help.m add command -label "Tagging and Branching ..." \
    -command tagging_and_branching
  .checkout.menubar.help.m add separator
  .checkout.menubar.help.m add command -label "Menu ..." \
    -command module_browser_menu
  .checkout.menubar.help.m add command -label "Buttons ..." \
    -command module_browser_buttons
  .checkout.menubar.help.m add separator
  .checkout.menubar.help.m add command -label "File Browser ..." \
    -command file_browser
  .checkout.menubar.help.m add command -label "Log Browser ..." \
    -command log_browser
  .checkout.menubar.help.m add separator
  .checkout.menubar.help.m add command -label "CVS modules File ..." \
    -command cvs_modules_file

  #
  # Create buttons
  #

  button .checkout.co -text "Check Out" \
    -command {
      cvs_checkout $checkout_mcode $checkout_version
      # wm withdraw .checkout
    }
  button .checkout.export -text "Export" \
    -command {
      cvs_export $checkout_mcode $checkout_version
      # wm withdraw .checkout
    }
  button .checkout.browse -text "File Browse" \
    -command {browse_files $checkout_mcode}

  # create a summary of the files which have changed between versions. -sj
  button .checkout.ps -text "Patch Summary" \
    -command {
       cvs_patch_summary $checkout_mcode \
                         $checkout_version \
                         $checkout_version2
    }

  button .checkout.quit -text "Quit" \
    -command {wm withdraw .checkout}

  pack .checkout.co .checkout.export .checkout.ps \
       .checkout.browse .checkout.quit \
    -in .checkout.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  # Create a scroll bar and three list boxes.
  scrollbar .checkout.scroll -relief sunken \
    -command {checkout_scroll}
  # Set up a selection rule so that only one item can be selected
  # at a time.
  listbox .checkout.namelist \
    -yscroll {.checkout.scroll set} -relief sunken \
    -width 40 -height 20 -setgrid yes -selectmode single
  listbox .checkout.infolist \
    -yscroll {.checkout.scroll set} -relief sunken \
    -width 10 -height 20 -setgrid yes -selectmode single
  listbox .checkout.codelist \
    -yscroll {.checkout.scroll set} -relief sunken \
    -width 20 -height 20 -setgrid yes -selectmode single

  # Set up key bindings for the lists so that they all select as
  # if the code list was pointed to.
  bind .checkout.codelist <Double-Button-1> \
    {checkout_act_on_code %y}
  bind .checkout.namelist <Double-Button-1> \
    {checkout_act_on_code %y}
  bind .checkout.infolist <Double-Button-1> \
    {checkout_act_on_code %y}
  bind .checkout.codelist <1> {checkout_select_code %y}
  bind .checkout.namelist <1> {checkout_select_code %y}
  bind .checkout.infolist <1> {checkout_select_code %y}
  bind .checkout.codelist <Button-2> { nop }
  bind .checkout.codelist <Any-B2-Motion> { nop }
  bind .checkout.namelist <Button-2> { nop }
  bind .checkout.namelist <Any-B2-Motion> { nop }
  bind .checkout.infolist <Button-2> { nop }
  bind .checkout.infolist <Any-B2-Motion> { nop }

  # Pack the scroll bar and the 3 lists side by side.
  pack .checkout.scroll -side right -fill y -padx 2 -pady 2
  pack .checkout.namelist .checkout.infolist .checkout.codelist \
    -side left -fill both -expand 1

  # Window manager stuff.
  wm withdraw .checkout
  wm title .checkout "Module Browser"
  wm minsize .checkout 1 1

  set displayed_list {}
  checkout_fill_listbox
}

proc checkout_scroll {args} {

# To support scrolling 3 listboxes simultaneously

  eval ".checkout.namelist yview $args"
  eval ".checkout.infolist yview $args"
  eval ".checkout.codelist yview $args"
}

proc checkout_run {} {
  wm deiconify .checkout
}

proc checkout_fill_listbox {} {
#
# Do this to update the display of the listbox.
#
  global displayed_list
  global dtitle

  .checkout.namelist delete 0 end
  .checkout.infolist delete 0 end
  .checkout.codelist delete 0 end

  if {! [info exists dtitle]} {
    return
  }

  foreach dname [array names dtitle] {
    if {[file dirname $dname] == "."} {
      .checkout.namelist insert end $dtitle($dname)
      .checkout.infolist insert end "Directory"
      .checkout.codelist insert end $dname
      if {[lsearch $displayed_list $dname] != -1} {
        checkout_fill_dir $dname
      }
    }
  }
}

proc checkout_fill_dir {dname} {
  global mtitle
  global dtitle
  global dcontents
  global dsubmenus
  global displayed_list

  # Display all of the modules in this subdir.

  if [info exists dcontents($dname)] {
    foreach mname $dcontents($dname) {
      .checkout.namelist insert end $mtitle($mname)
      .checkout.infolist insert end "Module"
      .checkout.codelist insert end $mname
    }
  }

  # Recurse through each subdir, only displaying sublevels of those
  # that are marked for display.

  if [info exists dsubmenus($dname)] {
    foreach subdir $dsubmenus($dname) {
      .checkout.namelist insert end $dtitle($subdir)
      .checkout.infolist insert end "Directory"
      .checkout.codelist insert end $subdir
      if {[lsearch $displayed_list $subdir] != -1} {
        checkout_fill_dir $subdir
      }
    }
  }
}

proc checkout_select_code {yposition} {
#
# Do this when a code is clicked on.
#
  global checkout_ypos
  global checkout_mcode

  set checkout_ypos $yposition

  # This does the actual selection
  .checkout.codelist select set \
    [.checkout.codelist nearest $yposition]
  set code [selection get]

  # This will update the "Module Name" entry box.
  set checkout_mcode [lindex $code 0]

  return $code
}

proc checkout_act_on_code {yposition} {
#
# Do this when a code is double-clicked on.
#
  global checkout_mcode
  global displayed_list

  # Do the selection bit.
  set code [checkout_select_code $yposition]

  # If the module is displayed, remove it from the display.  If it is
  # not displayed, add it to the display.
  set pos [lsearch $displayed_list $checkout_mcode]
  if {$pos == -1} {
    lappend displayed_list $checkout_mcode
  } else {
    set displayed_list [lreplace $displayed_list $pos $pos]
  }

  # Redraw the listbox.
  checkout_fill_listbox

  # Do the selection bit again so that the item remains selected after the
  # redraw.
  set code [checkout_select_code $yposition]
}
