' $Id: dbcursor.n,v 1.2 1995/07/10 21:39:27 jfontain Exp $
.TH dbcursor tcl
.BS
.SH NAME
dbcursor \- allocate a SQL cursor
.SH SYNOPSIS
\fBdbcursor \fIconnection statement ?debugLevel?\fR
.SH DESCRIPTION
.PP
Retrieve a cursor identifier for a SQL \fISELECT\fR \fIstatement\fR using the specified \fIconnection\fR.
If successful, a unique cursor identifier is returned, which can used for row retrieval using the \fBdbcontinue\fR command.
.PP
An error occurs if the SQL statement is not successful for any reason. The error message indicates what went wrong and is engine specific.
.PP
The cursor must generally (see \fBdbcontinue\fR manual entry) be freed using the \fBdbfree\fR command when done using it.
.PP
This command must be used for all \fISELECT\fR type operations, such as \fIUNION\fR, ...
.PP
The debug level can optionally be set for this transaction (see \fBdbdebug\fR manual page).
.SH EXAMPLES
.PP
set cursor [\fBdbcursor \fI"select * from employees"\fR]
.PP
set cursor [\fBdbcursor \fI"select name from employees where id = 12345"\fR]
.PP
set cursor [\fBdbcursor \fI"select * from employees order by name"\fR]
.SH KEYWORDS
.PP
dbcursor, dbcontinue, dbfree, dbdebug, SQL, jdb, shql
