^TI^'
^TITW^upvar 
^TIS^level otherVar1 myVar1 otherVar2 myVar2...
^TI^' Command
^P^
This command arranges for one or more local variables in 
the current procedure to refer to variables in an enclosing procedure 
call or to global variables. 
^S^level
 may have any of the forms permitted for the 
^B^uplevel
 command, and may be omitted if the first letter of the first 
^S^otherVar 
 isn't # or a digit. (If omitted, 
^S^level
 defaults to 1). For each 
^S^otherVar
 argument, 
^B^upvar
 takes the variable of that name in the 
procedure frame given by 
^S^level
 (or at global level, if 
^S^level
 is #0), and makes it accessible in the current procedure as 
a variable whose name is given by the corresponding 
^S^myVar
 argument. The variable named by 
^S^otherVar
 need not exist at the time of the call; it will be created the first time 
^S^myVar
 is set, just like an ordinary variable. 
^S^myVar
 may not refer to an element of an array, but 
^S^otherVar
 may refer to an array element. 
^B^upvar
 returns an empty string.
^P^
The 
^B^upvar
 command simplifies the implementation of call-by-name procedure 
calling and also makes it easier to 
build new control constructs as Tcl procedures. For example, consider 
the following procedure:
^P^
^TW^    proc add2 name {upvar $name x; set x [expr $x+2]}
^P^
^B^add2
 is invoked with an argument giving the name of a 
variable, and it adds two to the value of that variable. 
Although 
^B^add2
 could have been implemented using 
^B^uplevel
 instead of 
^B^upvar
, the 
^B^upvar
 command makes it simpler for 
^B^add2
 to access the variable in the caller's procedure frame.
^P^
If an 
^B^upvar
 variable is unset (e.g. 
^B^x
 in 
^B^add2
 above), the unset operation affects the variable it is linked to, not 
the 
^B^upvar
 variable. There is no way to unset an 
^B^upvar
 variable except by exiting the procedure in which it is 
defined. However, it is possible to retarget an 
^B^upvar
 variable by executing another 
^B^upvar
 command.
