^TI^'
^TITW^uplevel 
^TIS^level arg...
^TI^' Command
^P^
This command executes a script in a different stack frame. If this 
statement doesn't make sense to you, you may wish to defer attempting 
to use 
^B^uplevel
 until after further reading.
^P^
All of the 
^S^arg
 arguments (there must be at least one) are concatenated as if they had 
been passed to 
^B^concat
; the result is treated as a Tcl script, which is then evaluated in the 
variable context indicated by 
^S^level
. 
^B^uplevel
 returns the 
result of that evaluation.
^B^
If 
^S^level
 is an integer then it gives a distance (i.e. how far up the 
procedure calling stack) to move before executing the command. If 
^S^level
 consists of 
^B^#
 followed by a number then 
the number gives an 
^I^absolute
 level number. If 
^S^level
 is omitted then it defaults to 1, i.e. execute in the context of the 
procedure which called the procedure containing the 
^B^uplevel
 command. 
^S^level
 cannot be defaulted if the first command argument starts with a digit or 
^B^#
, for the obvious reason that it would attempt to take the 
^S^arg
 as a 
^S^level
 value instead.
^P^
For example, suppose that procedure 
^B^procA
 was invoked from 
top-level, and that it called 
^B^procB
, and that 
^B^procB
 called 
^B^procC
. Then suppose that 
^B^procC
 invokes the 
^B^uplevel
 command. If 
^S^level
 is 
^B^1
 or 
^B^#2
 or omitted, then the command will be executed in the variable context of 
^B^procB
. If 
^S^level
 is 
^B^2
 or 
^B^#1
 then the command will be executed in the variable context of 
^B^procA
. If 
^S^level
 is 
^B^3
 or 
^B^#0
 then the command will be executed at top-level 
(only global variables will be visible).
^P^
The 
^B^uplevel
 command causes the invoking procedure to disappear from 
the procedure calling stack while the command 
is being executed. In the above example, suppose 
^B^procC
 invokes the command
^P^
^T^
^TW^uplevel 1 {set x 43; procD}
^P^
where 
^B^procD
 is another Tcl procedure. The 
^B^set
 command will modify the variable 
^B^x
 in 
^B^procB
's context, and 
^B^procD
 will execute at level 3, as if called from 
^B^procB
. If it in turn executes the command
^P^
^T^
^TW^uplevel {set x 42}
^P^
then the 
^B^set
 command will modify the same variable 
^B^x
 in 
^B^procB
's context: the procedure 
^B^procC
 does not appear to be on the 
call stack when 
^B^procB
 is executing. The command "
^B^info level
" may be used to obtain the level of the current procedure.
^P^
^B^uplevel
 makes it possible to implement new control constructs as Tcl 
procedures. For example, 
^B^uplevel
 could be used to implement the 
^B^while
 construct as a Tcl procedure. 

