^TI^'
^TITW^regexp 
^TIS^regExpr string subSpec varName
^TI^' Command
^P^
^B^regsub
 performs similarly to 
^B^regexp
 in that it attempts to match the string given by the 
^S^string
 argument to the regular expression given by the 
^S^regExpr
 argument, and if successful, leaves a result in the variable whose 
name is given by 
^S^varName
. However, 
^B^regsub
 differs from 
^B^regexp
 in that the value placed in 
^S^varName
 is not a substring of 
^S^string
; instead, the result value is formed by copying all of 
^S^string
 into 
^S^varName
, except that the portion of 
^S^string
 which matched 
^S^regExpr
 is replaced with the string given by 
^S^subSpec
. Thus, 
^B^regsub
 may be used to replace substrings of 
^S^string
 with other strings. As well, certain substrings in 
^S^subSpec
 have special meaning, which permits the value(s) substitued into 
^S^string
 to be other sections of 
^S^string
. The details of this are given in the next paragraph.
^P^
Any occurrence of "
^B^&
" or "
^B^\0
" in 
^S^subSpec
 is replaced in the result string with the portion of 
^S^string
 that matched 
^S^regExpr
. Any occurrence of a "
^B^\
^S^n
", where 
^S^n
 is a digit between 1 and 9, is replaced in the result string with that portion of 
^S^string 
 that matched the 
^I^n-th parenthesized subexpression
 of 
^S^regExpr
. The n-parenthesized subexpression of a regular expression is just that 
portion of the regular expression contained in the pair of parentheses whose 
left parenthesis is the 
^I^n
th left parenthesis in the entire regular expression, counting from the 
left and counting the first left parenthesis in the regular expression as 1.
^P^
Additional backslashes may be used in 
^S^subSpec
 to prevent special interpretation of "
^B^&
" or "
^B^\0
" or "
^B^\
^S^n
" or backslash. The use of backslashes in 
^S^subSpec
 tends to interact badly with the Tcl parser's use of backslashes, 
so it's generally safest to enclose 
^S^subSpec
 in braces if it includes backslashes.
^P^
^B^regsub
 returns 1 if it found a match, and 0 if it did not.






