^TI^'
^TITW^open 
^TIS^fileName access permissions
^TI^' Command
^P^
The 
^B^open
 command opens the named file for some operation(s) (such as reading, writing, 
or variants of these), and returns an identifier 
^S^fileID
 which is used to refer to this file by commands that might operate on 
it, such as 
^B^read
, 
^B^puts
, and so forth. On UNIX systems (at least), the 
^S^fileName
 argument may be more complex than just a filename or path; it may, for 
example, have tilde expansion performed on it, and may refer to a pipe. 
Such abilities may or may not be available on other systems. Please 
refer to the original 
^B^open
 Tcl man page for details.
^P^
The optional 
^S^access
 argument defines what exactly is going to be done with the file. The 
values that may be give for 
^S^access
, and their meanings, are listed below (if the 
^S^access
 argument is not given explicitly, it defaults to a value of '
^B^r
':
^P^
^B^r
: Open an existing file for reading only.
^P^
^B^r+
: Open an existing file for both reading and writing.
^P^
^B^w
: Open a file for writing only, creating it if need be. Any data previously 
in the file will be deleted.
^P^
^B^w+
: Open a file for writing and reading, creating it if need by. Any data 
previously in the file will be deleted.
^P^
^B^a
: Open an existing file for writing; new data will be added after any data 
already in the file.
^P^
^B^a+
: Open the file for reading and writing, creating it if need be. New data 
will start writing after the end of any data already in the file.
^P^
Note that in order to make use of those modes which allow both reading and 
writing to a file, the 
^B^seek
 command will have to be used to switch between the reading and writing modes. 
See the description of 
^B^seek
 for more details.
^P^
The 
^S^permissions
 argument is only used when a new file is created by 
^B^open
, and currently only has meaning on UNIX systems. It sets the permissions 
on the new file, in conjunction with the process's file mode creation mask. 
Its default value is 0666 (see the UNIX 
^B^chmod
 man page for details of what this means), which might perhaps be more 
permissive than desired.
^P^
^B^Note:
 The Tcl man page for 
^B^open
 contains more details than this, and as well specificies a different way 
in which 
^S^access
 argument may be given. If you find the abilities outlined here are not 
sufficient for your needs, you might wish to read the original Tcl man page 
for 
^B^open
.